/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture;

import android.content.Intent;
import com.google.zxing.BarcodeFormat;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;

final class DecodeFormatManager {
    private static final Pattern COMMA_PATTERN = Pattern.compile(",");
    private static final Set<BarcodeFormat> PRODUCT_FORMATS = EnumSet.of(BarcodeFormat.UPC_A, new BarcodeFormat[]{BarcodeFormat.UPC_E, BarcodeFormat.EAN_13, BarcodeFormat.EAN_8, BarcodeFormat.RSS_14, BarcodeFormat.RSS_EXPANDED});
    private static final Set<BarcodeFormat> INDUSTRIAL_FORMATS = EnumSet.of(BarcodeFormat.CODE_39, BarcodeFormat.CODE_93, BarcodeFormat.CODE_128, BarcodeFormat.ITF, BarcodeFormat.CODABAR);

    private DecodeFormatManager() {
    }

    static Set<BarcodeFormat> parseDecodeFormats(Intent intent) {
        String scanFormatString;
        EnumSet<BarcodeFormat> formats = EnumSet.noneOf(BarcodeFormat.class);
        if (intent.getBooleanExtra("PRODUCT_MODE", false)) {
            formats.addAll(PRODUCT_FORMATS);
        }
        if (intent.getBooleanExtra("INDUSTRIAL_MODE", false)) {
            formats.addAll(INDUSTRIAL_FORMATS);
        }
        if (intent.getBooleanExtra("QR_CODE_MODE", true)) {
            formats.add(BarcodeFormat.QR_CODE);
        }
        if (intent.getBooleanExtra("DATA_MATRIX_MODE", false)) {
            formats.add(BarcodeFormat.DATA_MATRIX);
        }
        if (intent.getBooleanExtra("AZTEC_MODE", false)) {
            formats.add(BarcodeFormat.AZTEC);
        }
        if (intent.getBooleanExtra("PDF417_MODE", false)) {
            formats.add(BarcodeFormat.PDF_417);
        }
        if ((scanFormatString = intent.getStringExtra("SCAN_FORMATS")) != null) {
            String[] scanFormats;
            for (String scanFormat : scanFormats = COMMA_PATTERN.split(scanFormatString)) {
                try {
                    formats.add(BarcodeFormat.valueOf((String)scanFormat));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
        if (formats.isEmpty()) {
            formats.add(BarcodeFormat.QR_CODE);
        }
        return formats;
    }
}

