/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture;

import android.app.Activity;
import android.content.Intent;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import java.util.Collection;
import java.util.Map;
import top.fullj.zxing.capture.DecodeFormatManager;
import top.fullj.zxing.capture.DecodeHintManager;
import top.fullj.zxing.capture.Intents;

final class CaptureIntent
implements Intents.Scan {
    private final Intent intent;

    CaptureIntent(Activity activity) {
        this(activity.getIntent());
    }

    private CaptureIntent(Intent intent) {
        this.intent = intent == null ? new Intent() : intent;
    }

    String getAction() {
        return this.intent.getAction();
    }

    String getCallbackId() {
        return this.intent.getStringExtra("SCAN_CALLBACK_ID");
    }

    Collection<BarcodeFormat> getDecodeFormats() {
        return DecodeFormatManager.parseDecodeFormats(this.intent);
    }

    Map<DecodeHintType, ?> getDecodeHints() {
        return DecodeHintManager.parseDecodeHints(this.intent);
    }

    String getCharset() {
        return this.intent.getStringExtra("CHARACTER_SET");
    }

    boolean galleryEnabled() {
        return this.intent.getBooleanExtra("ENABLE_GALLERY", false);
    }

    int getWidth() {
        return this.intent.getIntExtra("SCAN_WIDTH", 0);
    }

    int getHeight() {
        return this.intent.getIntExtra("SCAN_HEIGHT", 0);
    }

    int getCameraId() {
        return this.intent.getIntExtra("SCAN_CAMERA_ID", -1);
    }

    long getResultDisplayDuration() {
        return this.intent.getLongExtra("RESULT_DISPLAY_DURATION_MS", 1500L);
    }

    boolean isPlayBeep() {
        return this.intent.getBooleanExtra("PLAY_BEEP", true);
    }

    float getBeepVolume() {
        return this.intent.getFloatExtra("BEEP_VOLUME", 0.1f);
    }

    boolean isVibrate() {
        return this.intent.getBooleanExtra("VIBRATE", false);
    }

    long getVibrateDuration() {
        return this.intent.getLongExtra("VIBRATE_DURATION", 200L);
    }

    boolean autoOrientationDisabled() {
        return this.intent.getBooleanExtra("DISABLE_AUTO_ORIENTATION", true);
    }
}

