/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.widget.Toast;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.RGBLuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import com.google.zxing.common.HybridBinarizer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.EnumMap;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fullj.zxing.capture.AmbientLightManager;
import top.fullj.zxing.capture.BeepManager;
import top.fullj.zxing.capture.CaptureActivityHandler;
import top.fullj.zxing.capture.CaptureCallback;
import top.fullj.zxing.capture.CaptureIntent;
import top.fullj.zxing.capture.InactivityTimer;
import top.fullj.zxing.capture.R;
import top.fullj.zxing.capture.ViewfinderResultPointCallback;
import top.fullj.zxing.capture.ViewfinderView;
import top.fullj.zxing.capture.camera.CameraManager;

public class CaptureActivity
extends Activity
implements SurfaceHolder.Callback {
    private static final Logger LOG = LoggerFactory.getLogger(CaptureActivity.class);
    private static final int REQUEST_PICK_IMAGE = 100;
    private static final Map<String, CaptureCallback> captureCallbacks = new ConcurrentHashMap<String, CaptureCallback>();
    private CameraManager cameraManager;
    private CaptureActivityHandler handler;
    private ViewfinderView viewfinderView;
    private boolean hasSurface;
    private CaptureCallback captureCallback;
    private CaptureIntent intent;
    private Collection<BarcodeFormat> decodeFormats;
    private Map<DecodeHintType, ?> decodeHints;
    private InactivityTimer inactivityTimer;
    private BeepManager beepManager;
    private AmbientLightManager ambientLightManager;

    public static void startCapture(Context context, Intent intent, CaptureCallback callback) {
        String id2 = UUID.randomUUID().toString();
        intent.putExtra("SCAN_CALLBACK_ID", id2);
        captureCallbacks.put(id2, callback);
        LOG.debug("register callback: {}", (Object)id2);
        try {
            context.startActivity(intent);
        }
        catch (Exception ignore) {
            captureCallbacks.remove(id2);
        }
    }

    public Handler getHandler() {
        return this.handler;
    }

    CameraManager getCameraManager() {
        return this.cameraManager;
    }

    protected void onCreate(Bundle savedInstanceState) {
        String callbackId;
        super.onCreate(savedInstanceState);
        Window window = this.getWindow();
        window.addFlags(128);
        window.addFlags(8192);
        this.setContentView(R.layout.activity_capture);
        this.viewfinderView = (ViewfinderView)this.findViewById(R.id.viewfinder_view);
        this.intent = new CaptureIntent(this);
        if (this.intent.galleryEnabled()) {
            this.findViewById(R.id.btn_enable_gallery).setVisibility(0);
        }
        if (!TextUtils.isEmpty((CharSequence)(callbackId = this.intent.getCallbackId()))) {
            this.captureCallback = captureCallbacks.remove(callbackId);
            LOG.debug("unregister callback: {}", (Object)callbackId);
        }
        this.decodeFormats = this.intent.getDecodeFormats();
        this.decodeHints = this.intent.getDecodeHints();
        this.hasSurface = false;
        this.inactivityTimer = new InactivityTimer(this);
        this.beepManager = new BeepManager(this);
        this.ambientLightManager = new AmbientLightManager(this);
    }

    protected void onResume() {
        super.onResume();
        this.cameraManager = new CameraManager(this);
        this.viewfinderView.setCameraManager(this.cameraManager);
        this.handler = null;
        if (this.intent.autoOrientationDisabled()) {
            this.setRequestedOrientation(this.getCurrentOrientation());
        } else {
            this.setRequestedOrientation(7);
        }
        this.beepManager.updatePrefs();
        this.ambientLightManager.start(this.cameraManager);
        this.inactivityTimer.onResume();
        int width = this.intent.getWidth();
        int height = this.intent.getHeight();
        if (width > 0 && height > 0) {
            this.cameraManager.setManualFramingRect(width, height);
        }
        this.cameraManager.setManualCameraId(this.intent.getCameraId());
        SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.preview_view);
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        if (this.hasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        }
    }

    @SuppressLint(value={"SwitchIntDef"})
    private int getCurrentOrientation() {
        int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        if (this.getResources().getConfiguration().orientation == 2) {
            switch (rotation) {
                case 0: 
                case 1: {
                    return 0;
                }
            }
            return 8;
        }
        switch (rotation) {
            case 0: 
            case 3: {
                return 1;
            }
        }
        return 9;
    }

    protected void onPause() {
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        this.inactivityTimer.onPause();
        this.ambientLightManager.stop();
        this.beepManager.close();
        this.cameraManager.closeDriver();
        if (!this.hasSurface) {
            SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.preview_view);
            SurfaceHolder surfaceHolder = surfaceView.getHolder();
            surfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }
        super.onPause();
    }

    protected void onDestroy() {
        this.inactivityTimer.shutdown();
        super.onDestroy();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                this.cancel();
                return true;
            }
            case 25: {
                this.cameraManager.setTorch(false);
                return true;
            }
            case 24: {
                this.cameraManager.setTorch(true);
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 100 && resultCode == -1 && data != null && data.getData() != null) {
            this.onImagePicked(data.getData());
        }
        super.onActivityResult(requestCode, resultCode, data);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Result decodeBitmap(Bitmap bitmap) {
        long start = System.nanoTime();
        MultiFormatReader reader = new MultiFormatReader();
        reader.setHints(this.getHints());
        int width = bitmap.getWidth();
        int height = bitmap.getHeight();
        int[] pixels = new int[width * height];
        bitmap.getPixels(pixels, 0, width, 0, 0, width, height);
        RGBLuminanceSource source = new RGBLuminanceSource(width, height, pixels);
        BinaryBitmap binaryBitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
        Result rawResult = null;
        try {
            rawResult = reader.decodeWithState(binaryBitmap);
        }
        catch (ReaderException readerException) {
        }
        finally {
            reader.reset();
        }
        long ts = System.nanoTime() - start;
        LOG.info("Decode bitmap in " + TimeUnit.NANOSECONDS.toMillis(ts) + " ms");
        return rawResult;
    }

    private void onImagePicked(Uri uri) {
        new Thread(() -> {
            Bitmap bitmap = this.readBitmap(uri);
            if (bitmap != null) {
                Result result = this.decodeBitmap(bitmap);
                Bitmap barcode = bitmap.copy(Bitmap.Config.ARGB_8888, true);
                if (result != null) {
                    this.runOnUiThread(() -> this.handleDecode(result, barcode, 1.0f));
                }
            }
        }).start();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Bitmap readBitmap(Uri uri) {
        try (InputStream is = this.getContentResolver().openInputStream(uri);){
            if (is == null) {
                throw new FileNotFoundException("null stream");
            }
            Bitmap bitmap = BitmapFactory.decodeStream((InputStream)is);
            return bitmap;
        }
        catch (IOException e) {
            LOG.warn("read bitmap[{}] error: {}", (Object)uri, (Object)e.getMessage());
            return null;
        }
    }

    public void onPickImage(View view) {
        Intent intent = new Intent("android.intent.action.PICK");
        intent.setType("image/*");
        try {
            this.startActivityForResult(intent, 100);
        }
        catch (Exception e) {
            LOG.error("Unable to request image from album!", (Throwable)e);
            Toast.makeText((Context)this, (CharSequence)"Unable to request image from album!", (int)0).show();
        }
    }

    public void onCancel(View view) {
        this.cancel();
    }

    void cancel() {
        this.setResult(0);
        this.finish();
        if (this.captureCallback != null) {
            this.captureCallback.onCancelled();
        }
    }

    void done(Intent intent) {
        this.setResult(-1, intent);
        this.finish();
        if (this.captureCallback != null) {
            this.captureCallback.onCaptured(intent);
        }
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (holder == null) {
            LOG.error("*** WARNING *** surfaceCreated() gave us a null surface!");
        }
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        if (surfaceHolder == null) {
            throw new IllegalStateException("No SurfaceHolder provided");
        }
        if (this.cameraManager.isOpen()) {
            LOG.warn("initCamera() while already open -- late SurfaceView callback?");
            return;
        }
        try {
            this.cameraManager.openDriver(surfaceHolder);
            if (this.handler == null) {
                this.handler = new CaptureActivityHandler(this, this.cameraManager);
            }
        }
        catch (IOException ioe) {
            LOG.error(ioe.getMessage(), (Throwable)ioe);
            this.displayFrameworkBugMessageAndExit();
        }
        catch (RuntimeException e) {
            LOG.error("Unexpected error initializing camera", (Throwable)e);
            this.displayFrameworkBugMessageAndExit();
        }
    }

    private void displayFrameworkBugMessageAndExit() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)this.getString(R.string.app_name));
        builder.setMessage((CharSequence)this.getString(R.string.msg_camera_framework_bug));
        builder.setPositiveButton(R.string.button_ok, (dialog, which) -> this.cancel());
        builder.setOnCancelListener(dialog -> this.cancel());
        builder.show();
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    public void handleDecode(Result rawResult, Bitmap barcode, float scaleFactor) {
        this.inactivityTimer.onActivity();
        this.beepManager.playBeepSoundAndVibrate();
        if (barcode != null) {
            this.drawResultPoints(barcode, scaleFactor, rawResult);
            this.viewfinderView.drawResultBitmap(barcode);
        }
        this.sendScanResult(this.rawResultToIntent(rawResult));
    }

    private void drawResultPoints(Bitmap barcode, float scaleFactor, Result rawResult) {
        ResultPoint[] points = rawResult.getResultPoints();
        if (points != null && points.length > 0) {
            Canvas canvas = new Canvas(barcode);
            Paint paint = new Paint();
            paint.setColor(this.getResources().getColor(R.color.result_points));
            if (points.length == 2) {
                paint.setStrokeWidth(4.0f);
                CaptureActivity.drawLine(canvas, paint, points[0], points[1], scaleFactor);
            } else if (points.length == 4 && (rawResult.getBarcodeFormat() == BarcodeFormat.UPC_A || rawResult.getBarcodeFormat() == BarcodeFormat.EAN_13)) {
                CaptureActivity.drawLine(canvas, paint, points[0], points[1], scaleFactor);
                CaptureActivity.drawLine(canvas, paint, points[2], points[3], scaleFactor);
            } else {
                paint.setStrokeWidth(10.0f);
                for (ResultPoint point : points) {
                    if (point == null) continue;
                    canvas.drawPoint(scaleFactor * point.getX(), scaleFactor * point.getY(), paint);
                }
            }
        }
    }

    private static void drawLine(Canvas canvas, Paint paint, ResultPoint a, ResultPoint b, float scaleFactor) {
        if (a != null && b != null) {
            canvas.drawLine(scaleFactor * a.getX(), scaleFactor * a.getY(), scaleFactor * b.getX(), scaleFactor * b.getY(), paint);
        }
    }

    private Intent rawResultToIntent(Result rawResult) {
        Map metadata;
        Intent intent = new Intent(this.intent.getAction());
        intent.putExtra("SCAN_RESULT", rawResult.toString());
        intent.putExtra("SCAN_RESULT_FORMAT", rawResult.getBarcodeFormat().toString());
        byte[] rawBytes = rawResult.getRawBytes();
        if (rawBytes != null && rawBytes.length > 0) {
            intent.putExtra("SCAN_RESULT_BYTES", rawBytes);
        }
        if ((metadata = rawResult.getResultMetadata()) != null) {
            Iterable byteSegments;
            String ecLevel;
            Number orientation;
            Object upcEanExt = metadata.get(ResultMetadataType.UPC_EAN_EXTENSION);
            if (upcEanExt != null) {
                intent.putExtra("SCAN_RESULT_UPC_EAN_EXTENSION", upcEanExt.toString());
            }
            if ((orientation = (Number)metadata.get(ResultMetadataType.ORIENTATION)) != null) {
                intent.putExtra("SCAN_RESULT_ORIENTATION", orientation.intValue());
            }
            if ((ecLevel = (String)metadata.get(ResultMetadataType.ERROR_CORRECTION_LEVEL)) != null) {
                intent.putExtra("SCAN_RESULT_ERROR_CORRECTION_LEVEL", ecLevel);
            }
            if ((byteSegments = (Iterable)metadata.get(ResultMetadataType.BYTE_SEGMENTS)) != null) {
                int i = 0;
                for (byte[] byteSegment : byteSegments) {
                    intent.putExtra("SCAN_RESULT_BYTE_SEGMENTS_" + i, byteSegment);
                    ++i;
                }
            }
        }
        return intent;
    }

    private void sendScanResult(Intent arg) {
        if (this.handler != null) {
            long delayMS = this.intent.getResultDisplayDuration();
            Message message = Message.obtain((Handler)this.handler, (int)1005, (Object)arg);
            if (delayMS > 0L) {
                this.handler.sendMessageDelayed(message, delayMS);
            } else {
                this.handler.sendMessage(message);
            }
        } else {
            this.done(arg);
        }
    }

    Map<DecodeHintType, Object> getHints() {
        EnumMap<DecodeHintType, Object> hints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        if (this.decodeHints != null) {
            hints.putAll(this.decodeHints);
        }
        hints.put(DecodeHintType.POSSIBLE_FORMATS, (Object)this.decodeFormats);
        String charset = this.intent.getCharset();
        if (charset != null) {
            hints.put(DecodeHintType.CHARACTER_SET, (Object)charset);
        }
        hints.put(DecodeHintType.NEED_RESULT_POINT_CALLBACK, (Object)new ViewfinderResultPointCallback(this.viewfinderView));
        return hints;
    }
}

