/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Vibrator;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fullj.zxing.capture.CaptureIntent;
import top.fullj.zxing.capture.R;

final class BeepManager
implements MediaPlayer.OnErrorListener,
Closeable {
    private static final Logger LOG = LoggerFactory.getLogger(BeepManager.class);
    private final Activity activity;
    private MediaPlayer mediaPlayer;
    private boolean playBeep;
    private float beepVolume;
    private boolean vibrate;
    private long vibrateDuration;

    BeepManager(Activity activity) {
        AudioManager audioService;
        this.activity = activity;
        CaptureIntent intent = new CaptureIntent(activity);
        this.playBeep = intent.isPlayBeep();
        this.beepVolume = intent.getBeepVolume();
        this.vibrate = intent.isVibrate();
        this.vibrateDuration = intent.getVibrateDuration();
        if (this.playBeep && (audioService = (AudioManager)activity.getSystemService("audio")).getRingerMode() != 2) {
            this.playBeep = false;
        }
        this.updatePrefs();
    }

    synchronized void updatePrefs() {
        if (this.playBeep && this.mediaPlayer == null) {
            this.activity.setVolumeControlStream(5);
            this.mediaPlayer = this.buildMediaPlayer((Context)this.activity);
        }
    }

    synchronized void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            Vibrator vibrator = (Vibrator)this.activity.getSystemService("vibrator");
            vibrator.vibrate(this.vibrateDuration);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MediaPlayer buildMediaPlayer(Context activity) {
        MediaPlayer mediaPlayer2 = new MediaPlayer();
        try (AssetFileDescriptor file = activity.getResources().openRawResourceFd(R.raw.beep);){
            mediaPlayer2.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
            mediaPlayer2.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            mediaPlayer2.setAudioStreamType(5);
            mediaPlayer2.setLooping(false);
            mediaPlayer2.setVolume(this.beepVolume, this.beepVolume);
            mediaPlayer2.prepare();
            MediaPlayer mediaPlayer = mediaPlayer2;
            return mediaPlayer;
        }
        catch (IOException e) {
            LOG.error("build MediaPlayer failed: {}", (Object)e.getMessage());
            mediaPlayer2.release();
            return null;
        }
    }

    public synchronized boolean onError(MediaPlayer mp, int what, int extra) {
        if (what != 100) {
            this.close();
            this.updatePrefs();
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }
}

