/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture;

import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import top.fullj.zxing.capture.CaptureActivity;
import top.fullj.zxing.capture.CaptureOptions;
import top.fullj.zxing.capture.camera.CameraManager;
import top.fullj.zxing.capture.camera.FrontLightMode;

final class AmbientLightManager
implements SensorEventListener {
    private static final float TOO_DARK_LUX = 45.0f;
    private static final float BRIGHT_ENOUGH_LUX = 450.0f;
    private final CaptureActivity activity;
    private CameraManager cameraManager;
    private Sensor lightSensor;

    AmbientLightManager(CaptureActivity activity) {
        this.activity = activity;
    }

    void start(CameraManager cameraManager) {
        this.cameraManager = cameraManager;
        if (CaptureOptions.FRONT_LIGHT_MODE == FrontLightMode.AUTO) {
            SensorManager sensorManager = (SensorManager)this.activity.getSystemService("sensor");
            this.lightSensor = sensorManager.getDefaultSensor(5);
            if (this.lightSensor != null) {
                sensorManager.registerListener((SensorEventListener)this, this.lightSensor, 3);
            }
        }
    }

    void stop() {
        if (this.lightSensor != null) {
            SensorManager sensorManager = (SensorManager)this.activity.getSystemService("sensor");
            sensorManager.unregisterListener((SensorEventListener)this);
            this.cameraManager = null;
            this.lightSensor = null;
        }
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        float ambientLightLux = sensorEvent.values[0];
        if (this.cameraManager != null) {
            if (ambientLightLux <= 45.0f) {
                this.cameraManager.setTorch(true);
            } else if (ambientLightLux >= 450.0f) {
                this.cameraManager.setTorch(false);
            }
        }
    }

    public void onAccuracyChanged(Sensor sensor, int accuracy) {
    }
}

