/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture.clipboard;

import android.content.ClipData;
import android.content.ClipboardManager;
import android.content.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClipboardInterface {
    private static final Logger logger = LoggerFactory.getLogger((String)"ClipboardInterface");

    private ClipboardInterface() {
    }

    public static CharSequence getText(Context context) {
        ClipboardManager clipboard = ClipboardInterface.getManager(context);
        ClipData clip = clipboard.getPrimaryClip();
        return clip != null && ClipboardInterface.hasText(context) ? clip.getItemAt(0).coerceToText(context) : null;
    }

    public static void setText(CharSequence text, Context context) {
        if (text != null) {
            try {
                ClipboardInterface.getManager(context).setPrimaryClip(ClipData.newPlainText(null, (CharSequence)text));
            }
            catch (IllegalStateException | NullPointerException | SecurityException e) {
                logger.warn("Clipboard bug", (Throwable)e);
            }
        }
    }

    private static boolean hasText(Context context) {
        ClipboardManager clipboard = ClipboardInterface.getManager(context);
        ClipData clip = clipboard.getPrimaryClip();
        return clip != null && clip.getItemCount() > 0;
    }

    private static ClipboardManager getManager(Context context) {
        return (ClipboardManager)context.getSystemService("clipboard");
    }
}

