/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture.camera.open;

import android.hardware.Camera;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fullj.zxing.capture.camera.open.CameraFacing;
import top.fullj.zxing.capture.camera.open.OpenCamera;

public final class OpenCameraInterface {
    private static final Logger logger = LoggerFactory.getLogger((String)"OpenCameraInterface");
    public static final int NO_REQUESTED_CAMERA = -1;

    private OpenCameraInterface() {
    }

    public static OpenCamera open(int cameraId) {
        Camera.CameraInfo cameraInfo;
        int numCameras = Camera.getNumberOfCameras();
        if (numCameras == 0) {
            logger.warn("No cameras!");
            return null;
        }
        if (cameraId >= numCameras) {
            logger.warn("Requested camera does not exist: {}", (Object)cameraId);
            return null;
        }
        if (cameraId <= -1) {
            for (cameraId = 0; cameraId < numCameras; ++cameraId) {
                cameraInfo = new Camera.CameraInfo();
                Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
                if (CameraFacing.values()[cameraInfo.facing] == CameraFacing.BACK) break;
            }
            if (cameraId == numCameras) {
                logger.info("No camera facing {}; returning camera #0", (Object)CameraFacing.BACK);
                cameraId = 0;
            }
        }
        logger.info("Opening camera #{}", (Object)cameraId);
        cameraInfo = new Camera.CameraInfo();
        Camera.getCameraInfo((int)cameraId, (Camera.CameraInfo)cameraInfo);
        Camera camera = Camera.open((int)cameraId);
        if (camera == null) {
            return null;
        }
        return new OpenCamera(cameraId, camera, CameraFacing.values()[cameraInfo.facing], cameraInfo.orientation);
    }
}

