/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture;

import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.Result;
import java.util.Collection;
import java.util.Map;
import top.fullj.zxing.capture.CaptureActivity;
import top.fullj.zxing.capture.DecodeThread;
import top.fullj.zxing.capture.ViewfinderResultPointCallback;
import top.fullj.zxing.capture.camera.CameraManager;

public final class CaptureActivityHandler
extends Handler {
    private final CaptureActivity activity;
    private final DecodeThread decodeThread;
    private State state;
    private final CameraManager cameraManager;

    CaptureActivityHandler(CaptureActivity activity, Collection<BarcodeFormat> decodeFormats, Map<DecodeHintType, ?> baseHints, String characterSet, CameraManager cameraManager) {
        this.activity = activity;
        this.decodeThread = new DecodeThread(activity, decodeFormats, baseHints, characterSet, new ViewfinderResultPointCallback(activity.getViewfinderView()));
        this.decodeThread.start();
        this.state = State.SUCCESS;
        this.cameraManager = cameraManager;
        cameraManager.startPreview();
        this.restartPreviewAndDecode();
    }

    public void handleMessage(Message message) {
        switch (message.what) {
            case 1004: {
                this.restartPreviewAndDecode();
                break;
            }
            case 1002: {
                this.state = State.SUCCESS;
                Bundle bundle = message.getData();
                Bitmap barcode = null;
                float scaleFactor = 1.0f;
                if (bundle != null) {
                    byte[] compressedBitmap = bundle.getByteArray("barcode_bitmap");
                    if (compressedBitmap != null) {
                        barcode = BitmapFactory.decodeByteArray((byte[])compressedBitmap, (int)0, (int)compressedBitmap.length, null);
                        barcode = barcode.copy(Bitmap.Config.ARGB_8888, true);
                    }
                    scaleFactor = bundle.getFloat("barcode_scaled_factor");
                }
                this.activity.handleDecode((Result)message.obj, barcode, scaleFactor);
                break;
            }
            case 1003: {
                this.state = State.PREVIEW;
                this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), 1000);
                break;
            }
            case 1005: {
                this.activity.setResult(-1, (Intent)message.obj);
                this.activity.finish();
            }
        }
    }

    public void quitSynchronously() {
        this.state = State.DONE;
        this.cameraManager.stopPreview();
        Message quit = Message.obtain((Handler)this.decodeThread.getHandler(), (int)1001);
        quit.sendToTarget();
        try {
            this.decodeThread.join(500L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.removeMessages(1002);
        this.removeMessages(1003);
    }

    private void restartPreviewAndDecode() {
        if (this.state == State.SUCCESS) {
            this.state = State.PREVIEW;
            this.cameraManager.requestPreviewFrame(this.decodeThread.getHandler(), 1000);
            this.activity.drawViewfinder();
        }
    }

    private static enum State {
        PREVIEW,
        SUCCESS,
        DONE;

    }
}

