/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.SurfaceHolder;
import android.view.SurfaceView;
import android.view.View;
import android.view.Window;
import android.widget.TextView;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.DecodeHintType;
import com.google.zxing.Result;
import com.google.zxing.ResultMetadataType;
import com.google.zxing.ResultPoint;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fullj.zxing.capture.AmbientLightManager;
import top.fullj.zxing.capture.BeepManager;
import top.fullj.zxing.capture.CaptureActivityHandler;
import top.fullj.zxing.capture.CaptureOptions;
import top.fullj.zxing.capture.DecodeFormatManager;
import top.fullj.zxing.capture.DecodeHintManager;
import top.fullj.zxing.capture.FinishListener;
import top.fullj.zxing.capture.InactivityTimer;
import top.fullj.zxing.capture.IntentSource;
import top.fullj.zxing.capture.R;
import top.fullj.zxing.capture.ViewfinderView;
import top.fullj.zxing.capture.camera.CameraManager;
import top.fullj.zxing.capture.clipboard.ClipboardInterface;

public class CaptureActivity
extends Activity
implements SurfaceHolder.Callback {
    private static final Logger logger = LoggerFactory.getLogger((String)"CaptureActivity");
    private static final long DEFAULT_INTENT_RESULT_DURATION_MS = 1500L;
    private CameraManager cameraManager;
    private CaptureActivityHandler handler;
    private Result savedResultToShow;
    private ViewfinderView viewfinderView;
    private TextView statusView;
    private Result lastResult;
    private boolean hasSurface;
    private boolean copyToClipboard;
    private IntentSource source;
    private Collection<BarcodeFormat> decodeFormats;
    private Map<DecodeHintType, ?> decodeHints;
    private String characterSet;
    private InactivityTimer inactivityTimer;
    private BeepManager beepManager;
    private AmbientLightManager ambientLightManager;

    ViewfinderView getViewfinderView() {
        return this.viewfinderView;
    }

    public Handler getHandler() {
        return this.handler;
    }

    CameraManager getCameraManager() {
        return this.cameraManager;
    }

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Window window = this.getWindow();
        window.addFlags(128);
        window.addFlags(8192);
        this.setContentView(R.layout.activity_capture);
        this.hasSurface = false;
        this.inactivityTimer = new InactivityTimer(this);
        this.beepManager = new BeepManager(this);
        this.ambientLightManager = new AmbientLightManager((Context)this);
    }

    protected void onResume() {
        super.onResume();
        this.cameraManager = new CameraManager((Context)this.getApplication());
        this.viewfinderView = (ViewfinderView)this.findViewById(R.id.viewfinder_view);
        this.viewfinderView.setCameraManager(this.cameraManager);
        this.statusView = (TextView)this.findViewById(R.id.status_view);
        this.handler = null;
        this.lastResult = null;
        if (CaptureOptions.DISABLE_AUTO_ORIENTATION) {
            this.setRequestedOrientation(this.getCurrentOrientation());
        } else {
            this.setRequestedOrientation(7);
        }
        this.resetStatusView();
        this.beepManager.updatePrefs();
        this.ambientLightManager.start(this.cameraManager);
        this.inactivityTimer.onResume();
        Intent intent = this.getIntent();
        this.copyToClipboard = CaptureOptions.COPY_TO_CLIPBOARD;
        this.source = IntentSource.NONE;
        this.decodeFormats = null;
        this.characterSet = null;
        if (intent != null) {
            if ("com.google.zxing.client.android.SCAN".equals(intent.getAction())) {
                String customPromptMessage;
                int cameraId;
                this.source = IntentSource.NATIVE_APP_INTENT;
                this.decodeFormats = DecodeFormatManager.parseDecodeFormats(intent);
                this.decodeHints = DecodeHintManager.parseDecodeHints(intent);
                if (intent.hasExtra("SCAN_WIDTH") && intent.hasExtra("SCAN_HEIGHT")) {
                    int width = intent.getIntExtra("SCAN_WIDTH", 0);
                    int height = intent.getIntExtra("SCAN_HEIGHT", 0);
                    if (width > 0 && height > 0) {
                        this.cameraManager.setManualFramingRect(width, height);
                    }
                }
                if (intent.hasExtra("SCAN_CAMERA_ID") && (cameraId = intent.getIntExtra("SCAN_CAMERA_ID", -1)) >= 0) {
                    this.cameraManager.setManualCameraId(cameraId);
                }
                if ((customPromptMessage = intent.getStringExtra("PROMPT_MESSAGE")) != null) {
                    this.statusView.setText((CharSequence)customPromptMessage);
                }
            }
            this.characterSet = intent.getStringExtra("CHARACTER_SET");
        }
        SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.preview_view);
        SurfaceHolder surfaceHolder = surfaceView.getHolder();
        if (this.hasSurface) {
            this.initCamera(surfaceHolder);
        } else {
            surfaceHolder.addCallback((SurfaceHolder.Callback)this);
        }
    }

    @SuppressLint(value={"SwitchIntDef"})
    private int getCurrentOrientation() {
        int rotation = this.getWindowManager().getDefaultDisplay().getRotation();
        if (this.getResources().getConfiguration().orientation == 2) {
            switch (rotation) {
                case 0: 
                case 1: {
                    return 0;
                }
            }
            return 8;
        }
        switch (rotation) {
            case 0: 
            case 3: {
                return 1;
            }
        }
        return 9;
    }

    protected void onPause() {
        if (this.handler != null) {
            this.handler.quitSynchronously();
            this.handler = null;
        }
        this.inactivityTimer.onPause();
        this.ambientLightManager.stop();
        this.beepManager.close();
        this.cameraManager.closeDriver();
        if (!this.hasSurface) {
            SurfaceView surfaceView = (SurfaceView)this.findViewById(R.id.preview_view);
            SurfaceHolder surfaceHolder = surfaceView.getHolder();
            surfaceHolder.removeCallback((SurfaceHolder.Callback)this);
        }
        super.onPause();
    }

    protected void onDestroy() {
        this.inactivityTimer.shutdown();
        super.onDestroy();
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        switch (keyCode) {
            case 4: {
                if (this.source == IntentSource.NATIVE_APP_INTENT) {
                    this.setResult(0);
                    this.finish();
                    return true;
                }
                if (this.source != IntentSource.NONE && this.source != IntentSource.ZXING_LINK || this.lastResult == null) break;
                this.restartPreviewAfterDelay(0L);
                return true;
            }
            case 27: 
            case 80: {
                return true;
            }
            case 25: {
                this.cameraManager.setTorch(false);
                return true;
            }
            case 24: {
                this.cameraManager.setTorch(true);
                return true;
            }
        }
        return super.onKeyDown(keyCode, event);
    }

    public void onCancel(View view) {
        this.setResult(0);
        this.finish();
    }

    public void surfaceCreated(SurfaceHolder holder) {
        if (holder == null) {
            logger.error("*** WARNING *** surfaceCreated() gave us a null surface!");
        }
        if (!this.hasSurface) {
            this.hasSurface = true;
            this.initCamera(holder);
        }
    }

    public void surfaceChanged(SurfaceHolder holder, int format, int width, int height) {
    }

    public void surfaceDestroyed(SurfaceHolder holder) {
        this.hasSurface = false;
    }

    private void initCamera(SurfaceHolder surfaceHolder) {
        if (surfaceHolder == null) {
            throw new IllegalStateException("No SurfaceHolder provided");
        }
        if (this.cameraManager.isOpen()) {
            logger.warn("initCamera() while already open -- late SurfaceView callback?");
            return;
        }
        try {
            this.cameraManager.openDriver(surfaceHolder);
            if (this.handler == null) {
                this.handler = new CaptureActivityHandler(this, this.decodeFormats, this.decodeHints, this.characterSet, this.cameraManager);
            }
            this.decodeOrStoreSavedBitmap(null, null);
        }
        catch (IOException ioe) {
            logger.warn(ioe.getMessage(), (Throwable)ioe);
            this.displayFrameworkBugMessageAndExit();
        }
        catch (RuntimeException e) {
            logger.warn("Unexpected error initializing camera", (Throwable)e);
            this.displayFrameworkBugMessageAndExit();
        }
    }

    private void decodeOrStoreSavedBitmap(Bitmap bitmap, Result result) {
        if (this.handler == null) {
            this.savedResultToShow = result;
        } else {
            if (result != null) {
                this.savedResultToShow = result;
            }
            if (this.savedResultToShow != null) {
                Message message = Message.obtain((Handler)this.handler, (int)1002, (Object)this.savedResultToShow);
                this.handler.sendMessage(message);
            }
            this.savedResultToShow = null;
        }
    }

    private void displayFrameworkBugMessageAndExit() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setTitle((CharSequence)this.getString(R.string.app_name));
        builder.setMessage((CharSequence)this.getString(R.string.msg_camera_framework_bug));
        builder.setPositiveButton(R.string.button_ok, (DialogInterface.OnClickListener)new FinishListener(this));
        builder.setOnCancelListener((DialogInterface.OnCancelListener)new FinishListener(this));
        builder.show();
    }

    public void restartPreviewAfterDelay(long delayMS) {
        if (this.handler != null) {
            this.handler.sendEmptyMessageDelayed(1004, delayMS);
        }
        this.resetStatusView();
    }

    private void resetStatusView() {
        this.statusView.setText(R.string.msg_default_status);
        this.lastResult = null;
    }

    public void drawViewfinder() {
        this.viewfinderView.drawViewfinder();
    }

    public void handleDecode(Result rawResult, Bitmap barcode, float scaleFactor) {
        boolean fromLiveScan;
        this.inactivityTimer.onActivity();
        this.lastResult = rawResult;
        boolean bl = fromLiveScan = barcode != null;
        if (fromLiveScan) {
            this.beepManager.playBeepSoundAndVibrate();
            this.drawResultPoints(barcode, scaleFactor, rawResult);
        }
        if (this.source == IntentSource.NATIVE_APP_INTENT) {
            this.handleDecodeExternally(rawResult, barcode);
        }
    }

    private void drawResultPoints(Bitmap barcode, float scaleFactor, Result rawResult) {
        ResultPoint[] points = rawResult.getResultPoints();
        if (points != null && points.length > 0) {
            Canvas canvas = new Canvas(barcode);
            Paint paint = new Paint();
            paint.setColor(this.getResources().getColor(R.color.result_points));
            if (points.length == 2) {
                paint.setStrokeWidth(4.0f);
                CaptureActivity.drawLine(canvas, paint, points[0], points[1], scaleFactor);
            } else if (points.length == 4 && (rawResult.getBarcodeFormat() == BarcodeFormat.UPC_A || rawResult.getBarcodeFormat() == BarcodeFormat.EAN_13)) {
                CaptureActivity.drawLine(canvas, paint, points[0], points[1], scaleFactor);
                CaptureActivity.drawLine(canvas, paint, points[2], points[3], scaleFactor);
            } else {
                paint.setStrokeWidth(10.0f);
                for (ResultPoint point : points) {
                    if (point == null) continue;
                    canvas.drawPoint(scaleFactor * point.getX(), scaleFactor * point.getY(), paint);
                }
            }
        }
    }

    private static void drawLine(Canvas canvas, Paint paint, ResultPoint a, ResultPoint b, float scaleFactor) {
        if (a != null && b != null) {
            canvas.drawLine(scaleFactor * a.getX(), scaleFactor * a.getY(), scaleFactor * b.getX(), scaleFactor * b.getY(), paint);
        }
    }

    private void handleDecodeExternally(Result rawResult, Bitmap barcode) {
        if (barcode != null) {
            this.viewfinderView.drawResultBitmap(barcode);
        }
        long resultDurationMS = this.getIntent() == null ? 1500L : this.getIntent().getLongExtra("RESULT_DISPLAY_DURATION_MS", 1500L);
        this.maybeSetClipboard(rawResult.getText());
        if (this.source == IntentSource.NATIVE_APP_INTENT) {
            Map metadata;
            Intent intent = new Intent(this.getIntent().getAction());
            intent.addFlags(524288);
            intent.putExtra("SCAN_RESULT", rawResult.toString());
            intent.putExtra("SCAN_RESULT_FORMAT", rawResult.getBarcodeFormat().toString());
            byte[] rawBytes = rawResult.getRawBytes();
            if (rawBytes != null && rawBytes.length > 0) {
                intent.putExtra("SCAN_RESULT_BYTES", rawBytes);
            }
            if ((metadata = rawResult.getResultMetadata()) != null) {
                Iterable byteSegments;
                String ecLevel;
                Number orientation;
                if (metadata.containsKey(ResultMetadataType.UPC_EAN_EXTENSION)) {
                    intent.putExtra("SCAN_RESULT_UPC_EAN_EXTENSION", metadata.get(ResultMetadataType.UPC_EAN_EXTENSION).toString());
                }
                if ((orientation = (Number)metadata.get(ResultMetadataType.ORIENTATION)) != null) {
                    intent.putExtra("SCAN_RESULT_ORIENTATION", orientation.intValue());
                }
                if ((ecLevel = (String)metadata.get(ResultMetadataType.ERROR_CORRECTION_LEVEL)) != null) {
                    intent.putExtra("SCAN_RESULT_ERROR_CORRECTION_LEVEL", ecLevel);
                }
                if ((byteSegments = (Iterable)metadata.get(ResultMetadataType.BYTE_SEGMENTS)) != null) {
                    int i = 0;
                    for (byte[] byteSegment : byteSegments) {
                        intent.putExtra("SCAN_RESULT_BYTE_SEGMENTS_" + i, byteSegment);
                        ++i;
                    }
                }
            }
            this.sendReplyMessage(1005, intent, resultDurationMS);
        }
    }

    private void maybeSetClipboard(String text) {
        if (this.copyToClipboard && !TextUtils.isEmpty((CharSequence)text)) {
            ClipboardInterface.setText(text, (Context)this);
        }
    }

    private void sendReplyMessage(int id2, Object arg, long delayMS) {
        if (this.handler != null) {
            Message message = Message.obtain((Handler)this.handler, (int)id2, (Object)arg);
            if (delayMS > 0L) {
                this.handler.sendMessageDelayed(message, delayMS);
            } else {
                this.handler.sendMessage(message);
            }
        }
    }
}

