/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.media.AudioManager;
import android.media.MediaPlayer;
import android.os.Vibrator;
import java.io.Closeable;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fullj.zxing.capture.CaptureOptions;
import top.fullj.zxing.capture.R;

final class BeepManager
implements MediaPlayer.OnErrorListener,
Closeable {
    private static final Logger logger = LoggerFactory.getLogger((String)"BeepManager");
    private static final float BEEP_VOLUME = 0.1f;
    private static final long VIBRATE_DURATION = 200L;
    private final Activity activity;
    private MediaPlayer mediaPlayer;
    private boolean playBeep;
    private boolean vibrate;

    BeepManager(Activity activity) {
        this.activity = activity;
        this.mediaPlayer = null;
        this.updatePrefs();
    }

    synchronized void updatePrefs() {
        this.playBeep = BeepManager.shouldBeep((Context)this.activity);
        this.vibrate = CaptureOptions.VIBRATE;
        if (this.playBeep && this.mediaPlayer == null) {
            this.activity.setVolumeControlStream(3);
            this.mediaPlayer = this.buildMediaPlayer((Context)this.activity);
        }
    }

    synchronized void playBeepSoundAndVibrate() {
        if (this.playBeep && this.mediaPlayer != null) {
            this.mediaPlayer.start();
        }
        if (this.vibrate) {
            Vibrator vibrator = (Vibrator)this.activity.getSystemService("vibrator");
            vibrator.vibrate(200L);
        }
    }

    private static boolean shouldBeep(Context activity) {
        AudioManager audioService;
        boolean shouldPlayBeep = CaptureOptions.PLAY_BEEP;
        if (shouldPlayBeep && (audioService = (AudioManager)activity.getSystemService("audio")).getRingerMode() != 2) {
            shouldPlayBeep = false;
        }
        return shouldPlayBeep;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MediaPlayer buildMediaPlayer(Context activity) {
        MediaPlayer mediaPlayer2 = new MediaPlayer();
        try (AssetFileDescriptor file = activity.getResources().openRawResourceFd(R.raw.beep);){
            mediaPlayer2.setDataSource(file.getFileDescriptor(), file.getStartOffset(), file.getLength());
            mediaPlayer2.setOnErrorListener((MediaPlayer.OnErrorListener)this);
            mediaPlayer2.setAudioStreamType(3);
            mediaPlayer2.setLooping(false);
            mediaPlayer2.setVolume(0.1f, 0.1f);
            mediaPlayer2.prepare();
            MediaPlayer mediaPlayer = mediaPlayer2;
            return mediaPlayer;
        }
        catch (IOException ioe) {
            logger.warn("build MediaPlayer failed", (Throwable)ioe);
            mediaPlayer2.release();
            return null;
        }
    }

    public synchronized boolean onError(MediaPlayer mp, int what, int extra) {
        if (what == 100) {
            this.activity.finish();
        } else {
            this.close();
            this.updatePrefs();
        }
        return true;
    }

    @Override
    public synchronized void close() {
        if (this.mediaPlayer != null) {
            this.mediaPlayer.release();
            this.mediaPlayer = null;
        }
    }
}

