/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture.camera;

import android.graphics.Point;
import android.hardware.Camera;
import android.os.Handler;
import android.os.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fullj.zxing.capture.PreviewFrame;
import top.fullj.zxing.capture.camera.CameraConfigurationManager;

final class PreviewCallback
implements Camera.PreviewCallback {
    private static final Logger logger = LoggerFactory.getLogger((String)"PreviewCallback");
    private final CameraConfigurationManager configManager;
    private Handler previewHandler;
    private int previewMessage;

    PreviewCallback(CameraConfigurationManager configManager) {
        this.configManager = configManager;
    }

    void setHandler(Handler previewHandler, int previewMessage) {
        this.previewHandler = previewHandler;
        this.previewMessage = previewMessage;
    }

    public void onPreviewFrame(byte[] data, Camera camera) {
        Point cameraResolution = this.configManager.getCameraResolution();
        Handler thePreviewHandler = this.previewHandler;
        if (cameraResolution != null && thePreviewHandler != null) {
            Message message;
            Point screenResolution = this.configManager.getScreenResolution();
            if (screenResolution.x < screenResolution.y && cameraResolution.x > cameraResolution.y) {
                PreviewFrame frame = PreviewFrame.obtain(cameraResolution.y, cameraResolution.x, this.configManager.getCWNeededRotation(), data);
                message = thePreviewHandler.obtainMessage(this.previewMessage, (Object)frame);
            } else {
                PreviewFrame frame = PreviewFrame.obtain(cameraResolution.x, cameraResolution.y, this.configManager.getCWNeededRotation(), data);
                message = thePreviewHandler.obtainMessage(this.previewMessage, (Object)frame);
            }
            message.sendToTarget();
            this.previewHandler = null;
        } else {
            logger.debug("Got preview callback, but no handler or resolution available");
        }
    }
}

