/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture.camera;

import android.content.Context;
import android.graphics.Point;
import android.hardware.Camera;
import android.os.Build;
import android.view.Display;
import android.view.WindowManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fullj.zxing.capture.CaptureOptions;
import top.fullj.zxing.capture.camera.CameraConfigurationUtils;
import top.fullj.zxing.capture.camera.FrontLightMode;
import top.fullj.zxing.capture.camera.open.CameraFacing;
import top.fullj.zxing.capture.camera.open.OpenCamera;

final class CameraConfigurationManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"CameraConfiguration");
    private final Context context;
    private int cwNeededRotation;
    private int cwRotationFromDisplayToCamera;
    private Point screenResolution;
    private Point cameraResolution;
    private Point bestPreviewSize;
    private Point previewSizeOnScreen;

    CameraConfigurationManager(Context context) {
        this.context = context;
    }

    void initFromCameraParameters(OpenCamera camera) {
        int cwRotationFromNaturalToDisplay;
        Camera.Parameters parameters = camera.getCamera().getParameters();
        WindowManager manager = (WindowManager)this.context.getSystemService("window");
        Display display = manager.getDefaultDisplay();
        int displayRotation = display.getRotation();
        switch (displayRotation) {
            case 0: {
                cwRotationFromNaturalToDisplay = 0;
                break;
            }
            case 1: {
                cwRotationFromNaturalToDisplay = 90;
                break;
            }
            case 2: {
                cwRotationFromNaturalToDisplay = 180;
                break;
            }
            case 3: {
                cwRotationFromNaturalToDisplay = 270;
                break;
            }
            default: {
                if (displayRotation % 90 == 0) {
                    cwRotationFromNaturalToDisplay = (360 + displayRotation) % 360;
                    break;
                }
                throw new IllegalArgumentException("Bad rotation: " + displayRotation);
            }
        }
        logger.info("Display at: {}", (Object)cwRotationFromNaturalToDisplay);
        int cwRotationFromNaturalToCamera = camera.getOrientation();
        logger.info("Camera at: {}", (Object)cwRotationFromNaturalToCamera);
        if (camera.getFacing() == CameraFacing.FRONT) {
            cwRotationFromNaturalToCamera = (360 - cwRotationFromNaturalToCamera) % 360;
            logger.info("Front camera overridden to: {}", (Object)cwRotationFromNaturalToCamera);
        }
        this.cwRotationFromDisplayToCamera = (360 + cwRotationFromNaturalToCamera - cwRotationFromNaturalToDisplay) % 360;
        logger.info("Final display orientation: {}", (Object)this.cwRotationFromDisplayToCamera);
        if (camera.getFacing() == CameraFacing.FRONT) {
            logger.info("Compensating rotation for front camera");
            this.cwNeededRotation = (360 - this.cwRotationFromDisplayToCamera) % 360;
        } else {
            this.cwNeededRotation = this.cwRotationFromDisplayToCamera;
        }
        logger.info("Clockwise rotation from display to camera: {}", (Object)this.cwNeededRotation);
        Point theScreenResolution = new Point();
        display.getSize(theScreenResolution);
        this.screenResolution = theScreenResolution;
        logger.info("Screen resolution in current orientation: {}", (Object)this.screenResolution);
        this.cameraResolution = CameraConfigurationUtils.findBestPreviewSizeValue(parameters, this.screenResolution);
        logger.info("Camera resolution: {}", (Object)this.cameraResolution);
        this.bestPreviewSize = CameraConfigurationUtils.findBestPreviewSizeValue(parameters, this.screenResolution);
        logger.info("Best available preview size: {}", (Object)this.bestPreviewSize);
        boolean isScreenPortrait = this.screenResolution.x < this.screenResolution.y;
        boolean isPreviewSizePortrait = this.bestPreviewSize.x < this.bestPreviewSize.y;
        this.previewSizeOnScreen = isScreenPortrait == isPreviewSizePortrait ? this.bestPreviewSize : new Point(this.bestPreviewSize.y, this.bestPreviewSize.x);
        logger.info("Preview size on screen: {}", (Object)this.previewSizeOnScreen);
    }

    void setDesiredCameraParameters(OpenCamera camera, boolean safeMode) {
        Camera theCamera = camera.getCamera();
        Camera.Parameters parameters = theCamera.getParameters();
        if (parameters == null) {
            logger.warn("Device error: no camera parameters are available. Proceeding without configuration.");
            return;
        }
        logger.info("Initial camera parameters: {}", (Object)parameters.flatten());
        if (safeMode) {
            logger.warn("In camera config safe mode -- most settings will not be honored");
        }
        this.initializeTorch(parameters, safeMode);
        CameraConfigurationUtils.setFocus(parameters, CaptureOptions.AUTO_FOCUS, CaptureOptions.DISABLE_CONTINUOUS_FOCUS, safeMode);
        if (!safeMode) {
            if (CaptureOptions.INVERT_SCAN) {
                CameraConfigurationUtils.setInvertColor(parameters);
            }
            if (!CaptureOptions.DISABLE_BARCODE_SCENE_MODE) {
                CameraConfigurationUtils.setBarcodeSceneMode(parameters);
            }
            if (!CaptureOptions.DISABLE_METERING) {
                if (Build.VERSION.SDK_INT >= 15) {
                    CameraConfigurationUtils.setVideoStabilization(parameters);
                }
                CameraConfigurationUtils.setFocusArea(parameters);
                CameraConfigurationUtils.setMetering(parameters);
            }
            parameters.setRecordingHint(true);
        }
        parameters.setPreviewSize(this.bestPreviewSize.x, this.bestPreviewSize.y);
        theCamera.setParameters(parameters);
        theCamera.setDisplayOrientation(this.cwRotationFromDisplayToCamera);
        Camera.Parameters afterParameters = theCamera.getParameters();
        Camera.Size afterSize = afterParameters.getPreviewSize();
        if (afterSize != null && (this.bestPreviewSize.x != afterSize.width || this.bestPreviewSize.y != afterSize.height)) {
            logger.warn("Camera said it supported preview size {}x{}, but after setting it, preview size is {}x{}", new Object[]{this.bestPreviewSize.x, this.bestPreviewSize.y, afterSize.width, afterSize.height});
            this.bestPreviewSize.x = afterSize.width;
            this.bestPreviewSize.y = afterSize.height;
        }
    }

    Point getBestPreviewSize() {
        return this.bestPreviewSize;
    }

    Point getPreviewSizeOnScreen() {
        return this.previewSizeOnScreen;
    }

    Point getCameraResolution() {
        return this.cameraResolution;
    }

    Point getScreenResolution() {
        return this.screenResolution;
    }

    int getCWNeededRotation() {
        return this.cwNeededRotation;
    }

    boolean getTorchState(Camera camera) {
        Camera.Parameters parameters;
        if (camera != null && (parameters = camera.getParameters()) != null) {
            String flashMode = parameters.getFlashMode();
            return "on".equals(flashMode) || "torch".equals(flashMode);
        }
        return false;
    }

    void setTorch(Camera camera, boolean newSetting) {
        Camera.Parameters parameters = camera.getParameters();
        this.doSetTorch(parameters, newSetting, false);
        camera.setParameters(parameters);
    }

    private void initializeTorch(Camera.Parameters parameters, boolean safeMode) {
        this.doSetTorch(parameters, CaptureOptions.FRONT_LIGHT_MODE == FrontLightMode.ON, safeMode);
    }

    private void doSetTorch(Camera.Parameters parameters, boolean newSetting, boolean safeMode) {
        CameraConfigurationUtils.setTorch(parameters, newSetting);
        if (!safeMode && !CaptureOptions.DISABLE_EXPOSURE) {
            CameraConfigurationUtils.setBestExposure(parameters, newSetting);
        }
    }
}

