/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture;

import android.content.Intent;
import android.net.Uri;
import android.os.Bundle;
import com.google.zxing.DecodeHintType;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DecodeHintManager {
    private static final Logger logger = LoggerFactory.getLogger((String)"DecodeHintManager");
    private static final Pattern COMMA = Pattern.compile(",");

    private DecodeHintManager() {
    }

    private static Map<String, String> splitQuery(String query) {
        HashMap<String, String> map = new HashMap<String, String>();
        int pos = 0;
        while (pos < query.length()) {
            String text;
            String name;
            if (query.charAt(pos) == '&') {
                ++pos;
                continue;
            }
            int amp = query.indexOf(38, pos);
            int equ = query.indexOf(61, pos);
            if (amp < 0) {
                if (equ < 0) {
                    name = query.substring(pos);
                    name = name.replace('+', ' ');
                    name = Uri.decode((String)name);
                    text = "";
                } else {
                    name = query.substring(pos, equ);
                    name = name.replace('+', ' ');
                    name = Uri.decode((String)name);
                    text = query.substring(equ + 1);
                    text = text.replace('+', ' ');
                    text = Uri.decode((String)text);
                }
                if (map.containsKey(name)) break;
                map.put(name, text);
                break;
            }
            if (equ < 0 || equ > amp) {
                name = query.substring(pos, amp);
                name = name.replace('+', ' ');
                if (!map.containsKey(name = Uri.decode((String)name))) {
                    map.put(name, "");
                }
                pos = amp + 1;
                continue;
            }
            name = query.substring(pos, equ);
            name = name.replace('+', ' ');
            name = Uri.decode((String)name);
            text = query.substring(equ + 1, amp);
            text = text.replace('+', ' ');
            text = Uri.decode((String)text);
            if (!map.containsKey(name)) {
                map.put(name, text);
            }
            pos = amp + 1;
        }
        return map;
    }

    static Map<DecodeHintType, ?> parseDecodeHints(Uri inputUri) {
        String query = inputUri.getEncodedQuery();
        if (query == null || query.isEmpty()) {
            return null;
        }
        Map<String, String> parameters = DecodeHintManager.splitQuery(query);
        EnumMap<DecodeHintType, Object> hints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        for (DecodeHintType hintType : DecodeHintType.values()) {
            String parameterName;
            String parameterText;
            if (hintType == DecodeHintType.CHARACTER_SET || hintType == DecodeHintType.NEED_RESULT_POINT_CALLBACK || hintType == DecodeHintType.POSSIBLE_FORMATS || (parameterText = parameters.get(parameterName = hintType.name())) == null) continue;
            if (hintType.getValueType().equals(Object.class)) {
                hints.put(hintType, (Object)parameterText);
                continue;
            }
            if (hintType.getValueType().equals(Void.class)) {
                hints.put(hintType, (Object)Boolean.TRUE);
                continue;
            }
            if (hintType.getValueType().equals(String.class)) {
                hints.put(hintType, (Object)parameterText);
                continue;
            }
            if (hintType.getValueType().equals(Boolean.class)) {
                if (parameterText.isEmpty()) {
                    hints.put(hintType, (Object)Boolean.TRUE);
                    continue;
                }
                if ("0".equals(parameterText) || "false".equalsIgnoreCase(parameterText) || "no".equalsIgnoreCase(parameterText)) {
                    hints.put(hintType, (Object)Boolean.FALSE);
                    continue;
                }
                hints.put(hintType, (Object)Boolean.TRUE);
                continue;
            }
            if (hintType.getValueType().equals(int[].class)) {
                if (!parameterText.isEmpty() && parameterText.charAt(parameterText.length() - 1) == ',') {
                    parameterText = parameterText.substring(0, parameterText.length() - 1);
                }
                String[] values = COMMA.split(parameterText);
                int[] array = new int[values.length];
                for (int i = 0; i < values.length; ++i) {
                    try {
                        array[i] = Integer.parseInt(values[i]);
                        continue;
                    }
                    catch (NumberFormatException ignored) {
                        logger.warn("Skipping array of integers hint {} due to invalid numeric value", (Object)hintType);
                        array = null;
                        break;
                    }
                }
                if (array == null) continue;
                hints.put(hintType, (Object)array);
                continue;
            }
            logger.warn("Unsupported hint type '{}' of type {}", (Object)hintType, (Object)hintType.getValueType());
        }
        return hints;
    }

    static Map<DecodeHintType, Object> parseDecodeHints(Intent intent) {
        Bundle extras = intent.getExtras();
        if (extras == null || extras.isEmpty()) {
            return null;
        }
        EnumMap<DecodeHintType, Object> hints = new EnumMap<DecodeHintType, Object>(DecodeHintType.class);
        for (DecodeHintType hintType : DecodeHintType.values()) {
            String hintName;
            if (hintType == DecodeHintType.CHARACTER_SET || hintType == DecodeHintType.NEED_RESULT_POINT_CALLBACK || hintType == DecodeHintType.POSSIBLE_FORMATS || !extras.containsKey(hintName = hintType.name())) continue;
            if (hintType.getValueType().equals(Void.class)) {
                hints.put(hintType, (Object)Boolean.TRUE);
                continue;
            }
            Object hintData = extras.get(hintName);
            if (hintType.getValueType().isInstance(hintData)) {
                hints.put(hintType, hintData);
                continue;
            }
            logger.warn("Ignoring hint {} because it is not a {}", (Object)hintType, (Object)hintType.getValueType());
        }
        return hints;
    }
}

