/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.zxing.capture;

import android.graphics.Bitmap;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import com.google.zxing.Binarizer;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.DecodeHintType;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.PlanarYUVLuminanceSource;
import com.google.zxing.ReaderException;
import com.google.zxing.Result;
import com.google.zxing.common.HybridBinarizer;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import top.fullj.zxing.capture.CaptureActivity;
import top.fullj.zxing.capture.PreviewFrame;
import top.fullj.zxing.capture.RotateUtils;

final class DecodeHandler
extends Handler {
    private static final Logger logger = LoggerFactory.getLogger((String)"DecodeHandler");
    private final CaptureActivity activity;
    private final MultiFormatReader multiFormatReader = new MultiFormatReader();
    private boolean running = true;

    DecodeHandler(CaptureActivity activity, Map<DecodeHintType, Object> hints) {
        this.multiFormatReader.setHints(hints);
        this.activity = activity;
    }

    public void handleMessage(Message message) {
        if (message == null || !this.running) {
            return;
        }
        switch (message.what) {
            case 1000: {
                this.decode((PreviewFrame)message.obj);
                break;
            }
            case 1001: {
                this.running = false;
                Looper.myLooper().quit();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decode(PreviewFrame frame) {
        long start = System.nanoTime();
        int width = frame.width;
        int height = frame.height;
        byte[] data = frame.data;
        if (width < height) {
            data = frame.degree == 90 ? RotateUtils.clockwiseRotate270Degree(width, height, data) : RotateUtils.clockwiseRotate90Degree(width, height, data);
        }
        Result rawResult = null;
        PlanarYUVLuminanceSource source = this.activity.getCameraManager().buildLuminanceSource(data, width, height);
        if (source != null) {
            BinaryBitmap bitmap = new BinaryBitmap((Binarizer)new HybridBinarizer((LuminanceSource)source));
            try {
                rawResult = this.multiFormatReader.decodeWithState(bitmap);
            }
            catch (ReaderException readerException) {
            }
            finally {
                this.multiFormatReader.reset();
            }
        }
        Handler handler = this.activity.getHandler();
        if (rawResult != null) {
            long end = System.nanoTime();
            logger.debug("Found barcode in " + TimeUnit.NANOSECONDS.toMillis(end - start) + " ms");
            if (handler != null) {
                Message message = Message.obtain((Handler)handler, (int)1002, (Object)rawResult);
                Bundle bundle = new Bundle();
                DecodeHandler.bundleThumbnail(source, bundle);
                message.setData(bundle);
                message.sendToTarget();
            }
        } else if (handler != null) {
            Message message = Message.obtain((Handler)handler, (int)1003);
            message.sendToTarget();
        }
    }

    private static void bundleThumbnail(PlanarYUVLuminanceSource source, Bundle bundle) {
        int[] pixels = source.renderThumbnail();
        int width = source.getThumbnailWidth();
        int height = source.getThumbnailHeight();
        Bitmap bitmap = Bitmap.createBitmap((int[])pixels, (int)0, (int)width, (int)width, (int)height, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 50, (OutputStream)out);
        bundle.putByteArray("barcode_bitmap", out.toByteArray());
        bundle.putFloat("barcode_scaled_factor", (float)width / (float)source.getWidth());
    }
}

