/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.money;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Currency;

public final class Money
implements Comparable<Money> {
    private static final RoundingMode ROUNDING_MODE = RoundingMode.HALF_EVEN;
    private static final int[] CENTS = new int[]{1, 10, 100, 1000};
    private long amount;
    private final Currency currency;

    public static Money zero(String currencyCode) {
        return Money.zero(Currency.getInstance(currencyCode));
    }

    public static Money zero(Currency currency) {
        return Money.of(BigDecimal.ZERO, currency);
    }

    public static Money of(String str) {
        return Money.parse(str);
    }

    public static Money of(BigDecimal amount, String currencyCode) {
        return Money.of(amount, Currency.getInstance(currencyCode));
    }

    public static Money of(BigDecimal amount, Currency currency) {
        if (amount == null) {
            amount = BigDecimal.ZERO;
        }
        return new Money(amount, currency);
    }

    public static Money of(String amount, String currencyCode) {
        return Money.of(amount, Currency.getInstance(currencyCode));
    }

    public static Money of(String amount, Currency currency) {
        return Money.of(new BigDecimal(amount), currency);
    }

    private Money(long amount, Currency currency) {
        this.currency = currency;
        this.amount = amount;
    }

    private Money(BigDecimal amount, Currency currency) {
        this.currency = currency;
        this.amount = amount.multiply(BigDecimal.valueOf(this.centFactor())).setScale(currency.getDefaultFractionDigits(), ROUNDING_MODE).longValue();
    }

    public Money touch(BigDecimal amount) {
        return new Money(amount, this.currency);
    }

    public BigDecimal amount() {
        return BigDecimal.valueOf(this.amount, this.currency.getDefaultFractionDigits());
    }

    public Currency currency() {
        return this.currency;
    }

    public String currencyCode() {
        return this.currency.getCurrencyCode();
    }

    public Money add(Money other) {
        this.checkCurrency(other);
        return new Money(this.amount + other.amount, this.currency);
    }

    public Money add(BigDecimal amt) {
        if (amt == null) {
            return this;
        }
        return new Money(this.amount().add(amt), this.currency);
    }

    public Money sub(Money other) {
        this.checkCurrency(other);
        return new Money(this.amount - other.amount, this.currency);
    }

    public Money sub(BigDecimal amt) {
        if (amt == null) {
            return this;
        }
        return new Money(this.amount().subtract(amt), this.currency);
    }

    public Money mul(String ratio) {
        return this.mul(new BigDecimal(ratio));
    }

    public Money mul(double ratio) {
        return this.mul(BigDecimal.valueOf(ratio));
    }

    public Money mul(long ratio) {
        return this.mul(BigDecimal.valueOf(ratio));
    }

    public Money mul(BigDecimal ratio) {
        return new Money(this.amount().multiply(ratio), this.currency);
    }

    public Money[] alloc(int n) {
        int i;
        if (n < 1) {
            throw new IllegalArgumentException("n=" + n);
        }
        Money low = new Money(this.amount / (long)n, this.currency);
        Money high = new Money(low.amount + 1L, this.currency);
        Money[] result = new Money[n];
        int remain = (int)(this.amount % (long)n);
        for (i = 0; i < remain; ++i) {
            result[i] = high;
        }
        for (i = remain; i < n; ++i) {
            result[i] = low;
        }
        return result;
    }

    public Money[] alloc(long[] ratios) {
        int i;
        if (ratios.length < 1) {
            throw new IllegalArgumentException("ratios.length=" + ratios.length);
        }
        long total = 0L;
        for (long ratio : ratios) {
            total += ratio;
        }
        long remain = this.amount;
        Money[] result = new Money[ratios.length];
        for (i = 0; i < result.length; ++i) {
            result[i] = new Money(this.amount * ratios[i] / total, this.currency);
            remain -= result[i].amount;
        }
        i = 0;
        while ((long)i < remain) {
            ++result[i].amount;
            ++i;
        }
        return result;
    }

    public Money with(Operator op) {
        return op.apply(this);
    }

    @Override
    public int compareTo(Money other) {
        this.checkCurrency(other);
        return Long.compare(this.amount, other.amount);
    }

    public boolean gt(Money other) {
        return this.compareTo(other) > 0;
    }

    public boolean lt(Money other) {
        return this.compareTo(other) < 0;
    }

    public boolean gte(Money other) {
        return !this.lt(other);
    }

    public boolean lte(Money other) {
        return !this.gt(other);
    }

    public int hashCode() {
        return (int)(this.amount ^ this.amount >>> 32);
    }

    public String toString() {
        return Money.format(this);
    }

    public boolean equals(Object other) {
        return other instanceof Money && this.equals((Money)other);
    }

    public boolean equals(Money other) {
        return this.currency.equals(other.currency) && this.amount == other.amount;
    }

    private int centFactor() {
        int digits = this.currency.getDefaultFractionDigits();
        assert (digits >= 0);
        return CENTS[digits];
    }

    private void checkCurrency(Money other) {
        if (!this.currency.equals(other.currency)) {
            throw new IllegalStateException("Currency mismatch: " + this.currency.getCurrencyCode() + "/" + other.currency.getCurrencyCode());
        }
    }

    private static String format(Money money) {
        return money.currency.getCurrencyCode() + " " + money.amount().toPlainString();
    }

    private static Money parse(String str) {
        String currencyCode = str.substring(0, 3);
        String amount = str.substring(4);
        return Money.of(amount, Currency.getInstance(currencyCode));
    }

    public static interface Operator {
        public Money apply(Money var1);
    }
}

