/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.money;

import java.math.BigDecimal;
import java.util.Currency;
import top.fullj.money.Conversion;
import top.fullj.money.ExchangeRateProvider;
import top.fullj.money.Money;

class DefaultConversion
implements Conversion {
    private final Currency foreignCurrency;
    private final ExchangeRateProvider provider;

    DefaultConversion(Currency currency, ExchangeRateProvider provider) {
        this.foreignCurrency = currency;
        this.provider = provider;
    }

    @Override
    public Money apply(Money money) {
        BigDecimal exchangeRate = this.provider.query(money.currency(), this.foreignCurrency);
        BigDecimal amount = money.amount().multiply(exchangeRate);
        return Money.of(amount, this.foreignCurrency);
    }
}

