/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.money;

import java.math.BigDecimal;
import java.util.Currency;
import top.fullj.money.Conversion;
import top.fullj.money.Money;

public class ExchangeRateConversion
implements Conversion {
    private final Currency foreignCurrency;
    private final BigDecimal exchangeRate;

    public ExchangeRateConversion(String currency, BigDecimal exchangeRate) {
        this(Currency.getInstance(currency), exchangeRate);
    }

    public ExchangeRateConversion(Currency currency, BigDecimal exchangeRate) {
        this.foreignCurrency = currency;
        this.exchangeRate = exchangeRate;
    }

    @Override
    public Money apply(Money money) {
        BigDecimal amount = money.amount().multiply(this.exchangeRate);
        return Money.of(amount, this.foreignCurrency);
    }
}

