/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.eventbus;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import top.fullj.eventbus.EventExecutor;
import top.fullj.eventbus.NamedThreadFactory;

class PoolExecutor
extends ThreadPoolExecutor
implements EventExecutor {
    private static final int MAX_POOL_SIZE;
    private static final int CORE_POOL_SIZE;
    static final PoolExecutor INSTANCE;

    private PoolExecutor() {
        super(CORE_POOL_SIZE, MAX_POOL_SIZE, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(64), new NamedThreadFactory("EventBusPool"));
        this.allowCoreThreadTimeOut(true);
        System.out.println("EventBus.PoolExecutor: corePoolSize=" + CORE_POOL_SIZE + ", maxPoolSize=" + MAX_POOL_SIZE);
    }

    @Override
    public String threadMode() {
        return "threadPool";
    }

    static {
        CORE_POOL_SIZE = Math.max(4, Runtime.getRuntime().availableProcessors());
        MAX_POOL_SIZE = CORE_POOL_SIZE * 2;
        INSTANCE = new PoolExecutor();
    }
}

