/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.eventbus;

import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import top.fullj.eventbus.EventExecutor;
import top.fullj.eventbus.NamingThreadFactory;

class PoolExecutor
extends ThreadPoolExecutor
implements EventExecutor {
    static final String KEY_MAX_POOL_SIZE = "top.fullj.eventbus.executor.pool.maxPoolSize";
    static final String KEY_CORE_POOL_SIZE = "top.fullj.eventbus.executor.pool.corePoolSize";
    private static final int MAX_POOL_SIZE;
    private static final int CORE_POOL_SIZE;
    static final PoolExecutor INSTANCE;

    private PoolExecutor() {
        super(CORE_POOL_SIZE, MAX_POOL_SIZE, 30L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(128), new NamingThreadFactory("Pool"));
        this.allowCoreThreadTimeOut(true);
    }

    @Override
    public String threadMode() {
        return "threadPool";
    }

    static {
        String maxProp = System.getProperty(KEY_MAX_POOL_SIZE);
        MAX_POOL_SIZE = maxProp != null ? Integer.parseInt(maxProp) : Math.max(8, Runtime.getRuntime().availableProcessors() * 2);
        System.out.println("top.fullj.eventbus.executor.pool.maxPoolSize = " + MAX_POOL_SIZE);
        String coreProp = System.getProperty(KEY_CORE_POOL_SIZE);
        CORE_POOL_SIZE = coreProp != null ? Integer.parseInt(coreProp) : Math.max(4, Runtime.getRuntime().availableProcessors() / 2);
        System.out.println("top.fullj.eventbus.executor.pool.corePoolSize = " + CORE_POOL_SIZE);
        INSTANCE = new PoolExecutor();
    }
}

