/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.eventbus;

import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import top.fullj.eventbus.EventListener;
import top.fullj.eventbus.StickySubscribeHandler;
import top.fullj.eventbus.Subscribe;
import top.fullj.eventbus.Subscriber;

final class Registry {
    private static final Map<Class<?>, List<Method>> METHOD_CACHE = new ConcurrentHashMap();
    private final Map<Class<?>, CopyOnWriteArraySet<Subscriber>> subscriberMap = new ConcurrentHashMap();

    Registry() {
    }

    Set<Subscriber> getSubscribers(Class<?> eventType) {
        CopyOnWriteArraySet<Subscriber> subscribers = this.subscriberMap.get(eventType);
        if (subscribers == null) {
            return Collections.emptySet();
        }
        return new HashSet<Subscriber>(subscribers);
    }

    void register(Object listener, StickySubscribeHandler handler) {
        Class<?> subscriberType = listener.getClass();
        for (Method method : Registry.getCachingSubscriberMethods(subscriberType)) {
            Subscriber subscriber = new Subscriber(listener, method);
            boolean absent = this.subscribe(subscriber);
            if (!subscriber.sticky || !absent) continue;
            handler.call(subscriber);
        }
    }

    void unregister(Object listener) {
        Class<?> subscriberType = listener.getClass();
        for (Method method : Registry.getCachingSubscriberMethods(subscriberType)) {
            this.unsubscribe(listener, method);
        }
    }

    boolean subscribe(Subscriber subscriber) {
        CopyOnWriteArraySet<Subscriber> origin;
        Class<?> eventType = subscriber.eventType;
        CopyOnWriteArraySet<Subscriber> subscribers = this.subscriberMap.get(eventType);
        if (subscribers == null && (origin = this.subscriberMap.putIfAbsent(eventType, subscribers = new CopyOnWriteArraySet())) != null) {
            subscribers = origin;
        }
        return subscribers.add(subscriber);
    }

    void unsubscribe(Subscriber subscriber) {
        Class<?> eventType = subscriber.eventType;
        CopyOnWriteArraySet<Subscriber> subscribers = this.subscriberMap.get(eventType);
        if (subscribers != null) {
            subscribers.remove(subscriber);
        }
    }

    void unsubscribe(Object listener, Method method) {
        this.unsubscribe(new Subscriber(listener, method));
    }

    static List<Method> getCachingSubscriberMethods(Class<?> type) {
        if (METHOD_CACHE.containsKey(type)) {
            return METHOD_CACHE.get(type);
        }
        List<Method> methods = Registry.getAnnotatedSubscriberMethods(type);
        METHOD_CACHE.put(type, methods);
        return methods;
    }

    private static List<Method> getAnnotatedSubscriberMethods(Class<?> type) {
        HashMap<MethodIdentifier, Method> identifiers = new HashMap<MethodIdentifier, Method>();
        Class stop = Object.class;
        EventListener listener = type.getAnnotation(EventListener.class);
        if (listener != null) {
            stop = listener.stopClass();
        }
        for (Class<?> c = type; c != stop && c != Object.class; c = c.getSuperclass()) {
            for (Method method : c.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(Subscribe.class)) continue;
                Class<?>[] argTypes = method.getParameterTypes();
                if (argTypes.length != 1) {
                    throw new IllegalArgumentException(String.format("@Subscribe method %s must have exactly 1 parameter", method.getName()));
                }
                MethodIdentifier identifier = new MethodIdentifier(method);
                if (identifiers.containsKey(identifier)) continue;
                identifiers.put(identifier, method);
            }
        }
        if (identifiers.isEmpty()) {
            throw new IllegalArgumentException("@Subscribe method required in class: " + type.getSimpleName());
        }
        return new LinkedList<Method>(identifiers.values());
    }

    private static final class MethodIdentifier {
        private final String name;
        private final Class<?> eventType;

        MethodIdentifier(Method method) {
            this.name = method.getName();
            this.eventType = method.getParameterTypes()[0];
        }

        public int hashCode() {
            return (31 + this.name.hashCode()) * 31 + this.eventType.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof MethodIdentifier) {
                MethodIdentifier other = (MethodIdentifier)obj;
                return this.name.equals(other.name) && this.eventType.equals(other.eventType);
            }
            return false;
        }
    }
}

