/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.eventbus;

import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import top.fullj.eventbus.NamedExecutor;
import top.fullj.eventbus.NamingThreadFactory;

public class PoolExecutor
extends ThreadPoolExecutor
implements NamedExecutor {
    public static final String KEY_MAX_POOL_SIZE = "top.fullj.eventbus.executor.pool.maxPoolSize";
    public static final String KEY_MIN_POOL_SIZE = "top.fullj.eventbus.executor.pool.minPoolSize";
    private static final int MAX_POOL_SIZE;
    private static final int MIN_POOL_SIZE;

    public PoolExecutor() {
        super(MIN_POOL_SIZE, MAX_POOL_SIZE, 60L, TimeUnit.SECONDS, new SynchronousQueue<Runnable>(true), new NamingThreadFactory("Pool"));
    }

    @Override
    public String name() {
        return "threadPool";
    }

    static {
        String maxProp = System.getProperty(KEY_MAX_POOL_SIZE);
        MAX_POOL_SIZE = maxProp != null ? Integer.parseInt(maxProp) : Math.max(8, Runtime.getRuntime().availableProcessors());
        System.out.println("top.fullj.eventbus.executor.pool.maxPoolSize = " + MAX_POOL_SIZE);
        String minProp = System.getProperty(KEY_MIN_POOL_SIZE);
        MIN_POOL_SIZE = minProp == null ? 0 : Integer.parseInt(minProp);
        System.out.println("top.fullj.eventbus.executor.pool.minPoolSize = " + MIN_POOL_SIZE);
    }
}

