/*
 * Decompiled with CFR 0.152.
 */
package top.fullj.eventbus;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.lang.reflect.Method;
import top.fullj.eventbus.EventBus;
import top.fullj.eventbus.SubscriberExceptionHandler;

class ConsoleSubscriberExceptionHandler
implements SubscriberExceptionHandler {
    ConsoleSubscriberExceptionHandler() {
    }

    @Override
    public void handleException(EventBus bus, Object event, Object subscriber, Method method, Throwable tr) {
        Throwable cause = tr.getCause() == null ? tr : tr.getCause();
        String message = "[" + Thread.currentThread().getName() + "] Dispatch " + subscriber.getClass().getSimpleName() + "." + method.getName() + "(e = " + event + ") failed: " + this.getStackTrace(cause);
        System.out.println(message);
    }

    private String getStackTrace(Throwable tr) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        tr.printStackTrace(pw);
        pw.flush();
        return sw.toString();
    }
}

