/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.controller;

import com.xxl.job.admin.controller.JobInfoController;
import com.xxl.job.admin.core.complete.XxlJobCompleter;
import com.xxl.job.admin.core.exception.XxlJobException;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.model.XxlJobLog;
import com.xxl.job.admin.core.scheduler.XxlJobScheduler;
import com.xxl.job.admin.core.util.I18nUtil;
import com.xxl.job.admin.dao.XxlJobGroupDao;
import com.xxl.job.admin.dao.XxlJobInfoDao;
import com.xxl.job.admin.dao.XxlJobLogDao;
import com.xxl.job.core.biz.ExecutorBiz;
import com.xxl.job.core.biz.model.KillParam;
import com.xxl.job.core.biz.model.LogParam;
import com.xxl.job.core.biz.model.LogResult;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.util.DateUtil;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/joblog"})
public class JobLogController {
    private static Logger logger = LoggerFactory.getLogger(JobLogController.class);
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;
    @Resource
    public XxlJobInfoDao xxlJobInfoDao;
    @Resource
    public XxlJobLogDao xxlJobLogDao;

    @RequestMapping
    public String index(HttpServletRequest request, Model model, @RequestParam(required=false, defaultValue="0") Integer jobId) {
        List jobGroupList_all = this.xxlJobGroupDao.findAll();
        List jobGroupList = JobInfoController.filterJobGroupByRole((HttpServletRequest)request, (List)jobGroupList_all);
        if (jobGroupList == null || jobGroupList.size() == 0) {
            throw new XxlJobException(I18nUtil.getString((String)"jobgroup_empty"));
        }
        model.addAttribute("JobGroupList", (Object)jobGroupList);
        if (jobId > 0) {
            XxlJobInfo jobInfo = this.xxlJobInfoDao.loadById(jobId.intValue());
            if (jobInfo == null) {
                throw new RuntimeException(I18nUtil.getString((String)"jobinfo_field_id") + I18nUtil.getString((String)"system_unvalid"));
            }
            model.addAttribute("jobInfo", (Object)jobInfo);
            JobInfoController.validReadPermission((HttpServletRequest)request, (int)jobInfo.getJobGroup());
        }
        return "joblog/joblog.index";
    }

    @RequestMapping(value={"/getJobsByGroup"})
    @ResponseBody
    public ReturnT<List<XxlJobInfo>> getJobsByGroup(int jobGroup) {
        List list = this.xxlJobInfoDao.getJobsByGroup(jobGroup);
        return new ReturnT((Object)list);
    }

    @RequestMapping(value={"/pageList"})
    @ResponseBody
    public Map<String, Object> pageList(HttpServletRequest request, @RequestParam(required=false, defaultValue="0") int start, @RequestParam(required=false, defaultValue="10") int length, int jobGroup, int jobId, int logStatus, String filterTime) {
        String[] temp;
        JobInfoController.validReadPermission((HttpServletRequest)request, (int)jobGroup);
        Date triggerTimeStart = null;
        Date triggerTimeEnd = null;
        if (filterTime != null && filterTime.trim().length() > 0 && (temp = filterTime.split(" - ")).length == 2) {
            triggerTimeStart = DateUtil.parseDateTime((String)temp[0]);
            triggerTimeEnd = DateUtil.parseDateTime((String)temp[1]);
        }
        List list = this.xxlJobLogDao.pageList(start, length, jobGroup, jobId, triggerTimeStart, triggerTimeEnd, logStatus);
        int list_count = this.xxlJobLogDao.pageListCount(start, length, jobGroup, jobId, triggerTimeStart, triggerTimeEnd, logStatus);
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("recordsTotal", list_count);
        maps.put("recordsFiltered", list_count);
        maps.put("data", list);
        return maps;
    }

    @RequestMapping(value={"/logDetailPage"})
    public String logDetailPage(int id, Model model) {
        ReturnT logStatue = ReturnT.SUCCESS;
        XxlJobLog jobLog = this.xxlJobLogDao.load((long)id);
        if (jobLog == null) {
            throw new RuntimeException(I18nUtil.getString((String)"joblog_logid_unvalid"));
        }
        model.addAttribute("triggerCode", (Object)jobLog.getTriggerCode());
        model.addAttribute("handleCode", (Object)jobLog.getHandleCode());
        model.addAttribute("logId", (Object)jobLog.getId());
        return "joblog/joblog.detail";
    }

    @RequestMapping(value={"/logDetailCat"})
    @ResponseBody
    public ReturnT<LogResult> logDetailCat(long logId, int fromLineNum) {
        try {
            XxlJobLog jobLog = this.xxlJobLogDao.load(logId);
            if (jobLog == null) {
                return new ReturnT(500, I18nUtil.getString((String)"joblog_logid_unvalid"));
            }
            ExecutorBiz executorBiz = XxlJobScheduler.getExecutorBiz((String)jobLog.getExecutorAddress());
            ReturnT logResult = executorBiz.log(new LogParam(jobLog.getTriggerTime().getTime(), logId, fromLineNum));
            if (logResult.getContent() != null && ((LogResult)logResult.getContent()).getFromLineNum() > ((LogResult)logResult.getContent()).getToLineNum() && jobLog.getHandleCode() > 0) {
                ((LogResult)logResult.getContent()).setEnd(true);
            }
            return logResult;
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            return new ReturnT(500, e.getMessage());
        }
    }

    @RequestMapping(value={"/logKill"})
    @ResponseBody
    public ReturnT<String> logKill(int id) {
        XxlJobLog log = this.xxlJobLogDao.load((long)id);
        XxlJobInfo jobInfo = this.xxlJobInfoDao.loadById(log.getJobId());
        if (jobInfo == null) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_glue_jobid_unvalid"));
        }
        if (200 != log.getTriggerCode()) {
            return new ReturnT(500, I18nUtil.getString((String)"joblog_kill_log_limit"));
        }
        ReturnT runResult = null;
        try {
            ExecutorBiz executorBiz = XxlJobScheduler.getExecutorBiz((String)log.getExecutorAddress());
            runResult = executorBiz.kill(new KillParam(jobInfo.getId()));
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            runResult = new ReturnT(500, e.getMessage());
        }
        if (200 == runResult.getCode()) {
            log.setHandleCode(500);
            log.setHandleMsg(I18nUtil.getString((String)"joblog_kill_log_byman") + ":" + (runResult.getMsg() != null ? runResult.getMsg() : ""));
            log.setHandleTime(new Date());
            XxlJobCompleter.updateHandleInfoAndFinish((XxlJobLog)log);
            return new ReturnT((Object)runResult.getMsg());
        }
        return new ReturnT(500, runResult.getMsg());
    }

    @RequestMapping(value={"/clearLog"})
    @ResponseBody
    public ReturnT<String> clearLog(int jobGroup, int jobId, int type) {
        Date clearBeforeTime = null;
        int clearBeforeNum = 0;
        if (type == 1) {
            clearBeforeTime = DateUtil.addMonths((Date)new Date(), (int)-1);
        } else if (type == 2) {
            clearBeforeTime = DateUtil.addMonths((Date)new Date(), (int)-3);
        } else if (type == 3) {
            clearBeforeTime = DateUtil.addMonths((Date)new Date(), (int)-6);
        } else if (type == 4) {
            clearBeforeTime = DateUtil.addYears((Date)new Date(), (int)-1);
        } else if (type == 5) {
            clearBeforeNum = 1000;
        } else if (type == 6) {
            clearBeforeNum = 10000;
        } else if (type == 7) {
            clearBeforeNum = 30000;
        } else if (type == 8) {
            clearBeforeNum = 100000;
        } else if (type == 9) {
            clearBeforeNum = 0;
        } else {
            return new ReturnT(500, I18nUtil.getString((String)"joblog_clean_type_unvalid"));
        }
        List logIds = null;
        do {
            if ((logIds = this.xxlJobLogDao.findClearLogIds(jobGroup, jobId, clearBeforeTime, clearBeforeNum, 1000)) == null || logIds.size() <= 0) continue;
            this.xxlJobLogDao.clearLog(logIds);
        } while (logIds != null && logIds.size() > 0);
        return ReturnT.SUCCESS;
    }
}

