/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.service.impl;

import com.xxl.job.admin.core.XxlJobTool;
import com.xxl.job.admin.core.model.XxlJobGroup;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.model.XxlJobLogReport;
import com.xxl.job.admin.core.model.XxlJobUser;
import com.xxl.job.admin.dao.XxlJobGroupDao;
import com.xxl.job.admin.dao.XxlJobInfoDao;
import com.xxl.job.admin.dao.XxlJobLogReportDao;
import com.xxl.job.admin.service.XxlJobService;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.util.DateUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class XxlJobServiceImpl
implements XxlJobService {
    private static Logger logger = LoggerFactory.getLogger(XxlJobServiceImpl.class);
    @Resource
    private XxlJobGroupDao xxlJobGroupDao;
    @Resource
    private XxlJobInfoDao xxlJobInfoDao;
    @Resource
    private XxlJobLogReportDao xxlJobLogReportDao;
    @Resource
    private XxlJobTool xxlJobTool;

    public Map<String, Object> pageList(XxlJobUser loginUser, int start, int length, int jobGroup, int triggerStatus, String jobDesc, String executorHandler, String author) {
        List list = this.xxlJobInfoDao.pageList(start, length, jobGroup, triggerStatus, jobDesc, executorHandler, author);
        String permission = loginUser.getJobGroupPermission(jobGroup);
        if (list != null) {
            list.forEach(jobInfo -> jobInfo.setPermission(permission));
        }
        int list_count = this.xxlJobInfoDao.pageListCount(start, length, jobGroup, triggerStatus, jobDesc, executorHandler, author);
        HashMap<String, Object> maps = new HashMap<String, Object>();
        maps.put("recordsTotal", list_count);
        maps.put("recordsFiltered", list_count);
        maps.put("data", list);
        maps.put("permission", permission);
        return maps;
    }

    public ReturnT<String> add(XxlJobInfo jobInfo) {
        this.xxlJobTool.add(jobInfo);
        return new ReturnT((Object)String.valueOf(jobInfo.getId()));
    }

    public ReturnT<String> update(XxlJobInfo jobInfo) {
        this.xxlJobTool.update(jobInfo);
        return ReturnT.SUCCESS;
    }

    public ReturnT<String> remove(int id) {
        XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(id);
        if (xxlJobInfo == null) {
            return ReturnT.SUCCESS;
        }
        this.xxlJobTool.remove(id);
        return ReturnT.SUCCESS;
    }

    public ReturnT<String> start(int id) {
        XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(id);
        this.xxlJobTool.start(xxlJobInfo);
        return ReturnT.SUCCESS;
    }

    public ReturnT<String> stop(int id) {
        XxlJobInfo xxlJobInfo = this.xxlJobInfoDao.loadById(id);
        this.xxlJobTool.stop(id);
        return ReturnT.SUCCESS;
    }

    public Map<String, Object> dashboardInfo() {
        int jobInfoCount = this.xxlJobInfoDao.findAllCount();
        int jobLogCount = 0;
        int jobLogSuccessCount = 0;
        XxlJobLogReport xxlJobLogReport = this.xxlJobLogReportDao.queryLogReportTotal();
        if (xxlJobLogReport != null) {
            jobLogCount = xxlJobLogReport.getRunningCount() + xxlJobLogReport.getSucCount() + xxlJobLogReport.getFailCount();
            jobLogSuccessCount = xxlJobLogReport.getSucCount();
        }
        HashSet executorAddressSet = new HashSet();
        List groupList = this.xxlJobGroupDao.findAll();
        if (groupList != null && !groupList.isEmpty()) {
            for (XxlJobGroup group : groupList) {
                if (group.getRegistryList() == null || group.getRegistryList().isEmpty()) continue;
                executorAddressSet.addAll(group.getRegistryList());
            }
        }
        int executorCount = executorAddressSet.size();
        HashMap<String, Object> dashboardMap = new HashMap<String, Object>();
        dashboardMap.put("jobInfoCount", jobInfoCount);
        dashboardMap.put("jobLogCount", jobLogCount);
        dashboardMap.put("jobLogSuccessCount", jobLogSuccessCount);
        dashboardMap.put("executorCount", executorCount);
        return dashboardMap;
    }

    public ReturnT<Map<String, Object>> chartInfo(Date startDate, Date endDate) {
        ArrayList<String> triggerDayList = new ArrayList<String>();
        ArrayList<Integer> triggerDayCountRunningList = new ArrayList<Integer>();
        ArrayList<Integer> triggerDayCountSucList = new ArrayList<Integer>();
        ArrayList<Integer> triggerDayCountFailList = new ArrayList<Integer>();
        int triggerCountRunningTotal = 0;
        int triggerCountSucTotal = 0;
        int triggerCountFailTotal = 0;
        List logReportList = this.xxlJobLogReportDao.queryLogReport(startDate, endDate);
        if (logReportList != null && logReportList.size() > 0) {
            for (XxlJobLogReport item : logReportList) {
                String day = DateUtil.formatDate((Date)item.getTriggerDay());
                int triggerDayCountRunning = item.getRunningCount();
                int triggerDayCountSuc = item.getSucCount();
                int triggerDayCountFail = item.getFailCount();
                triggerDayList.add(day);
                triggerDayCountRunningList.add(triggerDayCountRunning);
                triggerDayCountSucList.add(triggerDayCountSuc);
                triggerDayCountFailList.add(triggerDayCountFail);
                triggerCountRunningTotal += triggerDayCountRunning;
                triggerCountSucTotal += triggerDayCountSuc;
                triggerCountFailTotal += triggerDayCountFail;
            }
        } else {
            for (int i = -6; i <= 0; ++i) {
                triggerDayList.add(DateUtil.formatDate((Date)DateUtil.addDays((Date)new Date(), (int)i)));
                triggerDayCountRunningList.add(0);
                triggerDayCountSucList.add(0);
                triggerDayCountFailList.add(0);
            }
        }
        HashMap<String, Serializable> result = new HashMap<String, Serializable>();
        result.put("triggerDayList", triggerDayList);
        result.put("triggerDayCountRunningList", triggerDayCountRunningList);
        result.put("triggerDayCountSucList", triggerDayCountSucList);
        result.put("triggerDayCountFailList", triggerDayCountFailList);
        result.put("triggerCountRunningTotal", Integer.valueOf(triggerCountRunningTotal));
        result.put("triggerCountSucTotal", Integer.valueOf(triggerCountSucTotal));
        result.put("triggerCountFailTotal", Integer.valueOf(triggerCountFailTotal));
        return new ReturnT(result);
    }
}

