/*
 * Decompiled with CFR 0.152.
 */
package com.xxl.job.admin.controller;

import com.xxl.job.admin.controller.JobInfoController;
import com.xxl.job.admin.core.model.XxlJobInfo;
import com.xxl.job.admin.core.model.XxlJobLogGlue;
import com.xxl.job.admin.core.util.I18nUtil;
import com.xxl.job.admin.dao.XxlJobInfoDao;
import com.xxl.job.admin.dao.XxlJobLogGlueDao;
import com.xxl.job.core.biz.model.ReturnT;
import com.xxl.job.core.glue.GlueTypeEnum;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/jobcode"})
public class JobCodeController {
    @Resource
    private XxlJobInfoDao xxlJobInfoDao;
    @Resource
    private XxlJobLogGlueDao xxlJobLogGlueDao;

    @RequestMapping
    public String index(HttpServletRequest request, Model model, int jobId) {
        XxlJobInfo jobInfo = this.xxlJobInfoDao.loadById(jobId);
        List jobLogGlues = this.xxlJobLogGlueDao.findByJobId(jobId);
        if (jobInfo == null) {
            throw new RuntimeException(I18nUtil.getString((String)"jobinfo_glue_jobid_unvalid"));
        }
        if (GlueTypeEnum.BEAN == GlueTypeEnum.match((String)jobInfo.getGlueType())) {
            throw new RuntimeException(I18nUtil.getString((String)"jobinfo_glue_gluetype_unvalid"));
        }
        JobInfoController.validReadPermission((HttpServletRequest)request, (int)jobInfo.getJobGroup());
        model.addAttribute("GlueTypeEnum", (Object)GlueTypeEnum.values());
        model.addAttribute("jobInfo", (Object)jobInfo);
        model.addAttribute("jobLogGlues", (Object)jobLogGlues);
        return "jobcode/jobcode.index";
    }

    @RequestMapping(value={"/save"})
    @ResponseBody
    public ReturnT<String> save(Model model, int id, String glueSource, String glueRemark) {
        if (glueRemark == null) {
            return new ReturnT(500, I18nUtil.getString((String)"system_please_input") + I18nUtil.getString((String)"jobinfo_glue_remark"));
        }
        if (glueRemark.length() < 4 || glueRemark.length() > 100) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_glue_remark_limit"));
        }
        XxlJobInfo exists_jobInfo = this.xxlJobInfoDao.loadById(id);
        if (exists_jobInfo == null) {
            return new ReturnT(500, I18nUtil.getString((String)"jobinfo_glue_jobid_unvalid"));
        }
        exists_jobInfo.setGlueSource(glueSource);
        exists_jobInfo.setGlueRemark(glueRemark);
        exists_jobInfo.setGlueUpdatetime(new Date());
        exists_jobInfo.setUpdateTime(new Date());
        this.xxlJobInfoDao.update(exists_jobInfo);
        XxlJobLogGlue xxlJobLogGlue = new XxlJobLogGlue();
        xxlJobLogGlue.setJobId(exists_jobInfo.getId());
        xxlJobLogGlue.setGlueType(exists_jobInfo.getGlueType());
        xxlJobLogGlue.setGlueSource(glueSource);
        xxlJobLogGlue.setGlueRemark(glueRemark);
        xxlJobLogGlue.setAddTime(new Date());
        xxlJobLogGlue.setUpdateTime(new Date());
        this.xxlJobLogGlueDao.save(xxlJobLogGlue);
        this.xxlJobLogGlueDao.removeOld(exists_jobInfo.getId(), 30);
        return ReturnT.SUCCESS;
    }
}

