/*
 * Decompiled with CFR 0.152.
 */
package top.canyie.pine.enhances;

import android.util.Log;
import top.canyie.pine.Pine;
import top.canyie.pine.PineConfig;
import top.canyie.pine.enhances.ClassInitMonitor;
import top.canyie.pine.enhances.PendingHookHandler;
import top.canyie.pine.utils.Primitives;

public final class PineEnhances {
    public static final String TAG = "PineEnhances";
    public static Pine.LibLoader libLoader = new Pine.LibLoader(){

        public void loadLib() {
            System.loadLibrary("pine-enhances");
        }
    };
    private static volatile boolean inited;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureInited() {
        if (inited) {
            return;
        }
        Class<PineEnhances> clazz = PineEnhances.class;
        synchronized (PineEnhances.class) {
            if (inited) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            if (libLoader != null) {
                libLoader.loadLib();
            }
            inited = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean enableDelayHook() {
        PineEnhances.ensureInited();
        if (!PendingHookHandler.canWork()) {
            Log.e((String)TAG, (String)"PendingHookHandler not working");
            return false;
        }
        PendingHookHandler.install().setEnabled(true);
        return true;
    }

    public static void logD(String fmt, Object ... args) {
        if (PineConfig.debug) {
            Log.d((String)TAG, (String)String.format(fmt, args));
        }
    }

    public static void logE(String msg, Throwable e) {
        Log.e((String)TAG, (String)msg, (Throwable)e);
    }

    public static void logE(String msg) {
        Log.e((String)TAG, (String)msg);
    }

    private static void onClassInit(long ptr) {
        try {
            Class cls = (Class)Pine.getObject((long)Primitives.currentArtThread(), (long)ptr);
            ClassInitMonitor.getCallback().onClassInit(cls);
        }
        catch (Throwable e) {
            PineEnhances.logE("Unexpected exception threw in onClassInit", e);
        }
    }

    static native boolean initClassInitMonitor(int var0, long var1, long var3, long var5, long var7, long var9, long var11, long var13);

    static native void careClassInit(long var0);

    public static native void recordMethodHooked(long var0, long var2, long var4);
}

