/*
 * Decompiled with CFR 0.152.
 */
package top.canyie.pine.enhances;

import android.annotation.SuppressLint;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import top.canyie.pine.Pine;
import top.canyie.pine.PineConfig;
import top.canyie.pine.callback.MethodHook;
import top.canyie.pine.enhances.ClassInitMonitor;
import top.canyie.pine.enhances.PineEnhances;

@SuppressLint(value={"SoonBlockedPrivateApi"})
public class PendingHookHandler
implements Pine.HookHandler,
ClassInitMonitor.Callback {
    private static final long DELAYING = 0L;
    private static final long PREVENT_ENTRY_UPDATE = 1L;
    private static volatile PendingHookHandler instance;
    private static Field status;
    private Pine.HookHandler realHandler;
    private ClassInitMonitor.Callback previousCb;
    private boolean enabled;
    private final Map<Class<?>, Set<Pine.HookRecord>> pendingMap = new HashMap();

    public PendingHookHandler(Pine.HookHandler realHandler) {
        this.realHandler = realHandler;
        this.previousCb = ClassInitMonitor.setCallback(this);
    }

    public static boolean canWork() {
        return status != null;
    }

    public static PendingHookHandler instance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PendingHookHandler install() {
        if (instance != null) return instance;
        Class<PendingHookHandler> clazz = PendingHookHandler.class;
        synchronized (PendingHookHandler.class) {
            instance = new PendingHookHandler(Pine.getHookHandler());
            Pine.setHookHandler((Pine.HookHandler)instance);
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void setEnabled(boolean e) {
        this.enabled = e;
    }

    public boolean shouldDelay(Member method, boolean newMethod, int modifiers) {
        if (!this.enabled) {
            return false;
        }
        if (!newMethod) {
            return false;
        }
        if (!(method instanceof Method)) {
            return false;
        }
        if (!Modifier.isStatic(modifiers)) {
            return false;
        }
        return !this.isClassInitialized(method.getDeclaringClass());
    }

    @SuppressLint(value={"NewApi"})
    public boolean isClassInitialized(Class<?> cls) {
        int status;
        try {
            status = PendingHookHandler.status.getInt(cls);
        }
        catch (IllegalAccessException e) {
            throw new AssertionError((Object)e);
        }
        if (PineConfig.sdkLevel >= 28) {
            return (status = (int)(Integer.toUnsignedLong(status) >> 28)) >= 14;
        }
        if (PineConfig.sdkLevel == 27) {
            return status == 11;
        }
        return status == 10;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public MethodHook.Unhook handleHook(Pine.HookRecord hookRecord, MethodHook hook, int modifiers, boolean newMethod, boolean canInitDeclaringClass) {
        Member target = hookRecord.target;
        if (hook != null && this.shouldDelay(target, newMethod, modifiers)) {
            PineEnhances.logD("Delay hook method %s", target);
            PineEnhances.recordMethodHooked(hookRecord.artMethod, 0L);
            Class<?> declaring = hookRecord.target.getDeclaringClass();
            Map<Class<?>, Set<Pine.HookRecord>> map = this.pendingMap;
            synchronized (map) {
                Set<Pine.HookRecord> pendingHooks = this.pendingMap.get(declaring);
                if (pendingHooks == null) {
                    pendingHooks = new HashSet<Pine.HookRecord>(1, 1.0f);
                    this.pendingMap.put(declaring, pendingHooks);
                    ClassInitMonitor.care(declaring);
                }
                pendingHooks.add(hookRecord);
            }
            hookRecord.addCallback(hook);
            MethodHook methodHook = hook;
            Objects.requireNonNull(methodHook);
            return new MethodHook.Unhook(methodHook, hookRecord);
        }
        PineEnhances.logD("Not delay method %s", target);
        if (newMethod) {
            PineEnhances.recordMethodHooked(hookRecord.artMethod, 1L);
        }
        MethodHook.Unhook u = this.realHandler.handleHook(hookRecord, hook, modifiers, newMethod, canInitDeclaringClass);
        if (newMethod) {
            PineEnhances.recordMethodHooked(hookRecord.artMethod, Pine.getArtMethod((Member)hookRecord.backup));
        }
        return u;
    }

    public void handleUnhook(Pine.HookRecord hookRecord, MethodHook hook) {
        this.realHandler.handleUnhook(hookRecord, hook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onClassInit(Class<?> cls) {
        Set<Pine.HookRecord> pendingHooks;
        if (this.previousCb != null) {
            this.previousCb.onClassInit(cls);
        }
        Map<Class<?>, Set<Pine.HookRecord>> map = this.pendingMap;
        synchronized (map) {
            pendingHooks = this.pendingMap.remove(cls);
        }
        if (pendingHooks == null) {
            return;
        }
        for (Pine.HookRecord hookRecord : pendingHooks) {
            Member target = hookRecord.target;
            PineEnhances.logD("Flushing pending hooks for method %s", target);
            PineEnhances.recordMethodHooked(hookRecord.artMethod, 1L);
            this.realHandler.handleHook(hookRecord, null, target.getModifiers(), true, false);
            PineEnhances.recordMethodHooked(hookRecord.artMethod, Pine.getArtMethod((Member)hookRecord.backup));
        }
    }

    static {
        try {
            if (ClassInitMonitor.canWork()) {
                status = Class.class.getDeclaredField("status");
                status.setAccessible(true);
                Pine.setDebuggable((boolean)false);
            } else {
                PineEnhances.logE("Skipped initializing PendingHookHandler because ClassInitMonitor not working");
            }
        }
        catch (Throwable e) {
            PineEnhances.logE("PendingHookHandler init error", e);
        }
    }
}

