/*
 * Decompiled with CFR 0.152.
 */
package top.canyie.pine;

import android.annotation.SuppressLint;
import android.os.Build;
import android.util.Log;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Proxy;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.lsposed.hiddenapibypass.HiddenApiBypass;
import top.canyie.pine.PineConfig;
import top.canyie.pine.callback.MethodHook;
import top.canyie.pine.entry.Arm64MarshmallowEntry;

public final class Pine {
    private static final String TAG = "Pine";
    public static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private static final int ARCH_ARM = 1;
    private static final int ARCH_ARM64 = 2;
    private static final int ARCH_X86 = 3;
    private static volatile boolean initialized;
    private static final Map<String, Method> sBridgeMethods;
    private static final Map<Long, HookRecord> sHookRecords;
    private static final Object sHookLock;
    private static int arch;
    private static volatile int hookMode;
    private static HookHandler sHookHandler;
    private static HookListener sHookListener;
    public static long openElf;
    public static long findElfSymbol;
    public static long closeElf;

    private Pine() {
        throw new RuntimeException("Use static methods");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void ensureInitialized() {
        if (initialized) {
            return;
        }
        Class<Pine> clazz = Pine.class;
        synchronized (Pine.class) {
            if (initialized) {
                // ** MonitorExit[var0] (shouldn't be in output)
                return;
            }
            Pine.initialize();
            initialized = true;
            // ** MonitorExit[var0] (shouldn't be in output)
            return;
        }
    }

    public static boolean isInitialized() {
        return initialized;
    }

    private static boolean isAtLeastPreReleaseCodename(String codename) {
        String buildCodename = Build.VERSION.CODENAME.toUpperCase(Locale.ROOT);
        if ("REL".equals(buildCodename)) {
            return false;
        }
        return buildCodename.compareTo(codename.toUpperCase(Locale.ROOT)) >= 0;
    }

    @SuppressLint(value={"ObsoleteSdkInt"})
    private static void initialize() {
        String vmVersion;
        int sdkLevel = PineConfig.sdkLevel;
        if (sdkLevel < 19) {
            throw new RuntimeException("Unsupported android sdk level " + sdkLevel);
        }
        if (sdkLevel == 34 && Pine.isAtLeastPreReleaseCodename("VanillaIceCream")) {
            sdkLevel = 35;
            if (PineConfig.disableHiddenApiPolicy || PineConfig.disableHiddenApiPolicyForPlatformDomain) {
                HiddenApiBypass.addHiddenApiExemptions((String[])new String[]{""});
            }
        }
        if ((vmVersion = System.getProperty("java.vm.version")) == null || !vmVersion.startsWith("2")) {
            throw new RuntimeException("Only supports ART runtime");
        }
        hookMode = sdkLevel < 26 ? 3 : 2;
        try {
            LibLoader libLoader = PineConfig.libLoader;
            if (libLoader != null) {
                libLoader.loadLib();
            }
            Pine.init0(sdkLevel, PineConfig.debug, PineConfig.debuggable, PineConfig.antiChecks, PineConfig.disableHiddenApiPolicy, PineConfig.disableHiddenApiPolicyForPlatformDomain);
            Pine.initBridgeMethods();
            if (PineConfig.useFastNative && sdkLevel >= 21) {
                Pine.enableFastNative();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Pine init error", e);
        }
    }

    private static void initBridgeMethods() {
        try {
            String[] bridgeMethodNames;
            Class[] paramTypes;
            String entryClassName;
            if (arch == 2) {
                entryClassName = "top.canyie.pine.entry.Arm64Entry";
                paramTypes = new Class[]{Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE, Long.TYPE};
            } else if (arch == 1) {
                entryClassName = "top.canyie.pine.entry.Arm32Entry";
                paramTypes = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
            } else if (arch == 3) {
                entryClassName = "top.canyie.pine.entry.X86Entry";
                paramTypes = new Class[]{Integer.TYPE, Integer.TYPE, Integer.TYPE};
            } else {
                throw new RuntimeException("Unexpected arch " + arch);
            }
            Class<?> entryClass = Class.forName(entryClassName, true, Pine.class.getClassLoader());
            for (String bridgeMethodName : bridgeMethodNames = new String[]{"voidBridge", "intBridge", "longBridge", "doubleBridge", "floatBridge", "booleanBridge", "byteBridge", "charBridge", "shortBridge", "objectBridge"}) {
                Method bridge = entryClass.getDeclaredMethod(bridgeMethodName, paramTypes);
                bridge.setAccessible(true);
                sBridgeMethods.put(bridgeMethodName, bridge);
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to init bridge methods", e);
        }
    }

    public static void setHookMode(int newHookMode) {
        if (newHookMode < 0 || newHookMode > 3) {
            throw new IllegalArgumentException("Illegal hookMode " + newHookMode);
        }
        if (newHookMode == 0) {
            newHookMode = PineConfig.sdkLevel < 26 ? 3 : 2;
        }
        hookMode = newHookMode;
    }

    public static void setHookHandler(HookHandler h) {
        if (h == null) {
            throw new NullPointerException("handler == null");
        }
        sHookHandler = h;
    }

    public static HookHandler getHookHandler() {
        return sHookHandler;
    }

    public static void setHookListener(HookListener l) {
        sHookListener = l;
    }

    public static HookListener getHookListener() {
        return sHookListener;
    }

    public static boolean is64Bit() {
        Pine.ensureInitialized();
        return arch == 2;
    }

    public static MethodHook.Unhook hook(Member method, MethodHook callback) {
        return Pine.hook(method, callback, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MethodHook.Unhook hook(Member method, MethodHook callback, boolean canInitDeclaringClass) {
        HookRecord hookRecord;
        if (PineConfig.debug) {
            Log.d((String)TAG, (String)("Hooking method " + method + " with callback " + callback));
        }
        if (method == null) {
            throw new NullPointerException("method == null");
        }
        if (callback == null) {
            throw new NullPointerException("callback == null");
        }
        int modifiers = method.getModifiers();
        if (method instanceof Method) {
            if (Modifier.isAbstract(modifiers)) {
                throw new IllegalArgumentException("Cannot hook abstract methods: " + method);
            }
            ((Method)method).setAccessible(true);
        } else if (method instanceof Constructor) {
            if (Modifier.isStatic(modifiers)) {
                throw new IllegalArgumentException("Cannot hook class initializer: " + method);
            }
            ((Constructor)method).setAccessible(true);
        } else {
            throw new IllegalArgumentException("Only methods and constructors can be hooked: " + method);
        }
        Pine.ensureInitialized();
        HookListener hookListener = sHookListener;
        if (hookListener != null) {
            hookListener.beforeHook(method, callback);
        }
        long artMethod = Pine.getArtMethod(method);
        boolean newMethod = false;
        Object object = sHookLock;
        synchronized (object) {
            hookRecord = sHookRecords.get(artMethod);
            if (hookRecord == null) {
                newMethod = true;
                hookRecord = new HookRecord(method, artMethod);
                sHookRecords.put(artMethod, hookRecord);
            }
        }
        MethodHook.Unhook unhook = sHookHandler.handleHook(hookRecord, callback, modifiers, newMethod, canInitDeclaringClass);
        if (hookListener != null) {
            hookListener.afterHook(method, unhook);
        }
        return unhook;
    }

    static void hookNewMethod(HookRecord hookRecord, int modifiers, boolean canInitDeclaringClass) {
        Method bridge;
        String bridgeMethodName;
        Member method = hookRecord.target;
        int mode = hookMode;
        boolean isInlineHook = mode == 1 || mode == 3;
        long thread = Pine.currentArtThread0();
        hookRecord.isStatic = Modifier.isStatic(modifiers);
        if (hookRecord.isStatic && canInitDeclaringClass) {
            Pine.resolve((Method)method);
            if (PineConfig.sdkLevel >= 29) {
                Pine.makeClassesVisiblyInitialized(thread);
            }
        }
        Class<?> declaring = method.getDeclaringClass();
        boolean jni = Modifier.isNative(modifiers);
        boolean proxy = Proxy.isProxyClass(declaring);
        if (isInlineHook) {
            if (!jni && !proxy) {
                boolean compiled;
                if (mode == 1 && !(compiled = Pine.compile0(thread, method))) {
                    Log.w((String)TAG, (String)"Cannot compile the target method, force replacement mode.");
                    isInlineHook = false;
                }
            } else {
                isInlineHook = false;
            }
        }
        if (method instanceof Method) {
            hookRecord.paramTypes = ((Method)method).getParameterTypes();
            Class<?> returnType = ((Method)method).getReturnType();
            bridgeMethodName = returnType.isPrimitive() ? returnType.getName() + "Bridge" : "objectBridge";
        } else {
            hookRecord.paramTypes = ((Constructor)method).getParameterTypes();
            bridgeMethodName = "voidBridge";
        }
        hookRecord.paramNumber = hookRecord.paramTypes.length;
        Method method2 = bridge = PineConfig.sdkLevel == 23 && arch == 2 ? Arm64MarshmallowEntry.getBridge(bridgeMethodName, hookRecord.paramNumber) : sBridgeMethods.get(bridgeMethodName);
        if (bridge == null) {
            throw new AssertionError((Object)("Cannot find bridge method for " + method));
        }
        Method backup = Pine.hook0(thread, declaring, method, bridge, isInlineHook, jni, proxy);
        if (backup == null) {
            throw new RuntimeException("Failed to hook method " + method);
        }
        backup.setAccessible(true);
        hookRecord.backup = backup;
    }

    private static void resolve(Method method) {
        Object[] badArgs = method.getParameterTypes().length > 0 ? null : new Object[1];
        try {
            method.invoke(null, badArgs);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (Exception e) {
            throw new RuntimeException("Unknown exception thrown when resolve static method.", e);
        }
        throw new RuntimeException("No IllegalArgumentException thrown when resolve static method.");
    }

    public static boolean isHooked(Member method) {
        if (!(method instanceof Method) && !(method instanceof Constructor)) {
            throw new IllegalArgumentException("Only methods and constructors can be hooked: " + method);
        }
        return sHookRecords.containsKey(Pine.getArtMethod(method));
    }

    public static HookRecord getHookRecord(long artMethod) {
        HookRecord result = sHookRecords.get(artMethod);
        if (result == null) {
            throw new AssertionError((Object)("No HookRecord found for ArtMethod pointer 0x" + Long.toHexString(artMethod)));
        }
        return result;
    }

    public static Object getObject(long thread, long address) {
        if (address == 0L) {
            return null;
        }
        return Pine.getObject0(thread, address);
    }

    public static long getAddress(long thread, Object o) {
        if (o == null) {
            return 0L;
        }
        return Pine.getAddress0(thread, o);
    }

    static Object callBackupMethod(Member origin, Method backup, Object thisObject, Object[] args) throws InvocationTargetException, IllegalAccessException {
        Class<?> declaring = origin.getDeclaringClass();
        Pine.syncMethodInfo(origin, backup);
        Object result = backup.invoke(thisObject, args);
        declaring.getClass();
        return result;
    }

    public static Object invokeOriginalMethod(Member method, Object thisObject, Object ... args) throws IllegalAccessException, InvocationTargetException {
        if (method == null) {
            throw new NullPointerException("method == null");
        }
        if (method instanceof Method) {
            ((Method)method).setAccessible(true);
        } else if (method instanceof Constructor) {
            ((Constructor)method).setAccessible(true);
        } else {
            throw new IllegalArgumentException("method must be of type Method or Constructor");
        }
        HookRecord hookRecord = sHookRecords.get(Pine.getArtMethod(method));
        if (hookRecord == null) {
            if (PineConfig.debug) {
                Log.w((String)TAG, (String)("Attempting to invoke original implementation on a not-hooked method " + method + ". This is undefined behavior and may have side effect (e.g. if other threads hooked the method before we actually call Method.invoke(), the registered hooks will be triggered)."), (Throwable)new Throwable("here"));
            }
            if (method instanceof Constructor) {
                if (thisObject != null) {
                    throw new IllegalArgumentException("Cannot invoke a not hooked Constructor with a non-null receiver");
                }
                try {
                    return ((Constructor)method).newInstance(args);
                }
                catch (InstantiationException e) {
                    throw new IllegalArgumentException("invalid Constructor", e);
                }
            }
            return ((Method)method).invoke(thisObject, args);
        }
        if (hookRecord.backup == null) {
            assert (method instanceof Method);
            Pine.resolve((Method)method);
        }
        return Pine.callBackupMethod(hookRecord.target, hookRecord.backup, thisObject, args);
    }

    public static boolean compile(Member method) {
        int modifiers = method.getModifiers();
        Class<?> declaring = method.getDeclaringClass();
        if (!(method instanceof Method) && !(method instanceof Constructor)) {
            throw new IllegalArgumentException("Only methods and constructors can be compiled: " + method);
        }
        if (Modifier.isAbstract(modifiers)) {
            throw new IllegalArgumentException("Cannot compile abstract methods: " + method);
        }
        if (Modifier.isNative(modifiers) || Proxy.isProxyClass(declaring)) {
            return false;
        }
        Pine.ensureInitialized();
        return Pine.compile0(Pine.currentArtThread0(), method);
    }

    public static boolean decompile(Member method, boolean disableJit) {
        int modifiers = method.getModifiers();
        Class<?> declaring = method.getDeclaringClass();
        if (!(method instanceof Method) && !(method instanceof Constructor)) {
            throw new IllegalArgumentException("Only methods and constructors can be decompiled: " + method);
        }
        if (Modifier.isAbstract(modifiers)) {
            throw new IllegalArgumentException("Cannot decompile abstract methods: " + method);
        }
        if (Proxy.isProxyClass(declaring)) {
            return false;
        }
        Pine.ensureInitialized();
        return Pine.decompile0(method, disableJit);
    }

    public static boolean disableJitInline() {
        if (PineConfig.sdkLevel < 24) {
            return false;
        }
        Pine.ensureInitialized();
        return Pine.disableJitInline0();
    }

    public static void setJitCompilationAllowed(boolean allowed) {
        Pine.setJitCompilationAllowed(allowed, false);
    }

    public static void setJitCompilationAllowed(boolean allowed, boolean autoCompileBridge) {
        if (PineConfig.sdkLevel < 24) {
            return;
        }
        Pine.ensureInitialized();
        Pine.setJitCompilationAllowed0(allowed, autoCompileBridge);
    }

    public static boolean disableProfileSaver() {
        if (PineConfig.sdkLevel < 24) {
            return false;
        }
        Pine.ensureInitialized();
        return Pine.disableProfileSaver0();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    public static void setDebuggable(boolean debuggable) {
        if (!initialized) {
            Class<Pine> clazz = Pine.class;
            // MONITORENTER : top.canyie.pine.Pine.class
            if (!initialized) {
                PineConfig.debuggable = debuggable;
                Pine.initialize();
                initialized = true;
                // MONITOREXIT : clazz
                return;
            }
            // MONITOREXIT : clazz
        }
        PineConfig.debuggable = debuggable;
        Pine.setDebuggable0(debuggable);
    }

    public static void disableHiddenApiPolicy(boolean application, boolean platform) {
        if (initialized) {
            Pine.disableHiddenApiPolicy0(application, platform);
        } else {
            PineConfig.disableHiddenApiPolicy = application;
            PineConfig.disableHiddenApiPolicyForPlatformDomain = platform;
            Pine.ensureInitialized();
        }
    }

    public static Object handleCall(HookRecord hookRecord, Object thisObject, Object[] args) throws Throwable {
        if (PineConfig.debug) {
            Log.d((String)TAG, (String)("handleCall for method " + hookRecord.target));
        }
        if (PineConfig.disableHooks || hookRecord.emptyCallbacks()) {
            try {
                return Pine.callBackupMethod(hookRecord.target, hookRecord.backup, thisObject, args);
            }
            catch (InvocationTargetException e) {
                throw e.getTargetException();
            }
        }
        CallFrame callFrame = new CallFrame(hookRecord, thisObject, args);
        MethodHook[] callbacks = hookRecord.getCallbacks();
        int beforeIdx = 0;
        do {
            MethodHook callback = callbacks[beforeIdx];
            try {
                callback.beforeCall(callFrame);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("Unexpected exception occurred when calling " + callback.getClass().getName() + ".beforeCall()"), (Throwable)e);
                callFrame.resetResult();
                continue;
            }
            if (!callFrame.returnEarly) continue;
            ++beforeIdx;
            break;
        } while (++beforeIdx < callbacks.length);
        if (!callFrame.returnEarly) {
            try {
                callFrame.setResult(callFrame.invokeOriginalMethod());
            }
            catch (InvocationTargetException e) {
                callFrame.setThrowable(e.getTargetException());
            }
        }
        int afterIdx = beforeIdx - 1;
        do {
            MethodHook callback = callbacks[afterIdx];
            Object lastResult = callFrame.getResult();
            Throwable lastThrowable = callFrame.getThrowable();
            try {
                callback.afterCall(callFrame);
            }
            catch (Throwable e) {
                Log.e((String)TAG, (String)("Unexpected exception occurred when calling " + callback.getClass().getName() + ".afterCall()"), (Throwable)e);
                if (lastThrowable == null) {
                    callFrame.setResult(lastResult);
                    continue;
                }
                callFrame.setThrowable(lastThrowable);
            }
        } while (--afterIdx >= 0);
        if (callFrame.hasThrowable()) {
            throw callFrame.getThrowable();
        }
        return callFrame.getResult();
    }

    public static void log(String message) {
        if (PineConfig.debug) {
            Log.i((String)TAG, (String)message);
        }
    }

    public static void log(String fmt, Object ... args) {
        if (PineConfig.debug) {
            Log.i((String)TAG, (String)String.format(fmt, args));
        }
    }

    private static native void init0(int var0, boolean var1, boolean var2, boolean var3, boolean var4, boolean var5);

    private static native void enableFastNative();

    public static native long getArtMethod(Member var0);

    private static native Method hook0(long var0, Class<?> var2, Member var3, Method var4, boolean var5, boolean var6, boolean var7);

    private static native boolean compile0(long var0, Member var2);

    private static native boolean decompile0(Member var0, boolean var1);

    private static native boolean disableJitInline0();

    private static native void setJitCompilationAllowed0(boolean var0, boolean var1);

    private static native boolean disableProfileSaver0();

    private static native Object getObject0(long var0, long var2);

    private static native long getAddress0(long var0, Object var2);

    public static native void getArgsArm32(int var0, int var1, int[] var2, int[] var3, float[] var4);

    public static native void getArgsArm64(long var0, long var2, boolean[] var4, long[] var5, long[] var6, double[] var7);

    public static native void getArgsX86(int var0, int[] var1, int var2);

    private static native void syncMethodInfo(Member var0, Method var1);

    public static native long currentArtThread0();

    private static native void setDebuggable0(boolean var0);

    private static native void disableHiddenApiPolicy0(boolean var0, boolean var1);

    private static native void makeClassesVisiblyInitialized(long var0);

    public static native long cloneExtras(long var0);

    static {
        sBridgeMethods = new HashMap<String, Method>(8, 2.0f);
        sHookRecords = new ConcurrentHashMap<Long, HookRecord>();
        sHookLock = new Object();
        sHookHandler = new HookHandler(){

            @Override
            public MethodHook.Unhook handleHook(HookRecord hookRecord, MethodHook hook, int modifiers, boolean newMethod, boolean canInitDeclaringClass) {
                if (newMethod) {
                    Pine.hookNewMethod(hookRecord, modifiers, canInitDeclaringClass);
                }
                if (hook == null) {
                    return null;
                }
                hookRecord.addCallback(hook);
                MethodHook methodHook = hook;
                Objects.requireNonNull(methodHook);
                return new MethodHook.Unhook(methodHook, hookRecord);
            }

            @Override
            public void handleUnhook(HookRecord hookRecord, MethodHook hook) {
                hookRecord.removeCallback(hook);
            }
        };
    }

    public static interface HookMode {
        public static final int AUTO = 0;
        @Deprecated
        public static final int INLINE = 1;
        public static final int REPLACEMENT = 2;
        public static final int INLINE_WITHOUT_JIT = 3;
    }

    public static interface LibLoader {
        public void loadLib();
    }

    public static interface HookHandler {
        public MethodHook.Unhook handleHook(HookRecord var1, MethodHook var2, int var3, boolean var4, boolean var5);

        public void handleUnhook(HookRecord var1, MethodHook var2);
    }

    public static interface HookListener {
        public void beforeHook(Member var1, MethodHook var2);

        public void afterHook(Member var1, MethodHook.Unhook var2);
    }

    public static final class HookRecord {
        public final Member target;
        public final long artMethod;
        public Method backup;
        public boolean isStatic;
        public int paramNumber;
        public Class<?>[] paramTypes;
        private Set<MethodHook> callbacks = new HashSet<MethodHook>();
        public volatile Object paramTypesCache;

        public HookRecord(Member target, long artMethod) {
            this.target = target;
            this.artMethod = artMethod;
        }

        public synchronized void addCallback(MethodHook callback) {
            this.callbacks.add(callback);
        }

        public synchronized void removeCallback(MethodHook callback) {
            this.callbacks.remove(callback);
        }

        public synchronized boolean emptyCallbacks() {
            return this.callbacks.isEmpty();
        }

        public synchronized MethodHook[] getCallbacks() {
            return this.callbacks.toArray(new MethodHook[this.callbacks.size()]);
        }

        public boolean isPending() {
            return this.backup == null;
        }
    }

    public static class CallFrame {
        public final Member method;
        public Object thisObject;
        public Object[] args;
        private Object result;
        private Throwable throwable;
        boolean returnEarly;
        private HookRecord hookRecord;

        public CallFrame(HookRecord hookRecord, Object thisObject, Object[] args) {
            this.hookRecord = hookRecord;
            this.method = hookRecord.target;
            this.thisObject = thisObject;
            this.args = args;
        }

        public Object getResult() {
            return this.result;
        }

        public void setResult(Object result) {
            this.result = result;
            this.throwable = null;
            this.returnEarly = true;
        }

        public void setResultIfNoException(Object result) {
            if (this.throwable == null) {
                this.result = result;
                this.returnEarly = true;
            }
        }

        public Throwable getThrowable() {
            return this.throwable;
        }

        public boolean hasThrowable() {
            return this.throwable != null;
        }

        public void setThrowable(Throwable throwable) {
            this.throwable = throwable;
            this.result = null;
            this.returnEarly = true;
        }

        public Object getResultOrThrowable() throws Throwable {
            if (this.throwable != null) {
                throw this.throwable;
            }
            return this.result;
        }

        public void resetResult() {
            this.result = null;
            this.throwable = null;
            this.returnEarly = false;
        }

        public Object invokeOriginalMethod() throws InvocationTargetException, IllegalAccessException {
            return Pine.callBackupMethod(this.hookRecord.target, this.hookRecord.backup, this.thisObject, this.args);
        }

        public Object invokeOriginalMethod(Object thisObject, Object ... args) throws InvocationTargetException, IllegalAccessException {
            return Pine.callBackupMethod(this.hookRecord.target, this.hookRecord.backup, thisObject, args);
        }
    }
}

