/*
 * Decompiled with CFR 0.152.
 */
package top.canyie.pine.utils;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import top.canyie.pine.PineConfig;

public final class ReflectionHelper {
    private static Field override;

    private ReflectionHelper() {
    }

    public static void forceAccessible(AccessibleObject member) {
        try {
            member.setAccessible(true);
            if (member.isAccessible()) {
                return;
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        if (override == null) {
            override = ReflectionHelper.getField(AccessibleObject.class, PineConfig.sdkLevel >= 24 ? "override" : "flag");
        }
        try {
            override.setBoolean(member, true);
        }
        catch (IllegalAccessException e) {
            throw new SecurityException("Cannot set AccessibleObject.override", e);
        }
    }

    public static Field getField(Class<?> c, String name) {
        Field field = ReflectionHelper.findField(c, name);
        if (field == null) {
            throw new IllegalArgumentException("No field " + name + " found in " + c);
        }
        return field;
    }

    public static Field findField(Class<?> c, String name) {
        while (c != null) {
            try {
                Field field = c.getDeclaredField(name);
                field.setAccessible(true);
                return field;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                c = c.getSuperclass();
            }
        }
        return null;
    }

    public static Method getMethod(Class<?> c, String name, Class<?> ... paramTypes) {
        Method method = ReflectionHelper.findMethod(c, name, paramTypes);
        if (method == null) {
            throw new IllegalArgumentException("No method " + name + " with params " + Arrays.toString(paramTypes) + " found in " + c);
        }
        return method;
    }

    public static Method findMethod(Class<?> c, String name, Class<?> ... paramTypes) {
        while (c != null) {
            try {
                Method method = c.getDeclaredMethod(name, paramTypes);
                method.setAccessible(true);
                return method;
            }
            catch (NoSuchMethodException noSuchMethodException) {
                c = c.getSuperclass();
            }
        }
        return null;
    }

    public static <T> Constructor<T> getConstructor(Class<T> c, Class<?> ... paramTypes) {
        try {
            Constructor<T> constructor = c.getDeclaredConstructor(paramTypes);
            ReflectionHelper.forceAccessible(constructor);
            return constructor;
        }
        catch (NoSuchMethodException e) {
            throw new IllegalArgumentException("No constructor found with params " + Arrays.toString(paramTypes), e);
        }
    }

    public static <T> Constructor<T> findConstructor(Class<T> c, Class<?> ... paramTypes) {
        try {
            Constructor<T> constructor = c.getDeclaredConstructor(paramTypes);
            ReflectionHelper.forceAccessible(constructor);
            return constructor;
        }
        catch (NoSuchMethodException ignored) {
            return null;
        }
    }
}

