/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.scala.deser;

import java.io.Serializable;
import scala.;
import scala.$less$colon$less$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.Tuple2$;
import scala.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.util.Either;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationConfig;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.std.StdDeserializer;
import tools.jackson.databind.jsontype.TypeDeserializer;
import tools.jackson.module.scala.deser.EitherDeserializer$ElementDeserializerConfig$;
import tools.jackson.module.scala.deser.OptionDeserializer;

public class EitherDeserializer
extends StdDeserializer<Either<Object, Object>> {
    private final JavaType javaType;
    private final DeserializationConfig deserializationConfig;
    private final ElementDeserializerConfig leftDeserializerConfig;
    private final ElementDeserializerConfig rightDeserializerConfig;

    public EitherDeserializer(JavaType javaType, DeserializationConfig deserializationConfig, ElementDeserializerConfig leftDeserializerConfig, ElementDeserializerConfig rightDeserializerConfig) {
        this.javaType = javaType;
        this.deserializationConfig = deserializationConfig;
        this.leftDeserializerConfig = leftDeserializerConfig;
        this.rightDeserializerConfig = rightDeserializerConfig;
        super(Either.class);
    }

    public ValueDeserializer<Either<Object, Object>> createContextual(DeserializationContext ctxt, BeanProperty property) {
        int n = this.javaType.containedTypeCount();
        if (2 == n) {
            ElementDeserializerConfig leftDeserializerConfig = this.deserializerConfigFor$1(ctxt, 0, property);
            ElementDeserializerConfig rightDeserializerConfig = this.deserializerConfigFor$1(ctxt, 1, property);
            return new EitherDeserializer(this.javaType, this.deserializationConfig, leftDeserializerConfig, rightDeserializerConfig);
        }
        if (1 == n) {
            String string = this.javaType.getBindings().getBoundName(0);
            String string2 = "A";
            if (!(string != null ? !string.equals(string2) : string2 != null)) {
                ElementDeserializerConfig leftDeserializerConfig = this.deserializerConfigFor$1(ctxt, 0, property);
                return new EitherDeserializer(this.javaType, this.deserializationConfig, leftDeserializerConfig, EitherDeserializer$ElementDeserializerConfig$.MODULE$.empty());
            }
            ElementDeserializerConfig rightDeserializerConfig = this.deserializerConfigFor$1(ctxt, 0, property);
            return new EitherDeserializer(this.javaType, this.deserializationConfig, EitherDeserializer$ElementDeserializerConfig$.MODULE$.empty(), rightDeserializerConfig);
        }
        return this;
    }

    private Object deserializeValue(JsonToken type, ElementDeserializerConfig config, JsonParser jp, DeserializationContext ctxt) {
        Tuple2 tuple2 = Tuple2$.MODULE$.apply((Object)config, (Object)type);
        if (tuple2 != null) {
            ElementDeserializerConfig elementDeserializerConfig = (ElementDeserializerConfig)tuple2._1();
            JsonToken jsonToken = (JsonToken)tuple2._2();
            if (elementDeserializerConfig != null) {
                ElementDeserializerConfig elementDeserializerConfig2 = EitherDeserializer$ElementDeserializerConfig$.MODULE$.unapply(elementDeserializerConfig);
                Option<ValueDeserializer<Object>> option = elementDeserializerConfig2._1();
                Option<TypeDeserializer> option2 = elementDeserializerConfig2._2();
                if (option instanceof Some) {
                    ValueDeserializer ed = (ValueDeserializer)((Some)option).value();
                    JsonToken jsonToken2 = JsonToken.VALUE_NULL;
                    JsonToken jsonToken3 = jsonToken;
                    if (!(jsonToken2 != null ? !jsonToken2.equals(jsonToken3) : jsonToken3 != null) && ed instanceof OptionDeserializer) {
                        return None$.MODULE$;
                    }
                }
            }
            JsonToken jsonToken4 = JsonToken.VALUE_NULL;
            JsonToken jsonToken5 = jsonToken;
            if (!(jsonToken4 != null ? !jsonToken4.equals(jsonToken5) : jsonToken5 != null)) {
                return None$.MODULE$.orNull((.less.colon.less)$less$colon$less$.MODULE$.refl());
            }
            if (elementDeserializerConfig != null) {
                ElementDeserializerConfig elementDeserializerConfig3 = EitherDeserializer$ElementDeserializerConfig$.MODULE$.unapply(elementDeserializerConfig);
                Option<ValueDeserializer<Object>> option = elementDeserializerConfig3._1();
                Option<TypeDeserializer> option3 = elementDeserializerConfig3._2();
                if (option instanceof Some) {
                    ValueDeserializer valueDeserializer;
                    ValueDeserializer ed = valueDeserializer = (ValueDeserializer)((Some)option).value();
                    if (option3 instanceof Some) {
                        TypeDeserializer td = (TypeDeserializer)((Some)option3).value();
                        return ed.deserializeWithType(jp, ctxt, td);
                    }
                    ValueDeserializer ed2 = valueDeserializer;
                    return ed2.deserialize(jp, ctxt);
                }
            }
            return ctxt.handleUnexpectedToken(this.javaType, jp);
        }
        throw new MatchError((Object)tuple2);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Either<Object, Object> deserializeEither(JsonParser jp, DeserializationContext ctxt) {
        Either either;
        block17: {
            JsonToken jsonToken;
            block15: {
                Either either2;
                block16: {
                    jsonToken = jp.currentToken();
                    JsonToken jsonToken2 = JsonToken.START_OBJECT;
                    JsonToken jsonToken3 = jsonToken;
                    if (jsonToken2 != null ? !jsonToken2.equals(jsonToken3) : jsonToken3 != null) break block15;
                    String key = jp.nextName();
                    JsonToken type = jp.nextToken();
                    String string = key;
                    switch (string == null ? 0 : string.hashCode()) {
                        case 108: {
                            if (!"l".equals(string)) break;
                            either2 = package$.MODULE$.Left().apply(this.deserializeValue(type, this.leftDeserializerConfig, jp, ctxt));
                            break block16;
                        }
                        case 114: {
                            if (!"r".equals(string)) break;
                            either2 = package$.MODULE$.Right().apply(this.deserializeValue(type, this.rightDeserializerConfig, jp, ctxt));
                            break block16;
                        }
                        case 3317767: {
                            if (!"left".equals(string)) break;
                            either2 = package$.MODULE$.Left().apply(this.deserializeValue(type, this.leftDeserializerConfig, jp, ctxt));
                            break block16;
                        }
                        case 108511772: {
                            if (!"right".equals(string)) break;
                            either2 = package$.MODULE$.Right().apply(this.deserializeValue(type, this.rightDeserializerConfig, jp, ctxt));
                            break block16;
                        }
                    }
                    either2 = (Either)ctxt.handleUnexpectedToken(this.javaType, jp);
                }
                Either result = either2;
                jp.nextToken();
                return result;
            }
            JsonToken jsonToken4 = JsonToken.START_ARRAY;
            JsonToken jsonToken5 = jsonToken;
            if (jsonToken4 == null) {
                if (jsonToken5 != null) {
                    return (Either)ctxt.handleUnexpectedToken(this.javaType, jp);
                }
            } else if (!jsonToken4.equals(jsonToken5)) return (Either)ctxt.handleUnexpectedToken(this.javaType, jp);
            String key = jp.nextStringValue();
            JsonToken type = jp.nextToken();
            String string = key;
            switch (string == null ? 0 : string.hashCode()) {
                case 108: {
                    if (!"l".equals(string)) break;
                    either = package$.MODULE$.Left().apply(this.deserializeValue(type, this.leftDeserializerConfig, jp, ctxt));
                    break block17;
                }
                case 114: {
                    if (!"r".equals(string)) break;
                    either = package$.MODULE$.Right().apply(this.deserializeValue(type, this.rightDeserializerConfig, jp, ctxt));
                    break block17;
                }
                case 3317767: {
                    if (!"left".equals(string)) break;
                    either = package$.MODULE$.Left().apply(this.deserializeValue(type, this.leftDeserializerConfig, jp, ctxt));
                    break block17;
                }
                case 108511772: {
                    if (!"right".equals(string)) break;
                    either = package$.MODULE$.Right().apply(this.deserializeValue(type, this.rightDeserializerConfig, jp, ctxt));
                    break block17;
                }
            }
            either = (Either)ctxt.handleUnexpectedToken(this.javaType, jp);
        }
        Either result = either;
        jp.nextToken();
        return result;
    }

    public Either<Object, Object> deserialize(JsonParser jp, DeserializationContext ctxt) {
        return this.deserializeEither(jp, ctxt);
    }

    public Either<Object, Object> deserializeWithType(JsonParser jp, DeserializationContext ctxt, TypeDeserializer typeDeserializer) {
        return this.deserializeEither(jp, ctxt);
    }

    private final ElementDeserializerConfig deserializerConfigFor$1(DeserializationContext ctxt$1, int param, BeanProperty property) {
        JavaType containedType = this.javaType.containedType(param);
        Option paramDeserializer = Option$.MODULE$.apply((Object)ctxt$1.findContextualValueDeserializer(containedType, property));
        Option typeDeserializer = Option$.MODULE$.apply((Object)property).flatMap((Function1 & Serializable)p -> Option$.MODULE$.apply((Object)ctxt$1.findPropertyTypeDeserializer(containedType, p.getMember())));
        return EitherDeserializer$ElementDeserializerConfig$.MODULE$.apply((Option<ValueDeserializer<Object>>)paramDeserializer.map((Function1 & Serializable)_$1 -> _$1), (Option<TypeDeserializer>)typeDeserializer);
    }

    public static class ElementDeserializerConfig
    implements Product,
    Serializable {
        private final Option deserializer;
        private final Option typeDeseriazlier;

        public static ElementDeserializerConfig apply(Option<ValueDeserializer<Object>> option, Option<TypeDeserializer> option2) {
            return EitherDeserializer$ElementDeserializerConfig$.MODULE$.apply(option, option2);
        }

        public static ElementDeserializerConfig empty() {
            return EitherDeserializer$ElementDeserializerConfig$.MODULE$.empty();
        }

        public static ElementDeserializerConfig fromProduct(Product product) {
            return EitherDeserializer$ElementDeserializerConfig$.MODULE$.fromProduct(product);
        }

        public static ElementDeserializerConfig unapply(ElementDeserializerConfig elementDeserializerConfig) {
            return EitherDeserializer$ElementDeserializerConfig$.MODULE$.unapply(elementDeserializerConfig);
        }

        public ElementDeserializerConfig(Option<ValueDeserializer<Object>> deserializer, Option<TypeDeserializer> typeDeseriazlier) {
            this.deserializer = deserializer;
            this.typeDeseriazlier = typeDeseriazlier;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$0) {
            if (this == x$0) return true;
            Object object = x$0;
            if (!(object instanceof ElementDeserializerConfig)) return false;
            ElementDeserializerConfig elementDeserializerConfig = (ElementDeserializerConfig)object;
            Option<ValueDeserializer<Object>> option = this.deserializer();
            Option<ValueDeserializer<Object>> option2 = elementDeserializerConfig.deserializer();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            Option<TypeDeserializer> option3 = this.typeDeseriazlier();
            Option<TypeDeserializer> option4 = elementDeserializerConfig.typeDeseriazlier();
            if (option3 == null) {
                if (option4 != null) {
                    return false;
                }
            } else if (!option3.equals(option4)) return false;
            if (!elementDeserializerConfig.canEqual(this)) return false;
            return true;
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        public boolean canEqual(Object that) {
            return that instanceof ElementDeserializerConfig;
        }

        public int productArity() {
            return 2;
        }

        public String productPrefix() {
            return "ElementDeserializerConfig";
        }

        public Object productElement(int n) {
            int n2 = n;
            if (0 == n2) {
                return this._1();
            }
            if (1 == n2) {
                return this._2();
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public String productElementName(int n) {
            int n2 = n;
            if (0 == n2) {
                return "deserializer";
            }
            if (1 == n2) {
                return "typeDeseriazlier";
            }
            throw new IndexOutOfBoundsException(BoxesRunTime.boxToInteger((int)n).toString());
        }

        public Option<ValueDeserializer<Object>> deserializer() {
            return this.deserializer;
        }

        public Option<TypeDeserializer> typeDeseriazlier() {
            return this.typeDeseriazlier;
        }

        public ElementDeserializerConfig copy(Option<ValueDeserializer<Object>> deserializer, Option<TypeDeserializer> typeDeseriazlier) {
            return new ElementDeserializerConfig(deserializer, typeDeseriazlier);
        }

        public Option<ValueDeserializer<Object>> copy$default$1() {
            return this.deserializer();
        }

        public Option<TypeDeserializer> copy$default$2() {
            return this.typeDeseriazlier();
        }

        public Option<ValueDeserializer<Object>> _1() {
            return this.deserializer();
        }

        public Option<TypeDeserializer> _2() {
            return this.typeDeseriazlier();
        }
    }
}

