/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.scala.introspect;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.PartialFunction;
import scala.Predef$;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.Tuple2$;
import scala.Tuple3;
import scala.Tuple3$;
import scala.Tuple4;
import scala.Tuple4$;
import scala.collection.ArrayOps$;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.LazyList;
import scala.collection.immutable.LazyList$;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.math.Ordering;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.NameTransformer$;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ModuleSerializationProxy;
import scala.util.matching.Regex;
import tools.jackson.module.scala.introspect.BeanDescriptor;
import tools.jackson.module.scala.introspect.BeanDescriptor$;
import tools.jackson.module.scala.introspect.ConstructorParameter;
import tools.jackson.module.scala.introspect.ConstructorParameter$;
import tools.jackson.module.scala.introspect.JavaParameterIntrospector$;
import tools.jackson.module.scala.introspect.LazyListSupport$;
import tools.jackson.module.scala.introspect.PropertyDescriptor;
import tools.jackson.module.scala.introspect.PropertyDescriptor$;
import tools.jackson.module.scala.util.ClassW$;

public final class BeanIntrospector$
implements Serializable {
    public static final BeanIntrospector$ MODULE$ = new BeanIntrospector$();

    private BeanIntrospector$() {
    }

    private Object writeReplace() {
        return new ModuleSerializationProxy(BeanIntrospector$.class);
    }

    public <T> BeanDescriptor apply(Class<?> cls2) {
        List hierarchy = this.next$1(cls2, (List)package$.MODULE$.Nil());
        Regex privateRegex = StringOps$.MODULE$.r$extension(Predef$.MODULE$.augmentString("(.*)\\$\\$(.*)"));
        Seq fields = (Seq)hierarchy.flatMap(arg_0 -> this.$anonfun$3((Seq)hierarchy, privateRegex, arg_0));
        Seq methods = (Seq)hierarchy.flatMap((Function1 & Serializable)cls -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredMethods());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)getter -> {
                String name = NameTransformer$.MODULE$.decode(getter.getName());
                return Tuple2$.MODULE$.apply(getter, (Object)name);
            }, ClassTag$.MODULE$.apply(Tuple2.class)));
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.withFilter$extension(object2, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Method getter = (Method)tuple2._1();
                    String name = (String)tuple2._2();
                    return this.isAcceptableGetter$1(getter);
                }
                throw new MatchError((Object)tuple2);
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Method getter = (Method)tuple2._1();
                    String name = (String)tuple2._2();
                    return this.findField$1((Class)cls, name).isEmpty();
                }
                throw new MatchError((Object)tuple2);
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Method getter = (Method)tuple2._1();
                    String name = (String)tuple2._2();
                    return !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(name), '$');
                }
                throw new MatchError((Object)tuple2);
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Method getter = (Method)tuple2._1();
                    String name = (String)tuple2._2();
                    return !fields.exists((Function1 & Serializable)_$2 -> {
                        String string = _$2.name();
                        String string2 = name;
                        return !(string != null ? !string.equals(string2) : string2 != null);
                    });
                }
                throw new MatchError((Object)tuple2);
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Method getter = (Method)tuple2._1();
                    String name = (String)tuple2._2();
                    Tuple2 $2$ = tuple2;
                    Option getterProperty = Option$.MODULE$.apply((Object)getter.getAnnotation(JsonProperty.class));
                    Option setter = this.findSetter$1((Class)cls, name);
                    return Tuple3$.MODULE$.apply((Object)$2$, (Object)getterProperty, (Object)setter);
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Tuple3.class)));
            Object object4 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.withFilter$extension(object3, (Function1 & Serializable)x$1 -> {
                Tuple3 tuple3 = x$1;
                if (tuple3 == null) throw new MatchError((Object)tuple3);
                Tuple2 tuple2 = (Tuple2)tuple3._1();
                if (tuple2 == null) throw new MatchError((Object)tuple3);
                Method getter = (Method)tuple2._1();
                String name = (String)tuple2._2();
                Option getterProperty = (Option)tuple3._2();
                Option setter = (Option)tuple3._3();
                if (setter.isDefined()) return true;
                if (!getterProperty.isDefined()) return false;
                String string = ((JsonProperty)getterProperty.get()).value();
                String string2 = "";
                if (string == null) {
                    if (string2 == null) return false;
                    return true;
                } else if (string.equals(string2)) return false;
                return true;
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Tuple3 tuple3 = x$1;
                if (tuple3 != null && (tuple2 = (Tuple2)tuple3._1()) != null) {
                    Method getter = (Method)tuple2._1();
                    String name = (String)tuple2._2();
                    Option getterProperty = (Option)tuple3._2();
                    Option setter = (Option)tuple3._3();
                    Tuple3 $3$ = tuple3;
                    Option beanGetter = this.findBeanGetter$1((Class)cls, name);
                    Option beanSetter = this.findBeanSetter$1((Class)cls, name);
                    return Tuple3$.MODULE$.apply((Object)$3$, (Object)beanGetter, (Object)beanSetter);
                }
                throw new MatchError((Object)tuple3);
            }, ClassTag$.MODULE$.apply(Tuple3.class)));
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object4, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Tuple3 tuple3;
                Tuple3 tuple32 = x$1;
                if (tuple32 != null && (tuple3 = (Tuple3)tuple32._1()) != null && (tuple2 = (Tuple2)tuple3._1()) != null) {
                    Method getter = (Method)tuple2._1();
                    String name = (String)tuple2._2();
                    Option getterProperty = (Option)tuple3._2();
                    Option setter = (Option)tuple3._3();
                    Option beanGetter = (Option)tuple32._2();
                    Option beanSetter = (Option)tuple32._3();
                    return PropertyDescriptor$.MODULE$.apply(name, (Option<ConstructorParameter>)None$.MODULE$, (Option<Field>)None$.MODULE$, (Option<Method>)Some$.MODULE$.apply((Object)getter), (Option<Method>)setter, (Option<Method>)beanGetter, (Option<Method>)beanSetter);
                }
                throw new MatchError((Object)tuple32);
            }, ClassTag$.MODULE$.apply(PropertyDescriptor.class)));
        });
        String lazySuffix = "$lzy1";
        Seq lazyValMethods = (Seq)hierarchy.flatMap((Function1 & Serializable)hcls -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])hcls.getDeclaredFields());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)_$3 -> _$3.getName(), ClassTag$.MODULE$.apply(String.class)));
            Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.filter$extension(object2, (Function1 & Serializable)_$4 -> _$4.endsWith(lazySuffix)));
            Set fieldNames = Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)s -> s.substring(0, s.length() - lazySuffix.length()), ClassTag$.MODULE$.apply(String.class))).toSet();
            Object object4 = Predef$.MODULE$.refArrayOps((Object[])hcls.getDeclaredMethods());
            Object object5 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object4, (Function1 & Serializable)getter -> {
                String name = NameTransformer$.MODULE$.decode(getter.getName());
                return Tuple2$.MODULE$.apply(getter, (Object)name);
            }, ClassTag$.MODULE$.apply(Tuple2.class)));
            Object object6 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.withFilter$extension(object5, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Method getter = (Method)tuple2._1();
                    String name = (String)tuple2._2();
                    return !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(name), '$');
                }
                throw new MatchError((Object)tuple2);
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Method getter = (Method)tuple2._1();
                    String name = (String)tuple2._2();
                    return fieldNames.contains((Object)name);
                }
                throw new MatchError((Object)tuple2);
            }).withFilter((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Method getter = (Method)tuple2._1();
                    String name = (String)tuple2._2();
                    return this.isAcceptableGetter$1(getter);
                }
                throw new MatchError((Object)tuple2);
            }).map((Function1 & Serializable)x$1 -> {
                Tuple2 tuple2 = x$1;
                if (tuple2 != null) {
                    Method getter = (Method)tuple2._1();
                    String name = (String)tuple2._2();
                    Tuple2 $4$ = tuple2;
                    Option setter = this.findSetter$1(cls2, name);
                    Option beanGetter = this.findBeanGetter$1(cls2, name);
                    Option beanSetter = this.findBeanSetter$1(cls2, name);
                    return Tuple4$.MODULE$.apply((Object)$4$, (Object)setter, (Object)beanGetter, (Object)beanSetter);
                }
                throw new MatchError((Object)tuple2);
            }, ClassTag$.MODULE$.apply(Tuple4.class)));
            return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object6, (Function1 & Serializable)x$1 -> {
                Tuple2 tuple2;
                Tuple4 tuple4 = x$1;
                if (tuple4 != null && (tuple2 = (Tuple2)tuple4._1()) != null) {
                    Method getter = (Method)tuple2._1();
                    String name = (String)tuple2._2();
                    Option setter = (Option)tuple4._2();
                    Option beanGetter = (Option)tuple4._3();
                    Option beanSetter = (Option)tuple4._4();
                    return PropertyDescriptor$.MODULE$.apply(name, (Option<ConstructorParameter>)None$.MODULE$, (Option<Field>)None$.MODULE$, (Option<Method>)Some$.MODULE$.apply((Object)getter), (Option<Method>)setter, (Option<Method>)beanGetter, (Option<Method>)beanSetter);
                }
                throw new MatchError((Object)tuple4);
            }, ClassTag$.MODULE$.apply(PropertyDescriptor.class)));
        });
        return BeanDescriptor$.MODULE$.apply(cls2, (Seq<PropertyDescriptor>)((Seq)((IterableOps)fields.$plus$plus((IterableOnce)methods)).$plus$plus((IterableOnce)lazyValMethods)));
    }

    private String nameOfField(Field field, String originalName) {
        JsonProperty ann;
        Option option = Option$.MODULE$.apply((Object)field.getAnnotation(JsonProperty.class));
        if (option instanceof Some && StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString((ann = (JsonProperty)((Some)option).value()).value()))) {
            return ann.value();
        }
        return originalName;
    }

    private Seq<String> getCtorParams(Constructor<?> ctor) {
        IndexedSeq<String> names = JavaParameterIntrospector$.MODULE$.getCtorParamNames(ctor);
        return (Seq)names.map((Function1 & Serializable)name0 -> NameTransformer$.MODULE$.decode(name0));
    }

    private final Option findConstructorParam$1(Class c2, String name) {
        while (true) {
            block6: {
                block5: {
                    if (c2 == null) break block5;
                    Class clazz = c2;
                    Class<Object> clazz2 = Object.class;
                    if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block6;
                }
                return None$.MODULE$;
            }
            Object object = Predef$.MODULE$.refArrayOps((Object[])c2.getConstructors());
            Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.sortBy$extension(object, (Function1 & Serializable)c -> -c.getParameterCount(), (Ordering)Ordering.Int$.MODULE$));
            Option primaryConstructor = ArrayOps$.MODULE$.headOption$extension(object2);
            IndexedSeq debugCtorParamNames = (IndexedSeq)Option$.MODULE$.option2Iterable(primaryConstructor).toIndexedSeq().flatMap((Function1 & Serializable)ctor -> MODULE$.getCtorParams((Constructor<?>)ctor));
            int index = debugCtorParamNames.indexOf((Object)name);
            Option companion = this.findCompanionObject$1(c2);
            if (index >= 0) {
                return Some$.MODULE$.apply((Object)ConstructorParameter$.MODULE$.apply((Constructor)primaryConstructor.get(), index, (Option<Function0<Object>>)this.findConstructorDefaultValue$1(companion, index)));
            }
            c2 = c2.getSuperclass();
        }
    }

    private final Option findConstructorDefaultValue$1(Option maybeCompanion, int index) {
        String methodName = new StringBuilder(26).append("$lessinit$greater$default$").append(index + 1).toString();
        return maybeCompanion.flatMap((Function1 & Serializable)companion -> {
            Object object = Predef$.MODULE$.refArrayOps((Object[])companion.getClass().getMethods());
            return ArrayOps$.MODULE$.collectFirst$extension(object, (PartialFunction)new Serializable(methodName, companion){
                private final String methodName$2;
                private final Object companion$1;
                {
                    this.methodName$2 = methodName$3;
                    this.companion$1 = companion$2;
                }

                public final boolean isDefinedAt(Method x) {
                    Method method;
                    Method method2 = method = x;
                    String string = method2.getName();
                    String string2 = this.methodName$2;
                    return !(string != null ? !string.equals(string2) : string2 != null) && method2.getParameterTypes().length == 0;
                }

                public final Object applyOrElse(Method x, Function1 function1) {
                    Method method;
                    Method method2 = method = x;
                    String string = method2.getName();
                    String string2 = this.methodName$2;
                    if (!(string != null ? !string.equals(string2) : string2 != null) && method2.getParameterTypes().length == 0) {
                        return (Function0 & Serializable)() -> method2.invoke(this.companion$1, new Object[0]);
                    }
                    return function1.apply((Object)x);
                }

                private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                    return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{applyOrElse$$anonfun$1(java.lang.reflect.Method )}, serializedLambda);
                }
            });
        });
    }

    private final Option findCompanionObject$1(Class c) {
        None$ none$;
        try {
            none$ = Some$.MODULE$.apply(c.getClassLoader().loadClass(new StringBuilder(1).append(c.getName()).append("$").toString()).getDeclaredField("MODULE$").get(null));
        }
        catch (Exception e) {
            none$ = None$.MODULE$;
        }
        return none$;
    }

    private final List next$1(Class c, List acc) {
        while (true) {
            block4: {
                block3: {
                    if (c == null) break block3;
                    Class clazz = c;
                    Class<Object> clazz2 = Object.class;
                    if (clazz != null ? !clazz.equals(clazz2) : clazz2 != null) break block4;
                }
                return acc;
            }
            Class clazz = c.getSuperclass();
            List list = (List)acc.$colon$plus((Object)c);
            c = clazz;
            acc = list;
        }
    }

    private final LazyList listMethods$1$$anonfun$1(Class c$1) {
        return this.listMethods$1(c$1.getSuperclass());
    }

    private final LazyList listMethods$1(Class cls) {
        Class c;
        Class clazz = cls;
        if (clazz == null) {
            return LazyListSupport$.MODULE$.empty();
        }
        Class clazz2 = c = clazz;
        Class<Object> clazz3 = Object.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            return LazyListSupport$.MODULE$.empty();
        }
        Class c2 = clazz;
        LazyList lazyList = LazyListSupport$.MODULE$.fromArray(c2.getDeclaredMethods());
        Function0 function0 = LazyList$.MODULE$.toDeferrer(() -> this.listMethods$1$$anonfun$1(c2));
        return LazyList.Deferrer$.MODULE$.$hash$colon$colon$colon$extension(function0, lazyList);
    }

    private final boolean isNotSyntheticOrBridge$1(Method m) {
        return !m.isBridge() && !m.isSynthetic();
    }

    private final Seq findMethod$1(Class cls, String name) {
        return this.listMethods$1(cls).filter((Function1 & Serializable)m -> this.isNotSyntheticOrBridge$1((Method)m)).filter((Function1 & Serializable)m -> {
            String string = NameTransformer$.MODULE$.decode(m.getName());
            String string2 = name;
            return !(string != null ? !string.equals(string2) : string2 != null);
        });
    }

    private final LazyList listFields$1$$anonfun$1(Class c$2) {
        return this.listFields$1(c$2.getSuperclass());
    }

    private final LazyList listFields$1(Class cls) {
        Class c;
        Class clazz = cls;
        if (clazz == null) {
            return LazyListSupport$.MODULE$.empty();
        }
        Class clazz2 = c = clazz;
        Class<Object> clazz3 = Object.class;
        if (!(clazz2 != null ? !clazz2.equals(clazz3) : clazz3 != null)) {
            return LazyListSupport$.MODULE$.empty();
        }
        Class c2 = clazz;
        LazyList lazyList = LazyListSupport$.MODULE$.fromArray(c2.getDeclaredFields());
        Function0 function0 = LazyList$.MODULE$.toDeferrer(() -> this.listFields$1$$anonfun$1(c2));
        return LazyList.Deferrer$.MODULE$.$hash$colon$colon$colon$extension(function0, lazyList);
    }

    private final Option findField$1(Class cls, String fieldName) {
        return Option$.MODULE$.option2Iterable(this.listFields$1(cls).filter((Function1 & Serializable)_$1 -> !_$1.isSynthetic()).find((Function1 & Serializable)f -> {
            String string = NameTransformer$.MODULE$.decode(f.getName());
            String string2 = fieldName;
            return !(string != null ? !string.equals(string2) : string2 != null);
        })).headOption();
    }

    private final boolean isAcceptableField$1(Field field) {
        int modifiers = field.getModifiers();
        return !Modifier.isStatic(modifiers) && !Modifier.isVolatile(modifiers) && !Modifier.isTransient(modifiers) && !field.isSynthetic();
    }

    private final boolean isAcceptableMethod$1(Method method) {
        return !Modifier.isStatic(method.getModifiers()) && this.isNotSyntheticOrBridge$1(method);
    }

    private final Option findGetter$1(Class cls, String propertyName) {
        return this.findMethod$1(cls, propertyName).find((Function1 & Serializable)m -> this.isAcceptableGetter$1((Method)m));
    }

    private final Option findBeanGetter$1(Class cls, String propertyName) {
        return this.findMethod$1(cls, new StringBuilder(3).append("get").append(StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(propertyName))).toString()).find((Function1 & Serializable)m -> this.isAcceptableGetter$1((Method)m));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAcceptableGetter$1(Method m) {
        if (!this.isAcceptableMethod$1(m)) return false;
        if (m.getParameterTypes().length != 0) return false;
        Class<?> clazz = m.getReturnType();
        Class<Void> clazz2 = Void.TYPE;
        if (clazz == null) {
            if (clazz2 == null) return false;
            return true;
        } else if (clazz.equals(clazz2)) return false;
        return true;
    }

    private final Option findSetter$1(Class cls, String propertyName) {
        return this.findMethod$1(cls, new StringBuilder(2).append(propertyName).append("_=").toString()).find((Function1 & Serializable)m -> this.isAcceptableSetter$1((Method)m));
    }

    private final Option findBeanSetter$1(Class cls, String propertyName) {
        return this.findMethod$1(cls, new StringBuilder(3).append("set").append(StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(propertyName))).toString()).find((Function1 & Serializable)m -> this.isAcceptableSetter$1((Method)m));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isAcceptableSetter$1(Method m) {
        if (!this.isAcceptableMethod$1(m)) return false;
        if (m.getParameterTypes().length != 1) return false;
        Class<?> clazz = m.getReturnType();
        Class<Void> clazz2 = Void.TYPE;
        if (clazz != null) {
            if (!clazz.equals(clazz2)) return false;
            return true;
        }
        if (clazz2 == null) return true;
        return false;
    }

    private static final String maybePrivateName$1$$anonfun$2(String definedName$2) {
        return definedName$2;
    }

    private final String maybePrivateName$1(Regex privateRegex$2, Field field) {
        None$ none$;
        String definedName = NameTransformer$.MODULE$.decode(field.getName());
        try {
            none$ = Option$.MODULE$.apply((Object)field.getDeclaringClass().getCanonicalName());
        }
        catch (InternalError e) {
            none$ = None$.MODULE$;
        }
        None$ canonicalName = none$;
        return (String)canonicalName.flatMap((Function1 & Serializable)cn -> {
            List list;
            Option option;
            String PrivateName = cn.replace('.', '$');
            String string = definedName;
            if (string != null && !(option = privateRegex$2.unapplySeq((CharSequence)string)).isEmpty() && (list = (List)option.get()).lengthCompare(2) == 0) {
                String string2 = (String)list.apply(0);
                String string3 = (String)list.apply(1);
                String string4 = PrivateName;
                String string5 = string2;
                if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                    String rest = string3;
                    return Some$.MODULE$.apply((Object)rest);
                }
            }
            return None$.MODULE$;
        }).getOrElse(() -> BeanIntrospector$.maybePrivateName$1$$anonfun$2(definedName));
    }

    private final boolean isScalaCaseObject$1(Class cls) {
        return ClassW$.MODULE$.productClass().isAssignableFrom(cls) && cls.getName().endsWith("$");
    }

    private static final Class $anonfun$4(Class cls$2) {
        return cls$2;
    }

    private final /* synthetic */ IterableOnce $anonfun$3(Seq hierarchy$1, Regex privateRegex$4, Class cls) {
        Object object = Predef$.MODULE$.refArrayOps((Object[])cls.getDeclaredFields());
        Object object2 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.map$extension(object, (Function1 & Serializable)field -> {
            boolean isScalaObject = ClassW$.MODULE$.apply(() -> BeanIntrospector$.$anonfun$4(cls)).isScalaObject() || this.isScalaCaseObject$1(cls);
            String name = this.maybePrivateName$1(privateRegex$4, (Field)field);
            return Tuple3$.MODULE$.apply(field, (Object)BoxesRunTime.boxToBoolean((boolean)isScalaObject), (Object)name);
        }, ClassTag$.MODULE$.apply(Tuple3.class)));
        Object object3 = Predef$.MODULE$.refArrayOps((Object[])ArrayOps$.MODULE$.withFilter$extension(object2, (Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                Field field = (Field)tuple3._1();
                boolean isScalaObject = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
                String name = (String)tuple3._3();
                return !StringOps$.MODULE$.contains$extension(Predef$.MODULE$.augmentString(name), '$');
            }
            throw new MatchError((Object)tuple3);
        }).withFilter((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                Field field = (Field)tuple3._1();
                boolean isScalaObject = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
                String name = (String)tuple3._3();
                return isScalaObject || this.isAcceptableField$1(field);
            }
            throw new MatchError((Object)tuple3);
        }).map((Function1 & Serializable)x$1 -> {
            Tuple3 tuple3 = x$1;
            if (tuple3 != null) {
                Field field = (Field)tuple3._1();
                boolean isScalaObject = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
                String name = (String)tuple3._3();
                Tuple3 $1$ = tuple3;
                Option beanGetter = this.findBeanGetter$1(cls, name);
                Option beanSetter = this.findBeanSetter$1(cls, name);
                return Tuple3$.MODULE$.apply((Object)$1$, (Object)beanGetter, (Object)beanSetter);
            }
            throw new MatchError((Object)tuple3);
        }, ClassTag$.MODULE$.apply(Tuple3.class)));
        return Predef$.MODULE$.wrapRefArray((Object[])ArrayOps$.MODULE$.map$extension(object3, (Function1 & Serializable)x$1 -> {
            Tuple3 tuple3;
            Tuple3 tuple32 = x$1;
            if (tuple32 != null && (tuple3 = (Tuple3)tuple32._1()) != null) {
                Field field = (Field)tuple3._1();
                boolean isScalaObject = BoxesRunTime.unboxToBoolean((Object)tuple3._2());
                String name = (String)tuple3._3();
                Option beanGetter = (Option)tuple32._2();
                Option beanSetter = (Option)tuple32._3();
                return PropertyDescriptor$.MODULE$.apply(this.nameOfField(field, name), (Option<ConstructorParameter>)this.findConstructorParam$1((Class)hierarchy$1.head(), name), (Option<Field>)Some$.MODULE$.apply((Object)field), (Option<Method>)this.findGetter$1(cls, name), (Option<Method>)this.findSetter$1(cls, name), (Option<Method>)beanGetter, (Option<Method>)beanSetter);
            }
            throw new MatchError((Object)tuple32);
        }, ClassTag$.MODULE$.apply(PropertyDescriptor.class)));
    }
}

