/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.scala.deser;

import scala.collection.Map;
import scala.collection.Seq;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.DeserializationFeature;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.jdk.UntypedObjectDeserializer;
import tools.jackson.databind.type.TypeFactory;

public class UntypedScalaObjectDeserializer
extends UntypedObjectDeserializer {
    private ValueDeserializer<Object> _mapDeser;
    private ValueDeserializer<Object> _listDeser;

    public UntypedScalaObjectDeserializer() {
        super(null, null);
    }

    public void resolve(DeserializationContext ctxt) {
        super.resolve(ctxt);
        JavaType anyRef = ctxt.constructType(Object.class);
        JavaType string = ctxt.constructType(String.class);
        TypeFactory tf = ctxt.getTypeFactory();
        this._mapDeser = ctxt.findRootValueDeserializer(ctxt.getConfig().mapAbstractType((JavaType)tf.constructMapLikeType(Map.class, string, anyRef)));
        this._listDeser = ctxt.findRootValueDeserializer(ctxt.getConfig().mapAbstractType((JavaType)tf.constructCollectionLikeType(Seq.class, anyRef)));
    }

    public Object mapArray(JsonParser jp, DeserializationContext ctxt) {
        if (ctxt.isEnabled(DeserializationFeature.USE_JAVA_ARRAY_FOR_JSON_ARRAY)) {
            return this.mapArrayToArray(jp, ctxt);
        }
        return this._listDeser.deserialize(jp, ctxt);
    }

    public Object mapObject(JsonParser jp, DeserializationContext ctxt) {
        return this._mapDeser.deserialize(jp, ctxt);
    }
}

