/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.mrbean;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Random;
import tools.jackson.module.mrbean.bytebuddy.dynamic.DynamicType;
import tools.jackson.module.mrbean.bytebuddy.implementation.MethodDelegation;
import tools.jackson.module.mrbean.bytebuddy.implementation.bind.annotation.Argument;
import tools.jackson.module.mrbean.bytebuddy.implementation.bind.annotation.This;
import tools.jackson.module.mrbean.bytebuddy.matcher.ElementMatchers;

final class ByteBuddyBuilderUtil {
    private ByteBuddyBuilderUtil() {
    }

    static DynamicType.Builder<?> createEqualsAndHashCode(DynamicType.Builder<?> builder) {
        return builder.method(ElementMatchers.named("equals")).intercept(MethodDelegation.to(EqualsTarget.class)).method(ElementMatchers.named("hashCode")).intercept(MethodDelegation.to(HashCodeTarget.class));
    }

    public static class EqualsTarget {
        public static boolean intercept(@This Object self, @Argument(value=0) Object other) {
            Class<?> otherClass;
            if (null == other) {
                return false;
            }
            Class<?> selfClass = self.getClass();
            if (selfClass != (otherClass = other.getClass())) {
                return false;
            }
            try {
                return FieldUtil.toMap(self, selfClass.getDeclaredFields()).equals(FieldUtil.toMap(other, other.getClass().getDeclaredFields()));
            }
            catch (IllegalAccessException e) {
                return false;
            }
        }
    }

    public static class HashCodeTarget {
        public static int intercept(@This Object self) {
            try {
                return FieldUtil.toMap(self, self.getClass().getDeclaredFields()).hashCode();
            }
            catch (IllegalAccessException e) {
                return 31 + new Random().nextInt(10000);
            }
        }
    }

    private static class FieldUtil {
        private FieldUtil() {
        }

        static HashMap<String, Object> toMap(Object o, Field[] fields) throws IllegalAccessException {
            HashMap<String, Object> result = new HashMap<String, Object>();
            for (Field field : fields) {
                field.setAccessible(true);
                result.put(field.getName(), field.get(o));
            }
            return result;
        }
    }
}

