/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.mrbean.bytebuddy.implementation.bytecode.assign.primitive;

import tools.jackson.module.mrbean.bytebuddy.build.HashCodeAndEqualsPlugin;
import tools.jackson.module.mrbean.bytebuddy.description.type.TypeDescription;
import tools.jackson.module.mrbean.bytebuddy.implementation.bytecode.StackManipulation;
import tools.jackson.module.mrbean.bytebuddy.implementation.bytecode.assign.Assigner;
import tools.jackson.module.mrbean.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveBoxingDelegate;
import tools.jackson.module.mrbean.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveUnboxingDelegate;
import tools.jackson.module.mrbean.bytebuddy.implementation.bytecode.assign.primitive.PrimitiveWideningDelegate;
import tools.jackson.module.mrbean.bytebuddy.utility.nullability.MaybeNull;

@HashCodeAndEqualsPlugin.Enhance
public class PrimitiveTypeAwareAssigner
implements Assigner {
    private final Assigner referenceTypeAwareAssigner;

    public PrimitiveTypeAwareAssigner(Assigner referenceTypeAwareAssigner) {
        this.referenceTypeAwareAssigner = referenceTypeAwareAssigner;
    }

    public StackManipulation assign(TypeDescription.Generic source, TypeDescription.Generic target, Assigner.Typing typing) {
        if (source.isPrimitive() && target.isPrimitive()) {
            return PrimitiveWideningDelegate.forPrimitive(source).widenTo(target);
        }
        if (source.isPrimitive()) {
            return PrimitiveBoxingDelegate.forPrimitive(source).assignBoxedTo(target, this.referenceTypeAwareAssigner, typing);
        }
        if (target.isPrimitive()) {
            return PrimitiveUnboxingDelegate.forReferenceType(source).assignUnboxedTo(target, this.referenceTypeAwareAssigner, typing);
        }
        return this.referenceTypeAwareAssigner.assign(source, target, typing);
    }

    public boolean equals(@MaybeNull Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        return this.referenceTypeAwareAssigner.equals(((PrimitiveTypeAwareAssigner)object).referenceTypeAwareAssigner);
    }

    public int hashCode() {
        return this.getClass().hashCode() * 31 + this.referenceTypeAwareAssigner.hashCode();
    }
}

