/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.kotlin;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.module.kotlin.ValueClassUnboxConverter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u0019\u0012\u0010\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J%\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00028\u00002\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a2\u0006\u0002\u0010\u000fR\u0018\u0010\u0004\u001a\f\u0012\u0004\u0012\u00028\u0000\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ltools/jackson/module/kotlin/ValueClassUnboxKeySerializer;", "T", "", "Ltools/jackson/databind/ser/std/StdSerializer;", "converter", "Ltools/jackson/module/kotlin/ValueClassUnboxConverter;", "<init>", "(Ltools/jackson/module/kotlin/ValueClassUnboxConverter;)V", "serialize", "", "value", "gen", "Ltools/jackson/core/JsonGenerator;", "ctxt", "Ltools/jackson/databind/SerializationContext;", "(Ljava/lang/Object;Ltools/jackson/core/JsonGenerator;Ltools/jackson/databind/SerializationContext;)V", "jackson-module-kotlin"})
public final class ValueClassUnboxKeySerializer<T>
extends StdSerializer<T> {
    @NotNull
    private final ValueClassUnboxConverter<T, ?> converter;

    public ValueClassUnboxKeySerializer(@NotNull ValueClassUnboxConverter<T, ?> converter) {
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        super(converter.getValueClass());
        this.converter = converter;
    }

    public void serialize(@NotNull T value, @NotNull JsonGenerator gen, @NotNull SerializationContext ctxt) {
        Intrinsics.checkNotNullParameter(value, (String)"value");
        Intrinsics.checkNotNullParameter((Object)gen, (String)"gen");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        Object unboxed = this.converter.convert(value);
        if (unboxed == null) {
            TypeFactory typeFactory = ctxt.getTypeFactory();
            Intrinsics.checkNotNullExpressionValue((Object)typeFactory, (String)"getTypeFactory(...)");
            JavaType javaType = this.converter.getOutputType(typeFactory);
            ctxt.findNullKeySerializer(javaType, null).serialize(null, gen, ctxt);
            return;
        }
        ctxt.findKeySerializer(unboxed.getClass(), null).serialize(unboxed, gen, ctxt);
    }
}

