/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.kotlin;

import com.fasterxml.jackson.annotation.JsonFormat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.databind.BeanDescription;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.SerializationConfig;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.Serializers;
import tools.jackson.databind.ser.std.StdSerializer;
import tools.jackson.module.kotlin.InternalCommonsKt;
import tools.jackson.module.kotlin.ValueClassStaticJsonKeySerializer;
import tools.jackson.module.kotlin.ValueClassUnboxKeySerializer;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J0\u0010\u0004\u001a\b\u0012\u0002\b\u0003\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016\u00a8\u0006\u000e"}, d2={"Ltools/jackson/module/kotlin/KotlinKeySerializers;", "Ltools/jackson/databind/ser/Serializers$Base;", "<init>", "()V", "findSerializer", "Ltools/jackson/databind/ValueSerializer;", "config", "Ltools/jackson/databind/SerializationConfig;", "type", "Ltools/jackson/databind/JavaType;", "beanDescRef", "Ltools/jackson/databind/BeanDescription$Supplier;", "formatOverrides", "Lcom/fasterxml/jackson/annotation/JsonFormat$Value;", "jackson-module-kotlin"})
public final class KotlinKeySerializers
extends Serializers.Base {
    @Nullable
    public ValueSerializer<?> findSerializer(@NotNull SerializationConfig config, @NotNull JavaType type, @NotNull BeanDescription.Supplier beanDescRef, @Nullable JsonFormat.Value formatOverrides) {
        ValueSerializer valueSerializer;
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        Intrinsics.checkNotNullParameter((Object)type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)beanDescRef, (String)"beanDescRef");
        Class clazz = type.getRawClass();
        Intrinsics.checkNotNullExpressionValue((Object)clazz, (String)"getRawClass(...)");
        if (InternalCommonsKt.isUnboxableValueClass(clazz)) {
            Class clazz2 = type.getRawClass();
            Intrinsics.checkNotNullExpressionValue((Object)clazz2, (String)"getRawClass(...)");
            StdSerializer stdSerializer = ValueClassStaticJsonKeySerializer.Companion.createOrNull(clazz2);
            if (stdSerializer == null) {
                stdSerializer = ValueClassUnboxKeySerializer.INSTANCE;
            }
            valueSerializer = (ValueSerializer)stdSerializer;
        } else {
            valueSerializer = null;
        }
        return valueSerializer;
    }
}

