/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.kotlin;

import java.lang.reflect.Member;
import java.lang.reflect.Method;
import kotlin.Metadata;
import kotlin.jvm.JvmClassMappingKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.reflect.KClass;
import kotlin.reflect.KFunction;
import kotlin.reflect.full.KClasses;
import kotlin.reflect.jvm.ReflectJvmMapping;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.KeyDeserializer;
import tools.jackson.databind.exc.InvalidDefinitionException;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.module.kotlin.ReflectionCache;
import tools.jackson.module.kotlin.ValueClassBoxConverter;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000<\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u0015*\u0004\b\u0000\u0010\u0001*\b\b\u0001\u0010\u0002*\u00020\u00032\u00020\u0004:\u0001\u0015B#\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0012\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\b\u00a2\u0006\u0004\b\t\u0010\nJ\u0010\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001a\u0010\u0011\u001a\u00020\u00032\b\u0010\u0012\u001a\u0004\u0018\u00010\u000e2\u0006\u0010\u0013\u001a\u00020\u0014H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0007\u001a\u000e\u0012\u0004\u0012\u00028\u0000\u0012\u0004\u0012\u00028\u00010\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u000b\u001a\u0006\u0012\u0002\b\u00030\fX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Ltools/jackson/module/kotlin/ValueClassKeyDeserializer;", "S", "D", "", "Ltools/jackson/databind/KeyDeserializer;", "creator", "Ljava/lang/reflect/Method;", "converter", "Ltools/jackson/module/kotlin/ValueClassBoxConverter;", "<init>", "(Ljava/lang/reflect/Method;Ltools/jackson/module/kotlin/ValueClassBoxConverter;)V", "unboxedClass", "Ljava/lang/Class;", "errorMessage", "", "boxedType", "Ltools/jackson/databind/JavaType;", "deserializeKey", "key", "ctxt", "Ltools/jackson/databind/DeserializationContext;", "Companion", "jackson-module-kotlin"})
public final class ValueClassKeyDeserializer<S, D>
extends KeyDeserializer {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final Method creator;
    @NotNull
    private final ValueClassBoxConverter<S, D> converter;
    @NotNull
    private final Class<?> unboxedClass;

    public ValueClassKeyDeserializer(@NotNull Method creator, @NotNull ValueClassBoxConverter<S, D> converter) {
        Intrinsics.checkNotNullParameter((Object)creator, (String)"creator");
        Intrinsics.checkNotNullParameter(converter, (String)"converter");
        this.creator = creator;
        this.converter = converter;
        Class<?> clazz = this.creator.getParameterTypes()[0];
        Intrinsics.checkNotNullExpressionValue(clazz, (String)"get(...)");
        this.unboxedClass = clazz;
        ClassUtil.checkAndFixAccess((Member)this.creator, (boolean)false);
    }

    private final String errorMessage(JavaType boxedType) {
        return "Could not find (Map) Key deserializer for types wrapped in " + boxedType;
    }

    @NotNull
    public Object deserializeKey(@Nullable String key, @NotNull DeserializationContext ctxt) {
        D d;
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        JavaType unboxedJavaType = ctxt.constructType(this.unboxedClass);
        try {
            Object value = ctxt.findKeyDeserializer(unboxedJavaType, null).deserializeKey(key, ctxt);
            Object[] objectArray = new Object[]{value};
            d = this.converter.convert(this.creator.invoke(null, objectArray));
        }
        catch (InvalidDefinitionException e) {
            JsonParser jsonParser = ctxt.getParser();
            JavaType javaType = ctxt.constructType(JvmClassMappingKt.getJavaClass(this.converter.getBoxedClass()));
            Intrinsics.checkNotNullExpressionValue((Object)javaType, (String)"constructType(...)");
            throw DatabindException.from((JsonParser)jsonParser, (String)this.errorMessage(javaType), (Throwable)e);
        }
        return d;
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J$\u0010\u0004\u001a\f\u0012\u0002\b\u0003\u0012\u0002\b\u0003\u0018\u00010\u00052\n\u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00072\u0006\u0010\b\u001a\u00020\t\u00a8\u0006\n"}, d2={"Ltools/jackson/module/kotlin/ValueClassKeyDeserializer$Companion;", "", "<init>", "()V", "createOrNull", "Ltools/jackson/module/kotlin/ValueClassKeyDeserializer;", "boxedClass", "Lkotlin/reflect/KClass;", "cache", "Ltools/jackson/module/kotlin/ReflectionCache;", "jackson-module-kotlin"})
    public static final class Companion {
        private Companion() {
        }

        @Nullable
        public final ValueClassKeyDeserializer<?, ?> createOrNull(@NotNull KClass<?> boxedClass, @NotNull ReflectionCache cache) {
            Intrinsics.checkNotNullParameter(boxedClass, (String)"boxedClass");
            Intrinsics.checkNotNullParameter((Object)cache, (String)"cache");
            Object object = KClasses.getPrimaryConstructor(boxedClass);
            if (object == null || (object = ReflectJvmMapping.getJavaMethod((KFunction)object)) == null) {
                return null;
            }
            Object creator = object;
            Class<?> clazz = ((Method)creator).getReturnType();
            Intrinsics.checkNotNullExpressionValue(clazz, (String)"getReturnType(...)");
            ValueClassBoxConverter<?, ?> converter = cache.getValueClassBoxConverter(clazz, boxedClass);
            return new ValueClassKeyDeserializer((Method)creator, converter);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

