/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.kotlin;

import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.BeanProperty;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.module.kotlin.KotlinObjectSingletonDeserializerKt;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\b\u0000\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0001\u00a2\u0006\u0002\u0010\u0005J \u0010\u0006\u001a\u0006\u0012\u0002\b\u00030\u00012\b\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\u0010\t\u001a\u0004\u0018\u00010\nH\u0016J\u0018\u0010\u000b\u001a\u00020\u00022\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0012\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0007\u001a\u0004\u0018\u00010\bH\u0016R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Ltools/jackson/module/kotlin/KotlinObjectSingletonDeserializer;", "Ltools/jackson/databind/ValueDeserializer;", "", "singletonInstance", "defaultDeserializer", "(Ljava/lang/Object;Ltools/jackson/databind/ValueDeserializer;)V", "createContextual", "ctxt", "Ltools/jackson/databind/DeserializationContext;", "property", "Ltools/jackson/databind/BeanProperty;", "deserialize", "p", "Ltools/jackson/core/JsonParser;", "resolve", "", "jackson-module-kotlin"})
public final class KotlinObjectSingletonDeserializer
extends ValueDeserializer<Object> {
    @NotNull
    private final Object singletonInstance;
    @NotNull
    private final ValueDeserializer<?> defaultDeserializer;

    public KotlinObjectSingletonDeserializer(@NotNull Object singletonInstance, @NotNull ValueDeserializer<?> defaultDeserializer) {
        Intrinsics.checkNotNullParameter((Object)singletonInstance, (String)"singletonInstance");
        Intrinsics.checkNotNullParameter(defaultDeserializer, (String)"defaultDeserializer");
        this.singletonInstance = singletonInstance;
        this.defaultDeserializer = defaultDeserializer;
    }

    public void resolve(@Nullable DeserializationContext ctxt) {
        this.defaultDeserializer.resolve(ctxt);
    }

    @NotNull
    public ValueDeserializer<?> createContextual(@Nullable DeserializationContext ctxt, @Nullable BeanProperty property) {
        ValueDeserializer valueDeserializer2 = this.defaultDeserializer.createContextual(ctxt, property);
        Intrinsics.checkNotNullExpressionValue((Object)valueDeserializer2, (String)"createContextual(...)");
        return KotlinObjectSingletonDeserializerKt.asSingletonDeserializer(valueDeserializer2, this.singletonInstance);
    }

    @NotNull
    public Object deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        this.defaultDeserializer.deserialize(p, ctxt);
        return this.singletonInstance;
    }
}

