/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.kotlin;

import java.util.Iterator;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import org.jetbrains.annotations.NotNull;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.JsonNode;
import tools.jackson.databind.deser.std.StdDeserializer;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u0018\u0010\u0005\u001a\u00020\u00022\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tH\u0016\u00a8\u0006\n"}, d2={"Ltools/jackson/module/kotlin/RegexDeserializer;", "Ltools/jackson/databind/deser/std/StdDeserializer;", "Lkotlin/text/Regex;", "<init>", "()V", "deserialize", "p", "Ltools/jackson/core/JsonParser;", "ctxt", "Ltools/jackson/databind/DeserializationContext;", "jackson-module-kotlin"})
public final class RegexDeserializer
extends StdDeserializer<Regex> {
    @NotNull
    public static final RegexDeserializer INSTANCE = new RegexDeserializer();

    private RegexDeserializer() {
        super(Regex.class);
    }

    @NotNull
    public Regex deserialize(@NotNull JsonParser p, @NotNull DeserializationContext ctxt) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        Intrinsics.checkNotNullParameter((Object)ctxt, (String)"ctxt");
        JsonNode node = ctxt.readTree(p);
        if (node.isString()) {
            String string = node.asString();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
            return new Regex(string);
        }
        if (node.isObject()) {
            Set set;
            String pattern = node.get("pattern").asString();
            if (node.has("options")) {
                JsonNode optionsNode = node.get("options");
                if (!optionsNode.isArray()) {
                    throw new IllegalStateException("Expected an array of strings for RegexOptions, but type was " + node.getNodeType());
                }
                Iterator iterator = optionsNode.iterator();
                Intrinsics.checkNotNullExpressionValue((Object)iterator, (String)"iterator(...)");
                set = SequencesKt.toSet((Sequence)SequencesKt.map((Sequence)SequencesKt.asSequence((Iterator)iterator), RegexDeserializer::deserialize$lambda$0));
            } else {
                set = SetsKt.emptySet();
            }
            Set options = set;
            Intrinsics.checkNotNull((Object)pattern);
            return new Regex(pattern, options);
        }
        throw new IllegalStateException("Expected a string or an object to deserialize a Regex, but type was " + node.getNodeType());
    }

    private static final RegexOption deserialize$lambda$0(JsonNode it) {
        String string = it.asString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"asString(...)");
        return RegexOption.valueOf((String)string);
    }
}

