/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.jaxb.deser;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdScalarDeserializer;

public class DataHandlerDeserializer
extends StdScalarDeserializer<DataHandler> {
    public DataHandlerDeserializer() {
        super(DataHandler.class);
    }

    public DataHandler deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        final byte[] value = p.getBinaryValue();
        return new DataHandler(new DataSource(){

            public InputStream getInputStream() throws IOException {
                return new ByteArrayInputStream(value);
            }

            public OutputStream getOutputStream() throws IOException {
                throw new IOException();
            }

            public String getContentType() {
                return "application/octet-stream";
            }

            public String getName() {
                return "json-binary-data";
            }
        });
    }
}

