/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.jakarta.xmlbind;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import com.fasterxml.jackson.annotation.ObjectIdGenerators;
import com.fasterxml.jackson.annotation.SimpleObjectIdResolver;
import jakarta.xml.bind.JAXBElement;
import jakarta.xml.bind.annotation.XmlAccessOrder;
import jakarta.xml.bind.annotation.XmlAccessType;
import jakarta.xml.bind.annotation.XmlAccessorOrder;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlElementRef;
import jakarta.xml.bind.annotation.XmlElementRefs;
import jakarta.xml.bind.annotation.XmlElementWrapper;
import jakarta.xml.bind.annotation.XmlElements;
import jakarta.xml.bind.annotation.XmlEnum;
import jakarta.xml.bind.annotation.XmlEnumValue;
import jakarta.xml.bind.annotation.XmlID;
import jakarta.xml.bind.annotation.XmlIDREF;
import jakarta.xml.bind.annotation.XmlRootElement;
import jakarta.xml.bind.annotation.XmlSeeAlso;
import jakarta.xml.bind.annotation.XmlTransient;
import jakarta.xml.bind.annotation.XmlType;
import jakarta.xml.bind.annotation.XmlValue;
import jakarta.xml.bind.annotation.adapters.XmlAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import jakarta.xml.bind.annotation.adapters.XmlJavaTypeAdapters;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Member;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import tools.jackson.core.JsonParser;
import tools.jackson.core.Version;
import tools.jackson.core.Versioned;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.DatabindException;
import tools.jackson.databind.JavaType;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.cfg.MapperConfig;
import tools.jackson.databind.introspect.Annotated;
import tools.jackson.databind.introspect.AnnotatedClass;
import tools.jackson.databind.introspect.AnnotatedField;
import tools.jackson.databind.introspect.AnnotatedMember;
import tools.jackson.databind.introspect.AnnotatedMethod;
import tools.jackson.databind.introspect.AnnotatedParameter;
import tools.jackson.databind.introspect.ObjectIdInfo;
import tools.jackson.databind.introspect.VisibilityChecker;
import tools.jackson.databind.jsontype.NamedType;
import tools.jackson.databind.type.TypeFactory;
import tools.jackson.databind.util.ClassUtil;
import tools.jackson.databind.util.Converter;
import tools.jackson.module.jakarta.xmlbind.AdapterConverter;
import tools.jackson.module.jakarta.xmlbind.PackageVersion;
import tools.jackson.module.jakarta.xmlbind.deser.DataHandlerDeserializer;
import tools.jackson.module.jakarta.xmlbind.ser.DataHandlerSerializer;

public class JakartaXmlBindAnnotationIntrospector
extends AnnotationIntrospector
implements AnnotationIntrospector.XmlExtensions,
Versioned {
    private static final long serialVersionUID = -1L;
    protected static final String DEFAULT_NAME_FOR_XML_VALUE = "value";
    protected static final boolean DEFAULT_IGNORE_XMLIDREF = false;
    protected static final String MARKER_FOR_DEFAULT = "##default";
    protected static final JsonFormat.Value FORMAT_STRING = new JsonFormat.Value().withShape(JsonFormat.Shape.STRING);
    protected static final JsonFormat.Value FORMAT_INT = new JsonFormat.Value().withShape(JsonFormat.Shape.NUMBER_INT);
    protected final String _jaxbPackageName;
    protected final ValueSerializer<?> _dataHandlerSerializer;
    protected final ValueDeserializer<?> _dataHandlerDeserializer;
    protected final boolean _ignoreXmlIDREF;
    protected String _xmlValueName = "value";
    protected JsonInclude.Include _nonNillableInclusion = null;

    public JakartaXmlBindAnnotationIntrospector() {
        this(false);
    }

    public JakartaXmlBindAnnotationIntrospector(boolean ignoreXmlIDREF) {
        this._ignoreXmlIDREF = ignoreXmlIDREF;
        this._jaxbPackageName = XmlElement.class.getPackage().getName();
        ValueSerializer dataHandlerSerializer = null;
        ValueDeserializer dataHandlerDeserializer = null;
        try {
            dataHandlerSerializer = (ValueSerializer)ClassUtil.createInstance(DataHandlerSerializer.class, (boolean)false);
            dataHandlerDeserializer = (ValueDeserializer)ClassUtil.createInstance(DataHandlerDeserializer.class, (boolean)false);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this._dataHandlerSerializer = dataHandlerSerializer;
        this._dataHandlerDeserializer = dataHandlerDeserializer;
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public void setNameUsedForXmlValue(String name) {
        this._xmlValueName = name;
    }

    public String getNameUsedForXmlValue() {
        return this._xmlValueName;
    }

    public JakartaXmlBindAnnotationIntrospector setNonNillableInclusion(JsonInclude.Include incl) {
        this._nonNillableInclusion = incl;
        return this;
    }

    public JsonInclude.Include getNonNillableInclusion() {
        return this._nonNillableInclusion;
    }

    public String findNamespace(MapperConfig<?> config, Annotated ann) {
        String ns = null;
        if (ann instanceof AnnotatedClass) {
            XmlRootElement elem = this.findRootElementAnnotation((AnnotatedClass)ann);
            if (elem != null) {
                ns = elem.namespace();
            }
        } else {
            XmlAttribute attr;
            XmlElement elem = this.findAnnotation(XmlElement.class, ann, false, false, false);
            if (elem != null) {
                ns = elem.namespace();
            }
            if ((ns == null || MARKER_FOR_DEFAULT.equals(ns)) && (attr = this.findAnnotation(XmlAttribute.class, ann, false, false, false)) != null) {
                ns = attr.namespace();
            }
        }
        if (MARKER_FOR_DEFAULT.equals(ns)) {
            ns = null;
        }
        return ns;
    }

    public Boolean isOutputAsAttribute(MapperConfig<?> config, Annotated ann) {
        XmlAttribute attr = this.findAnnotation(XmlAttribute.class, ann, false, false, false);
        if (attr != null) {
            return Boolean.TRUE;
        }
        XmlElement elem = this.findAnnotation(XmlElement.class, ann, false, false, false);
        if (elem != null) {
            return Boolean.FALSE;
        }
        return null;
    }

    public Boolean isOutputAsText(MapperConfig<?> config, Annotated ann) {
        XmlValue attr = this.findAnnotation(XmlValue.class, ann, false, false, false);
        if (attr != null) {
            return Boolean.TRUE;
        }
        return null;
    }

    public Boolean isOutputAsCData(MapperConfig<?> config, Annotated ann) {
        return null;
    }

    public ObjectIdInfo findObjectIdInfo(MapperConfig<?> config, Annotated ann) {
        XmlID idProp;
        if (!(ann instanceof AnnotatedClass)) {
            return null;
        }
        AnnotatedClass ac = (AnnotatedClass)ann;
        PropertyName idPropName = null;
        block4: for (AnnotatedMethod m : ac.memberMethods()) {
            idProp = (XmlID)m.getAnnotation(XmlID.class);
            if (idProp == null) continue;
            switch (m.getParameterCount()) {
                case 0: {
                    idPropName = this.findJaxbPropertyName((Annotated)m, m.getRawType(), this._okNameForGetter(m));
                    break block4;
                }
                case 1: {
                    idPropName = this.findJaxbPropertyName((Annotated)m, m.getRawType(), this._okNameForMutator(m));
                    break block4;
                }
                default: {
                    continue block4;
                }
            }
        }
        if (idPropName == null) {
            for (AnnotatedField f : ac.fields()) {
                idProp = (XmlID)f.getAnnotation(XmlID.class);
                if (idProp == null) continue;
                idPropName = this.findJaxbPropertyName((Annotated)f, f.getRawType(), f.getName());
                break;
            }
        }
        if (idPropName != null) {
            Class<Object> scope = Object.class;
            return new ObjectIdInfo(idPropName, scope, ObjectIdGenerators.PropertyGenerator.class, SimpleObjectIdResolver.class);
        }
        return null;
    }

    public ObjectIdInfo findObjectReferenceInfo(MapperConfig<?> config, Annotated ann, ObjectIdInfo base) {
        XmlIDREF idref;
        if (!this._ignoreXmlIDREF && (idref = (XmlIDREF)ann.getAnnotation(XmlIDREF.class)) != null) {
            if (base == null) {
                base = ObjectIdInfo.empty();
            }
            base = base.withAlwaysAsId(true);
        }
        return base;
    }

    public PropertyName findRootName(MapperConfig<?> config, AnnotatedClass ac) {
        XmlRootElement elem = this.findRootElementAnnotation(ac);
        if (elem != null) {
            return JakartaXmlBindAnnotationIntrospector._combineNames(elem.name(), elem.namespace(), "");
        }
        return null;
    }

    public Boolean isIgnorableType(MapperConfig<?> config, AnnotatedClass ac) {
        return null;
    }

    public boolean hasIgnoreMarker(MapperConfig<?> config, AnnotatedMember m) {
        return m.getAnnotation(XmlTransient.class) != null;
    }

    public Boolean hasRequiredMarker(MapperConfig<?> config, AnnotatedMember m) {
        XmlAttribute attr = (XmlAttribute)m.getAnnotation(XmlAttribute.class);
        if (attr != null) {
            return attr.required();
        }
        XmlElement elem = (XmlElement)m.getAnnotation(XmlElement.class);
        if (elem != null) {
            return elem.required();
        }
        return null;
    }

    public PropertyName findWrapperName(MapperConfig<?> config, Annotated ann) {
        XmlElementWrapper w = this.findAnnotation(XmlElementWrapper.class, ann, false, false, false);
        if (w != null) {
            PropertyName name = JakartaXmlBindAnnotationIntrospector._combineNames(w.name(), w.namespace(), "");
            if (!name.hasSimpleName()) {
                AnnotatedMethod am;
                String str;
                if (ann instanceof AnnotatedMethod && (str = (am = (AnnotatedMethod)ann).getParameterCount() == 0 ? this._okNameForGetter(am) : this._okNameForMutator(am)) != null) {
                    return name.withSimpleName(str);
                }
                return name.withSimpleName(ann.getName());
            }
            return name;
        }
        return null;
    }

    public String findImplicitPropertyName(MapperConfig<?> config, AnnotatedMember m) {
        XmlValue valueInfo = (XmlValue)m.getAnnotation(XmlValue.class);
        if (valueInfo != null) {
            return this._xmlValueName;
        }
        return null;
    }

    public JsonFormat.Value findFormat(MapperConfig<?> config, Annotated m) {
        XmlEnum ann;
        if (m instanceof AnnotatedClass && (ann = (XmlEnum)m.getAnnotation(XmlEnum.class)) != null) {
            Class type = ann.value();
            if (type == String.class || type.isEnum()) {
                return FORMAT_STRING;
            }
            if (Number.class.isAssignableFrom(type)) {
                return FORMAT_INT;
            }
        }
        return null;
    }

    public VisibilityChecker findAutoDetectVisibility(MapperConfig<?> config, AnnotatedClass ac, VisibilityChecker checker) {
        XmlAccessType at = this.findAccessType((Annotated)ac);
        if (at == null) {
            return checker;
        }
        switch (at) {
            case FIELD: {
                return checker.withFieldVisibility(JsonAutoDetect.Visibility.ANY).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            case NONE: {
                return checker.withFieldVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.NONE).withGetterVisibility(JsonAutoDetect.Visibility.NONE).withIsGetterVisibility(JsonAutoDetect.Visibility.NONE);
            }
            case PROPERTY: {
                return checker.withFieldVisibility(JsonAutoDetect.Visibility.NONE).withSetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY);
            }
            case PUBLIC_MEMBER: {
                return checker.withFieldVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withSetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY).withIsGetterVisibility(JsonAutoDetect.Visibility.PUBLIC_ONLY);
            }
        }
        return checker;
    }

    protected XmlAccessType findAccessType(Annotated ac) {
        XmlAccessorType at = this.findAnnotation(XmlAccessorType.class, ac, true, true, true);
        return at == null ? null : at.value();
    }

    public JsonTypeInfo.Value findPolymorphicTypeInfo(MapperConfig<?> config, Annotated ann) {
        XmlElementRefs elemRefs;
        XmlElements elems = this.findAnnotation(XmlElements.class, ann, false, false, false);
        if (elems == null && (elemRefs = this.findAnnotation(XmlElementRefs.class, ann, false, false, false)) == null) {
            return null;
        }
        return JsonTypeInfo.Value.construct((JsonTypeInfo.Id)JsonTypeInfo.Id.NAME, (JsonTypeInfo.As)JsonTypeInfo.As.WRAPPER_OBJECT, (String)"", null, (boolean)false, null);
    }

    public List<NamedType> findSubtypes(MapperConfig<?> config, Annotated a) {
        XmlSeeAlso ann;
        XmlElements elems = this.findAnnotation(XmlElements.class, a, false, false, false);
        ArrayList<Object> result = null;
        if (elems != null) {
            result = new ArrayList<NamedType>();
            for (XmlElement elem : elems.value()) {
                String name = elem.name();
                if (MARKER_FOR_DEFAULT.equals(name)) {
                    name = null;
                }
                result.add(new NamedType(elem.type(), name));
            }
        } else {
            XmlElementRefs elemRefs = this.findAnnotation(XmlElementRefs.class, a, false, false, false);
            if (elemRefs != null) {
                result = new ArrayList();
                for (XmlElementRef elemRef : elemRefs.value()) {
                    XmlRootElement rootElement;
                    Class refType = elemRef.type();
                    if (JAXBElement.class.isAssignableFrom(refType)) continue;
                    String name = elemRef.name();
                    if ((name == null || MARKER_FOR_DEFAULT.equals(name)) && (rootElement = refType.getAnnotation(XmlRootElement.class)) != null) {
                        name = rootElement.name();
                    }
                    if (name == null || MARKER_FOR_DEFAULT.equals(name)) {
                        name = this._decapitalize(refType.getSimpleName());
                    }
                    result.add(new NamedType(refType, name));
                }
            }
        }
        if ((ann = (XmlSeeAlso)a.getAnnotation(XmlSeeAlso.class)) != null) {
            if (result == null) {
                result = new ArrayList();
            }
            for (Class cls : ann.value()) {
                result.add(new NamedType(cls));
            }
        }
        return result;
    }

    public String findTypeName(MapperConfig<?> config, AnnotatedClass ac) {
        String name;
        XmlType type = this.findAnnotation(XmlType.class, (Annotated)ac, false, false, false);
        if (type != null && !MARKER_FOR_DEFAULT.equals(name = type.name())) {
            return name;
        }
        return null;
    }

    public ValueSerializer<?> findSerializer(MapperConfig<?> config, Annotated am) {
        Class<?> type = this._rawSerializationType(am);
        if (type != null && this._dataHandlerSerializer != null && this.isDataHandler(type)) {
            return this._dataHandlerSerializer;
        }
        return null;
    }

    private boolean isDataHandler(Class<?> type) {
        return type != null && Object.class != type && ("jakarta.activation.DataHandler".equals(type.getName()) || this.isDataHandler(type.getSuperclass()));
    }

    public Object findContentSerializer(MapperConfig<?> config, Annotated a) {
        return null;
    }

    public JsonInclude.Value findPropertyInclusion(MapperConfig<?> config, Annotated a) {
        JsonInclude.Include incl = this._serializationInclusion(a, null);
        if (incl == null) {
            return JsonInclude.Value.empty();
        }
        return JsonInclude.Value.construct((JsonInclude.Include)incl, null);
    }

    JsonInclude.Include _serializationInclusion(Annotated a, JsonInclude.Include defValue) {
        XmlElement e;
        XmlElementWrapper w = (XmlElementWrapper)a.getAnnotation(XmlElementWrapper.class);
        if (w != null) {
            if (w.nillable()) {
                return JsonInclude.Include.ALWAYS;
            }
            if (this._nonNillableInclusion != null) {
                return this._nonNillableInclusion;
            }
        }
        if ((e = (XmlElement)a.getAnnotation(XmlElement.class)) != null) {
            if (e.nillable()) {
                return JsonInclude.Include.ALWAYS;
            }
            if (this._nonNillableInclusion != null) {
                return this._nonNillableInclusion;
            }
        }
        return defValue;
    }

    public JavaType refineSerializationType(MapperConfig<?> config, Annotated a, JavaType baseType) {
        Class<?> serClass = this._getTypeFromXmlElement(a);
        if (serClass == null) {
            return baseType;
        }
        TypeFactory tf = config.getTypeFactory();
        if (baseType.getContentType() == null) {
            if (!serClass.isAssignableFrom(baseType.getRawClass())) {
                return baseType;
            }
            if (baseType.hasRawClass(serClass)) {
                return baseType.withStaticTyping();
            }
            try {
                return tf.constructGeneralizedType(baseType, serClass);
            }
            catch (IllegalArgumentException iae) {
                throw DatabindException.from((JsonParser)null, (String)String.format("Failed to widen type %s with annotation (value %s), from '%s': %s", baseType, serClass.getName(), a.getName(), iae.getMessage()), (Throwable)iae);
            }
        }
        JavaType contentType = baseType.getContentType();
        if (contentType != null) {
            if (!serClass.isAssignableFrom(contentType.getRawClass())) {
                return baseType;
            }
            if (contentType.hasRawClass(serClass)) {
                contentType = contentType.withStaticTyping();
            } else {
                try {
                    contentType = tf.constructGeneralizedType(contentType, serClass);
                }
                catch (IllegalArgumentException iae) {
                    throw DatabindException.from((JsonParser)null, (String)String.format("Failed to widen value type of %s with concrete-type annotation (value %s), from '%s': %s", baseType, serClass.getName(), a.getName(), iae.getMessage()), (Throwable)iae);
                }
            }
            return baseType.withContentType(contentType);
        }
        return baseType;
    }

    public String[] findSerializationPropertyOrder(MapperConfig<?> config, AnnotatedClass ac) {
        XmlType type = this.findAnnotation(XmlType.class, (Annotated)ac, true, true, true);
        if (type == null) {
            return null;
        }
        String[] order = type.propOrder();
        if (order == null || order.length == 0) {
            return null;
        }
        return order;
    }

    public Boolean findSerializationSortAlphabetically(MapperConfig<?> config, Annotated ann) {
        return this._findAlpha(ann);
    }

    private final Boolean _findAlpha(Annotated ann) {
        XmlAccessorOrder order = this.findAnnotation(XmlAccessorOrder.class, ann, true, true, true);
        return order == null ? null : Boolean.valueOf(order.value() == XmlAccessOrder.ALPHABETICAL);
    }

    public Object findSerializationConverter(MapperConfig<?> config, Annotated a) {
        Class<?> serType = this._rawSerializationType(a);
        XmlAdapter<Object, Object> adapter = this.findAdapter(config, a, true, serType);
        if (adapter != null) {
            return this._converter(config, adapter, true);
        }
        return null;
    }

    public Object findSerializationContentConverter(MapperConfig<?> config, AnnotatedMember a) {
        XmlAdapter<?, ?> adapter;
        Class<?> serType = this._rawSerializationType((Annotated)a);
        if (this.isContainerType(serType) && (adapter = this._findContentAdapter(config, (Annotated)a, true)) != null) {
            return this._converter(config, adapter, true);
        }
        return null;
    }

    public PropertyName findNameForSerialization(MapperConfig<?> config, Annotated a) {
        if (a instanceof AnnotatedMethod) {
            AnnotatedMethod am = (AnnotatedMethod)a;
            return this.isVisible(am) ? this.findJaxbPropertyName((Annotated)am, am.getRawType(), this._okNameForGetter(am)) : null;
        }
        if (a instanceof AnnotatedField) {
            AnnotatedField af = (AnnotatedField)a;
            return this.isVisible(af) ? this.findJaxbPropertyName((Annotated)af, af.getRawType(), null) : null;
        }
        return null;
    }

    public String[] findEnumValues(MapperConfig<?> config, AnnotatedClass annotatedClass, Enum<?>[] enumValues, String[] names) {
        LinkedHashMap<String, String> enumToPropertyMap = new LinkedHashMap<String, String>();
        for (AnnotatedField field : annotatedClass.fields()) {
            String propValue;
            XmlEnumValue property = (XmlEnumValue)field.getAnnotation(XmlEnumValue.class);
            if (property == null || (propValue = property.value()) == null || propValue.isEmpty()) continue;
            enumToPropertyMap.put(field.getName(), propValue);
        }
        int end = enumValues.length;
        for (int i = 0; i < end; ++i) {
            String defName = enumValues[i].name();
            String explValue = (String)enumToPropertyMap.get(defName);
            if (explValue == null) continue;
            names[i] = explValue;
        }
        return names;
    }

    public Object findDeserializer(MapperConfig<?> config, Annotated am) {
        Class<?> type = this._rawDeserializationType(am);
        if (type != null && this._dataHandlerDeserializer != null && this.isDataHandler(type)) {
            return this._dataHandlerDeserializer;
        }
        return null;
    }

    public Object findKeyDeserializer(MapperConfig<?> config, Annotated am) {
        return null;
    }

    public Object findContentDeserializer(MapperConfig<?> config, Annotated a) {
        return null;
    }

    protected Class<?> _doFindDeserializationType(Annotated a, JavaType baseType) {
        Class type;
        if (a.hasAnnotation(XmlJavaTypeAdapter.class)) {
            return null;
        }
        XmlElement annotation = this.findAnnotation(XmlElement.class, a, false, false, false);
        if (annotation != null && (type = annotation.type()) != XmlElement.DEFAULT.class) {
            return type;
        }
        return null;
    }

    public JavaType refineDeserializationType(MapperConfig<?> config, Annotated a, JavaType baseType) {
        Class<?> deserClass = this._getTypeFromXmlElement(a);
        if (deserClass == null) {
            return baseType;
        }
        TypeFactory tf = config.getTypeFactory();
        if (baseType.getContentType() == null) {
            if (baseType.hasRawClass(deserClass)) {
                return baseType;
            }
            if (!baseType.getRawClass().isAssignableFrom(deserClass)) {
                return baseType;
            }
            try {
                return tf.constructSpecializedType(baseType, deserClass);
            }
            catch (IllegalArgumentException iae) {
                throw DatabindException.from((JsonParser)null, (String)String.format("Failed to narrow type %s with annotation (value %s), from '%s': %s", baseType, deserClass.getName(), a.getName(), iae.getMessage()), (Throwable)iae);
            }
        }
        JavaType contentType = baseType.getContentType();
        if (contentType != null) {
            if (!contentType.getRawClass().isAssignableFrom(deserClass)) {
                return baseType;
            }
            try {
                contentType = tf.constructSpecializedType(contentType, deserClass);
                return baseType.withContentType(contentType);
            }
            catch (IllegalArgumentException iae) {
                throw DatabindException.from((JsonParser)null, (String)String.format("Failed to narrow type %s with annotation (value %s), from '%s': %s", baseType, deserClass.getName(), a.getName(), iae.getMessage()), (Throwable)iae);
            }
        }
        return baseType;
    }

    public PropertyName findNameForDeserialization(MapperConfig<?> config, Annotated a) {
        if (a instanceof AnnotatedMethod) {
            AnnotatedMethod am = (AnnotatedMethod)a;
            if (!this.isVisible(am)) {
                return null;
            }
            Class rawType = am.getRawParameterType(0);
            return this.findJaxbPropertyName((Annotated)am, rawType, this._okNameForMutator(am));
        }
        if (a instanceof AnnotatedField) {
            AnnotatedField af = (AnnotatedField)a;
            return this.isVisible(af) ? this.findJaxbPropertyName((Annotated)af, af.getRawType(), null) : null;
        }
        return null;
    }

    public Object findDeserializationConverter(MapperConfig<?> config, Annotated a) {
        Class<?> deserType = this._rawDeserializationType(a);
        XmlAdapter<Object, Object> adapter = this.findAdapter(config, a, true, deserType);
        if (adapter != null) {
            return this._converter(config, adapter, false);
        }
        return null;
    }

    public Object findDeserializationContentConverter(MapperConfig<?> config, AnnotatedMember a) {
        XmlAdapter<?, ?> adapter;
        Class<?> deserType = this._rawDeserializationType((Annotated)a);
        if (this.isContainerType(deserType) && (adapter = this._findContentAdapter(config, (Annotated)a, false)) != null) {
            return this._converter(config, adapter, false);
        }
        return null;
    }

    private boolean isVisible(AnnotatedField f) {
        for (Annotation annotation : f.getAnnotated().getDeclaredAnnotations()) {
            if (!this.isJAXBAnnotation(annotation)) continue;
            return true;
        }
        XmlAccessType accessType = XmlAccessType.PUBLIC_MEMBER;
        XmlAccessorType at = this.findAnnotation(XmlAccessorType.class, (Annotated)f, true, true, true);
        if (at != null) {
            accessType = at.value();
        }
        if (accessType == XmlAccessType.FIELD) {
            return true;
        }
        if (accessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(f.getAnnotated().getModifiers());
        }
        return false;
    }

    private boolean isVisible(AnnotatedMethod m) {
        for (Annotation annotation : m.getAnnotated().getDeclaredAnnotations()) {
            if (!this.isJAXBAnnotation(annotation)) continue;
            return true;
        }
        XmlAccessType accessType = XmlAccessType.PUBLIC_MEMBER;
        XmlAccessorType at = this.findAnnotation(XmlAccessorType.class, (Annotated)m, true, true, true);
        if (at != null) {
            accessType = at.value();
        }
        if (accessType == XmlAccessType.PROPERTY || accessType == XmlAccessType.PUBLIC_MEMBER) {
            return Modifier.isPublic(m.getModifiers());
        }
        return false;
    }

    private <A extends Annotation> A findAnnotation(Class<A> annotationClass, Annotated annotated, boolean includePackage, boolean includeClass, boolean includeSuperclasses) {
        Annotation annotation = annotated.getAnnotation(annotationClass);
        if (annotation != null) {
            return (A)annotation;
        }
        Class memberClass = null;
        if (annotated instanceof AnnotatedParameter) {
            memberClass = ((AnnotatedParameter)annotated).getDeclaringClass();
        } else {
            AnnotatedElement annType = annotated.getAnnotated();
            if (annType instanceof Member) {
                memberClass = ((Member)((Object)annType)).getDeclaringClass();
                if (includeClass && (annotation = memberClass.getAnnotation(annotationClass)) != null) {
                    return (A)annotation;
                }
            } else if (annType instanceof Class) {
                memberClass = (Class)annType;
            }
        }
        if (memberClass != null) {
            Package pkg;
            if (includeSuperclasses) {
                for (Class<?> superclass = memberClass.getSuperclass(); superclass != null && superclass != Object.class; superclass = superclass.getSuperclass()) {
                    annotation = superclass.getAnnotation(annotationClass);
                    if (annotation == null) continue;
                    return (A)annotation;
                }
            }
            if (includePackage && (pkg = memberClass.getPackage()) != null) {
                return memberClass.getPackage().getAnnotation(annotationClass);
            }
        }
        return null;
    }

    protected boolean isJAXBAnnotation(Annotation ann) {
        String pkgName;
        Class<? extends Annotation> cls = ann.annotationType();
        Package pkg = cls.getPackage();
        String string = pkgName = pkg != null ? pkg.getName() : cls.getName();
        return pkgName.startsWith(this._jaxbPackageName);
    }

    private PropertyName findJaxbPropertyName(Annotated ae, Class<?> aeType, String defaultName) {
        boolean hasAName;
        XmlAttribute attribute = (XmlAttribute)ae.getAnnotation(XmlAttribute.class);
        if (attribute != null) {
            return JakartaXmlBindAnnotationIntrospector._combineNames(attribute.name(), attribute.namespace(), defaultName);
        }
        XmlElement element = (XmlElement)ae.getAnnotation(XmlElement.class);
        if (element != null) {
            return JakartaXmlBindAnnotationIntrospector._combineNames(element.name(), element.namespace(), defaultName);
        }
        XmlElementRef elementRef = (XmlElementRef)ae.getAnnotation(XmlElementRef.class);
        boolean bl = hasAName = elementRef != null;
        if (hasAName) {
            XmlRootElement rootElement;
            if (!MARKER_FOR_DEFAULT.equals(elementRef.name())) {
                return JakartaXmlBindAnnotationIntrospector._combineNames(elementRef.name(), elementRef.namespace(), defaultName);
            }
            if (aeType != null && (rootElement = aeType.getAnnotation(XmlRootElement.class)) != null) {
                String name = rootElement.name();
                if (!MARKER_FOR_DEFAULT.equals(name)) {
                    return JakartaXmlBindAnnotationIntrospector._combineNames(name, rootElement.namespace(), defaultName);
                }
                return new PropertyName(this._decapitalize(aeType.getSimpleName()));
            }
        }
        if (!hasAName) {
            hasAName = ae.hasAnnotation(XmlElementWrapper.class) || ae.hasAnnotation(XmlElements.class) || ae.hasAnnotation(XmlValue.class);
        }
        return hasAName ? PropertyName.USE_DEFAULT : null;
    }

    private static PropertyName _combineNames(String localName, String namespace, String defaultName) {
        if (MARKER_FOR_DEFAULT.equals(localName)) {
            if (MARKER_FOR_DEFAULT.equals(namespace)) {
                return new PropertyName(defaultName);
            }
            return new PropertyName(defaultName, namespace);
        }
        if (MARKER_FOR_DEFAULT.equals(namespace)) {
            return new PropertyName(localName);
        }
        return new PropertyName(localName, namespace);
    }

    private XmlRootElement findRootElementAnnotation(AnnotatedClass ac) {
        return this.findAnnotation(XmlRootElement.class, (Annotated)ac, true, false, true);
    }

    private XmlAdapter<Object, Object> findAdapter(MapperConfig<?> config, Annotated am, boolean forSerialization, Class<?> type) {
        XmlAdapter<Object, Object> adapter;
        if (am instanceof AnnotatedClass) {
            return this.findAdapterForClass((AnnotatedClass)am, forSerialization);
        }
        XmlJavaTypeAdapter adapterInfo = this.findAnnotation(XmlJavaTypeAdapter.class, am, true, false, false);
        if (adapterInfo != null && (adapter = this.checkAdapter(config, adapterInfo, type, forSerialization)) != null) {
            return adapter;
        }
        XmlJavaTypeAdapters adapters = this.findAnnotation(XmlJavaTypeAdapters.class, am, true, false, false);
        if (adapters != null) {
            for (XmlJavaTypeAdapter info : adapters.value()) {
                XmlAdapter<Object, Object> adapter2 = this.checkAdapter(config, info, type, forSerialization);
                if (adapter2 == null) continue;
                return adapter2;
            }
        }
        return null;
    }

    private final XmlAdapter<Object, Object> checkAdapter(MapperConfig<?> config, XmlJavaTypeAdapter adapterInfo, Class<?> typeNeeded, boolean forSerialization) {
        Class adaptedType = adapterInfo.type();
        if (adaptedType == XmlJavaTypeAdapter.DEFAULT.class) {
            JavaType type = config.constructType(adapterInfo.value());
            JavaType[] params = config.getTypeFactory().findTypeParameters(type, XmlAdapter.class);
            adaptedType = params[1].getRawClass();
        }
        if (adaptedType.isAssignableFrom(typeNeeded)) {
            Class cls = adapterInfo.value();
            return (XmlAdapter)ClassUtil.createInstance((Class)cls, (boolean)true);
        }
        return null;
    }

    private XmlAdapter<Object, Object> findAdapterForClass(AnnotatedClass ac, boolean forSerialization) {
        XmlJavaTypeAdapter adapterInfo = ac.getAnnotated().getAnnotation(XmlJavaTypeAdapter.class);
        if (adapterInfo != null) {
            Class cls = adapterInfo.value();
            return (XmlAdapter)ClassUtil.createInstance((Class)cls, (boolean)true);
        }
        return null;
    }

    private boolean isContainerType(Class<?> raw) {
        return raw.isArray() || Collection.class.isAssignableFrom(raw) || Map.class.isAssignableFrom(raw);
    }

    protected XmlAdapter<?, ?> _findContentAdapter(MapperConfig<?> config, Annotated ann, boolean forSerialization) {
        JavaType fullType;
        Class contentType;
        AnnotatedMember member;
        XmlAdapter<Object, Object> adapter;
        Class<?> rawType;
        Class<?> clazz = rawType = forSerialization ? this._rawSerializationType(ann) : this._rawDeserializationType(ann);
        if (this.isContainerType(rawType) && ann instanceof AnnotatedMember && (adapter = this.findAdapter(config, (Annotated)(member = (AnnotatedMember)ann), forSerialization, contentType = (fullType = forSerialization ? this._fullSerializationType(member) : this._fullDeserializationType(member)).getContentType().getRawClass())) != null && this.adapterTypeMatches(config, adapter, contentType)) {
            return adapter;
        }
        return null;
    }

    private boolean adapterTypeMatches(MapperConfig<?> config, XmlAdapter<?, ?> adapter, Class<?> targetType) {
        JavaType adapterType = config.constructType(adapter.getClass());
        JavaType[] params = config.getTypeFactory().findTypeParameters(adapterType, XmlAdapter.class);
        Class boundType = params == null || params.length < 2 ? Object.class : params[1].getRawClass();
        return boundType.isAssignableFrom(targetType);
    }

    protected String _propertyNameToString(PropertyName n) {
        return n == null ? null : n.getSimpleName();
    }

    protected Class<?> _rawDeserializationType(Annotated a) {
        AnnotatedMethod am;
        if (a instanceof AnnotatedMethod && (am = (AnnotatedMethod)a).getParameterCount() == 1) {
            return am.getRawParameterType(0);
        }
        return a.getRawType();
    }

    protected JavaType _fullDeserializationType(AnnotatedMember am) {
        AnnotatedMethod method;
        if (am instanceof AnnotatedMethod && (method = (AnnotatedMethod)am).getParameterCount() == 1) {
            return ((AnnotatedMethod)am).getParameterType(0);
        }
        return am.getType();
    }

    protected Class<?> _rawSerializationType(Annotated a) {
        return a.getRawType();
    }

    protected JavaType _fullSerializationType(AnnotatedMember am) {
        return am.getType();
    }

    protected Converter<Object, Object> _converter(MapperConfig<?> config, XmlAdapter<?, ?> adapter, boolean forSerialization) {
        TypeFactory tf = config.getTypeFactory();
        JavaType adapterType = tf.constructType(adapter.getClass());
        JavaType[] pt = tf.findTypeParameters(adapterType, XmlAdapter.class);
        if (forSerialization) {
            return new AdapterConverter(adapter, pt[1], pt[0], forSerialization);
        }
        return new AdapterConverter(adapter, pt[0], pt[1], forSerialization);
    }

    protected Class<?> _getTypeFromXmlElement(Annotated a) {
        XmlElement annotation = this.findAnnotation(XmlElement.class, a, false, false, false);
        if (annotation != null) {
            if (a.getAnnotation(XmlJavaTypeAdapter.class) != null) {
                return null;
            }
            Class type = annotation.type();
            if (type != XmlElement.DEFAULT.class) {
                return type;
            }
        }
        return null;
    }

    protected String _okNameForGetter(AnnotatedMethod am) {
        Class rt;
        String name = am.getName();
        if (name.startsWith("is") && ((rt = am.getRawType()) == Boolean.class || rt == Boolean.TYPE)) {
            return this._stdManglePropertyName(name, 2);
        }
        if (name.startsWith("get")) {
            return this._stdManglePropertyName(name, 3);
        }
        return null;
    }

    protected String _okNameForMutator(AnnotatedMethod am) {
        String name = am.getName();
        if (name.startsWith("set")) {
            return this._stdManglePropertyName(name, 3);
        }
        return null;
    }

    protected String _stdManglePropertyName(String basename, int offset) {
        char c1;
        int end = basename.length();
        if (end == offset) {
            return null;
        }
        char c0 = basename.charAt(offset);
        if (c0 == (c1 = Character.toLowerCase(c0))) {
            return basename.substring(offset);
        }
        if (offset + 1 < end && Character.isUpperCase(basename.charAt(offset + 1))) {
            return basename.substring(offset);
        }
        StringBuilder sb = new StringBuilder(end - offset);
        sb.append(c1);
        sb.append(basename, offset + 1, end);
        return sb.toString();
    }

    protected String _decapitalize(String name) {
        char firstLC;
        char firstOrig;
        if (name.length() > 0 && (firstOrig = name.charAt(0)) != (firstLC = Character.toLowerCase(firstOrig))) {
            if (name.length() == 1) {
                return String.valueOf(firstLC);
            }
            if (!Character.isUpperCase(name.charAt(1))) {
                char[] chars = name.toCharArray();
                chars[0] = Character.toLowerCase(chars[0]);
                return new String(chars);
            }
        }
        return name;
    }
}

