/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.jakarta.xmlbind;

import com.fasterxml.jackson.annotation.JsonInclude;
import tools.jackson.core.Version;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.JacksonModule;
import tools.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationIntrospector;
import tools.jackson.module.jakarta.xmlbind.PackageVersion;

public class JakartaXmlBindAnnotationModule
extends JacksonModule {
    protected Priority _priority = Priority.PRIMARY;
    protected JakartaXmlBindAnnotationIntrospector _introspector;
    protected JsonInclude.Include _nonNillableInclusion;
    protected String _nameUsedForXmlValue = "value";

    public JakartaXmlBindAnnotationModule() {
    }

    public JakartaXmlBindAnnotationModule(JakartaXmlBindAnnotationIntrospector intr) {
        this._introspector = intr;
    }

    public String getModuleName() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    public Version version() {
        return PackageVersion.VERSION;
    }

    public void setupModule(JacksonModule.SetupContext context) {
        JakartaXmlBindAnnotationIntrospector intr = this._introspector;
        if (intr == null) {
            intr = new JakartaXmlBindAnnotationIntrospector();
            if (this._nonNillableInclusion != null) {
                intr.setNonNillableInclusion(this._nonNillableInclusion);
            }
            intr.setNameUsedForXmlValue(this._nameUsedForXmlValue);
        }
        switch (this._priority) {
            case PRIMARY: {
                context.insertAnnotationIntrospector((AnnotationIntrospector)intr);
                break;
            }
            case SECONDARY: {
                context.appendAnnotationIntrospector((AnnotationIntrospector)intr);
            }
        }
    }

    public JakartaXmlBindAnnotationModule setPriority(Priority p) {
        this._priority = p;
        return this;
    }

    public Priority getPriority() {
        return this._priority;
    }

    public JakartaXmlBindAnnotationModule setNonNillableInclusion(JsonInclude.Include incl) {
        this._nonNillableInclusion = incl;
        if (this._introspector != null) {
            this._introspector.setNonNillableInclusion(incl);
        }
        return this;
    }

    public JsonInclude.Include getNonNillableInclusion() {
        return this._nonNillableInclusion;
    }

    public JakartaXmlBindAnnotationModule setNameUsedForXmlValue(String name) {
        this._nameUsedForXmlValue = name;
        return this;
    }

    public String getNameUsedForXmlValue() {
        return this._nameUsedForXmlValue;
    }

    public static enum Priority {
        PRIMARY,
        SECONDARY;

    }
}

