/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.guice;

import com.google.inject.Binder;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.Provider;
import com.google.inject.binder.ScopedBindingBuilder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.List;
import tools.jackson.databind.AnnotationIntrospector;
import tools.jackson.databind.InjectableValues;
import tools.jackson.databind.JacksonModule;
import tools.jackson.databind.ObjectMapper;
import tools.jackson.databind.cfg.MapperBuilder;
import tools.jackson.databind.introspect.AnnotationIntrospectorPair;
import tools.jackson.databind.introspect.JacksonAnnotationIntrospector;
import tools.jackson.databind.json.JsonMapper;
import tools.jackson.module.guice.GuiceAnnotationIntrospector;
import tools.jackson.module.guice.GuiceInjectableValues;

public class ObjectMapperModule
implements Module {
    private final List<JacksonModule> modulesToAdd = new ArrayList<JacksonModule>();
    private final List<Key<? extends JacksonModule>> modulesToInject = new ArrayList<Key<? extends JacksonModule>>();
    private final Key<ObjectMapper> objectMapperKey;
    private ObjectMapper objectMapper;
    private Class<? extends Annotation> scope = null;

    public ObjectMapperModule() {
        this((Key<ObjectMapper>)Key.get(ObjectMapper.class));
    }

    public ObjectMapperModule(Class<? extends Annotation> annotation) {
        this((Key<ObjectMapper>)Key.get(ObjectMapper.class, annotation));
    }

    public ObjectMapperModule(Annotation annotation) {
        this((Key<ObjectMapper>)Key.get(ObjectMapper.class, (Annotation)annotation));
    }

    public ObjectMapperModule(Key<ObjectMapper> objectMapperKey) {
        this.objectMapperKey = objectMapperKey;
    }

    public ObjectMapperModule in(Class<? extends Annotation> scopeAnnotation) {
        this.scope = scopeAnnotation;
        return this;
    }

    public ObjectMapperModule registerModule(JacksonModule module) {
        this.modulesToAdd.add(module);
        return this;
    }

    public ObjectMapperModule registerModule(Class<? extends JacksonModule> clazz) {
        return this.registerModule((Key<? extends JacksonModule>)Key.get(clazz));
    }

    public ObjectMapperModule registerModule(Class<? extends JacksonModule> clazz, Class<? extends Annotation> annotation) {
        return this.registerModule((Key<? extends JacksonModule>)Key.get(clazz, annotation));
    }

    public ObjectMapperModule registerModule(Class<? extends JacksonModule> clazz, Annotation annotation) {
        return this.registerModule((Key<? extends JacksonModule>)Key.get(clazz, (Annotation)annotation));
    }

    public ObjectMapperModule registerModule(Key<? extends JacksonModule> key) {
        this.modulesToInject.add(key);
        return this;
    }

    public ObjectMapperModule withObjectMapper(ObjectMapper m) {
        this.objectMapper = m;
        return this;
    }

    public void configure(Binder binder) {
        ScopedBindingBuilder builder = binder.bind(this.objectMapperKey).toProvider((Provider)new ObjectMapperProvider(this.modulesToInject, this.modulesToAdd, this.objectMapper));
        if (this.scope != null) {
            builder.in(this.scope);
        }
    }

    private static class ObjectMapperProvider
    implements Provider<ObjectMapper> {
        private final List<Key<? extends JacksonModule>> modulesToInject;
        private final List<JacksonModule> modulesToAdd;
        private final List<Provider<? extends JacksonModule>> providedModules;
        private Injector injector;
        private final ObjectMapper objectMapper;

        public ObjectMapperProvider(List<Key<? extends JacksonModule>> modulesToInject, List<JacksonModule> modulesToAdd, ObjectMapper mapper) {
            this.modulesToInject = modulesToInject;
            this.modulesToAdd = modulesToAdd;
            this.objectMapper = mapper;
            this.providedModules = new ArrayList<Provider<? extends JacksonModule>>();
        }

        @Inject
        public void configure(Injector inj) {
            this.injector = inj;
            for (Key<? extends JacksonModule> key : this.modulesToInject) {
                this.providedModules.add((Provider<? extends JacksonModule>)this.injector.getProvider(key));
            }
        }

        public ObjectMapper get() {
            ObjectMapper mapper = this.objectMapper;
            if (mapper == null) {
                GuiceAnnotationIntrospector guiceIntrospector = new GuiceAnnotationIntrospector();
                JacksonAnnotationIntrospector defaultAI = new JacksonAnnotationIntrospector();
                MapperBuilder builder = ((JsonMapper.Builder)((JsonMapper.Builder)JsonMapper.builder().injectableValues((InjectableValues)new GuiceInjectableValues(this.injector))).annotationIntrospector((AnnotationIntrospector)new AnnotationIntrospectorPair((AnnotationIntrospector)guiceIntrospector, (AnnotationIntrospector)defaultAI))).addModules(this.modulesToAdd);
                for (Provider<? extends JacksonModule> provider : this.providedModules) {
                    builder = builder.addModule((JacksonModule)provider.get());
                }
                mapper = builder.build();
            }
            return mapper;
        }
    }
}

