/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.blackbird.deser;

import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.module.blackbird.deser.ObjBooleanConsumer;
import tools.jackson.module.blackbird.deser.OptimizedSettableBeanProperty;

final class SettableBooleanProperty
extends OptimizedSettableBeanProperty<SettableBooleanProperty> {
    private static final long serialVersionUID = 1L;
    private ObjBooleanConsumer _optimizedSetter;

    public SettableBooleanProperty(SettableBeanProperty src, ObjBooleanConsumer optimizedSetter) {
        super(src);
        this._optimizedSetter = optimizedSetter;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableBooleanProperty(del, this._optimizedSetter);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        boolean b;
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            b = true;
        } else if (t == JsonToken.VALUE_FALSE) {
            b = false;
        } else {
            this.delegate.deserializeAndSet(p, ctxt, bean);
            return;
        }
        try {
            this._optimizedSetter.accept(bean, b);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, b, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        JsonToken t = p.currentToken();
        if (t == JsonToken.VALUE_TRUE) {
            return this.setAndReturn(ctxt, instance, Boolean.TRUE);
        }
        if (t == JsonToken.VALUE_FALSE) {
            return this.setAndReturn(ctxt, instance, Boolean.FALSE);
        }
        return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
    }

    @Override
    public void set(DeserializationContext ctxt, Object bean, Object value) {
        boolean b = (Boolean)value;
        try {
            this._optimizedSetter.accept(bean, b);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, b, e);
        }
    }
}

