/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.blackbird.ser;

import java.util.function.ToLongFunction;
import tools.jackson.core.JsonGenerator;
import tools.jackson.databind.PropertyName;
import tools.jackson.databind.SerializationContext;
import tools.jackson.databind.ValueSerializer;
import tools.jackson.databind.ser.BeanPropertyWriter;
import tools.jackson.module.blackbird.ser.OptimizedBeanPropertyWriter;

final class LongPropertyWriter
extends OptimizedBeanPropertyWriter<LongPropertyWriter> {
    private static final long serialVersionUID = 1L;
    private final long _suppressableLong;
    private final boolean _suppressableSet;
    private final ToLongFunction<Object> _acc;

    public LongPropertyWriter(BeanPropertyWriter src, ToLongFunction<Object> acc, ValueSerializer<Object> ser) {
        super(src, ser);
        this._acc = acc;
        if (this._suppressableValue instanceof Long) {
            this._suppressableLong = (Long)this._suppressableValue;
            this._suppressableSet = true;
        } else {
            this._suppressableLong = 0L;
            this._suppressableSet = false;
        }
    }

    protected LongPropertyWriter(LongPropertyWriter base, PropertyName name) {
        super(base, name);
        this._suppressableSet = base._suppressableSet;
        this._suppressableLong = base._suppressableLong;
        this._acc = base._acc;
    }

    @Override
    protected BeanPropertyWriter _new(PropertyName newName) {
        return new LongPropertyWriter(this, newName);
    }

    @Override
    public BeanPropertyWriter withSerializer(ValueSerializer<Object> ser) {
        return new LongPropertyWriter(this, this._acc, ser);
    }

    @Override
    public final void serializeAsProperty(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        long value;
        if (this.broken) {
            this.fallbackWriter.serializeAsProperty(bean, g, ctxt);
            return;
        }
        try {
            value = this._acc.applyAsLong(bean);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, false);
            return;
        }
        if (!this._suppressableSet || this._suppressableLong != value) {
            g.writeName(this._fastName);
            g.writeNumber(value);
        }
    }

    @Override
    public final void serializeAsElement(Object bean, JsonGenerator g, SerializationContext ctxt) throws Exception {
        long value;
        if (this.broken) {
            this.fallbackWriter.serializeAsElement(bean, g, ctxt);
            return;
        }
        try {
            value = this._acc.applyAsLong(bean);
        }
        catch (Throwable t) {
            this._handleProblem(bean, g, ctxt, t, false);
            return;
        }
        if (!this._suppressableSet || this._suppressableLong != value) {
            g.writeNumber(value);
        } else {
            this.serializeAsOmittedElement(bean, g, ctxt);
        }
    }
}

