/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.blackbird.deser;

import java.util.function.ObjLongConsumer;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.module.blackbird.deser.OptimizedSettableBeanProperty;

final class SettableLongProperty
extends OptimizedSettableBeanProperty<SettableLongProperty> {
    private static final long serialVersionUID = 1L;
    private ObjLongConsumer<Object> _optimizedSetter;

    public SettableLongProperty(SettableBeanProperty src, ObjLongConsumer<Object> optimizedSetter) {
        super(src);
        this._optimizedSetter = optimizedSetter;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableLongProperty(del, this._optimizedSetter);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        if (!p.isExpectedNumberIntToken()) {
            this.delegate.deserializeAndSet(p, ctxt, bean);
            return;
        }
        long v = p.getLongValue();
        try {
            this._optimizedSetter.accept(bean, v);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, v, e);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        if (p.isExpectedNumberIntToken()) {
            return this.setAndReturn(ctxt, instance, p.getLongValue());
        }
        return this.delegate.deserializeSetAndReturn(p, ctxt, instance);
    }

    @Override
    public void set(DeserializationContext ctxt, Object bean, Object value) {
        long v = ((Number)value).longValue();
        try {
            this._optimizedSetter.accept(bean, v);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, v, e);
        }
    }
}

