/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.blackbird.deser;

import java.util.function.Function;
import java.util.function.Supplier;
import tools.jackson.core.JacksonException;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.std.StdValueInstantiator;

class OptimizedValueInstantiator
extends StdValueInstantiator {
    private final Supplier<?> _optimizedDefaultCreator;
    private final Function<Object[], Object> _optimizedArgsCreator;

    protected OptimizedValueInstantiator(StdValueInstantiator original, Supplier<?> defaultCreator, Function<Object[], Object> argsCreator) {
        super(original);
        this._optimizedDefaultCreator = defaultCreator;
        this._optimizedArgsCreator = argsCreator;
    }

    public boolean canCreateUsingDefault() {
        return this._optimizedDefaultCreator != null || super.canCreateUsingDefault();
    }

    public boolean canCreateFromObjectWith() {
        return this._optimizedArgsCreator != null || super.canCreateFromObjectWith();
    }

    public Object createUsingDefault(DeserializationContext ctxt) throws JacksonException {
        if (this._optimizedDefaultCreator != null) {
            try {
                return this._optimizedDefaultCreator.get();
            }
            catch (Exception e) {
                return ctxt.handleInstantiationProblem(this._valueClass, null, (Throwable)e);
            }
        }
        return super.createUsingDefault(ctxt);
    }

    public Object createFromObjectWith(DeserializationContext ctxt, Object[] args) throws JacksonException {
        if (this._optimizedArgsCreator != null) {
            try {
                return this._optimizedArgsCreator.apply(args);
            }
            catch (Exception e) {
                return ctxt.handleInstantiationProblem(this._valueClass, (Object)args, (Throwable)e);
            }
        }
        return super.createFromObjectWith(ctxt, args);
    }
}

