/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.blackbird.deser;

import java.util.ArrayList;
import java.util.List;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.core.SerializableString;
import tools.jackson.core.io.SerializedString;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.ValueDeserializer;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.databind.deser.bean.BeanDeserializer;
import tools.jackson.databind.deser.bean.BeanPropertyMap;
import tools.jackson.databind.deser.bean.PropertyBasedCreator;
import tools.jackson.databind.deser.impl.UnwrappedPropertyHandler;
import tools.jackson.databind.util.NameTransformer;

final class SuperSonicBeanDeserializer
extends BeanDeserializer {
    protected final SerializedString[] _orderedPropertyNames;
    protected SettableBeanProperty[] _orderedProperties;

    public SuperSonicBeanDeserializer(BeanDeserializer src, List<SettableBeanProperty> props) {
        super(src);
        int len = props.size();
        this._orderedPropertyNames = new SerializedString[len];
        for (int i = 0; i < len; ++i) {
            this._orderedPropertyNames[i] = new SerializedString(props.get(i).getName());
        }
    }

    protected SuperSonicBeanDeserializer(SuperSonicBeanDeserializer src, UnwrappedPropertyHandler unwrapHandler, PropertyBasedCreator propertyBasedCreator, BeanPropertyMap renamedProperties, boolean ignoreAllUnknown) {
        super((BeanDeserializer)src, unwrapHandler, propertyBasedCreator, renamedProperties, ignoreAllUnknown);
        this._orderedPropertyNames = src._orderedPropertyNames;
        this._orderedProperties = src._orderedProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ValueDeserializer<Object> unwrappingDeserializer(DeserializationContext ctxt, NameTransformer transformer) {
        if (this._currentlyTransforming == transformer) {
            return this;
        }
        this._currentlyTransforming = transformer;
        try {
            PropertyBasedCreator pbCreator;
            UnwrappedPropertyHandler uwHandler = this._unwrappedPropertyHandler;
            if (uwHandler != null) {
                uwHandler = uwHandler.renameAll(ctxt, transformer);
            }
            if ((pbCreator = this._propertyBasedCreator) != null) {
                pbCreator = pbCreator.renameAll(ctxt, transformer);
            }
            SuperSonicBeanDeserializer superSonicBeanDeserializer = new SuperSonicBeanDeserializer(this, uwHandler, pbCreator, this._beanProperties.renameAll(ctxt, transformer), true);
            return superSonicBeanDeserializer;
        }
        finally {
            this._currentlyTransforming = null;
        }
    }

    public void resolve(DeserializationContext ctxt) {
        int i;
        super.resolve(ctxt);
        if (this._externalTypeIdHandler != null || this._unwrappedPropertyHandler != null) {
            return;
        }
        int len = this._orderedPropertyNames.length;
        ArrayList<SettableBeanProperty> props = new ArrayList<SettableBeanProperty>(len);
        for (i = 0; i < len; ++i) {
            SettableBeanProperty prop = this._beanProperties.findDefinition(this._orderedPropertyNames[i].toString());
            if (prop == null) continue;
            props.add(prop);
        }
        if (i == 0) {
            throw new IllegalStateException("Blackbird internal error: BeanDeserializer for " + String.valueOf(this._beanType) + " has no properties that match expected ordering (should have " + len + ") -- can not create optimized deserializer");
        }
        this._orderedProperties = props.toArray(new SettableBeanProperty[0]);
    }

    public Object deserialize(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        Object id;
        if (!this._vanillaProcessing || this._objectIdReader != null) {
            return super.deserialize(p, ctxt);
        }
        if (!p.isExpectedStartObjectToken()) {
            return this._deserializeOther(p, ctxt, p.currentToken());
        }
        if (this._nonStandardCreation) {
            p.nextToken();
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(p, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(p, ctxt);
            }
            Object bean = this.deserializeFromObjectUsingNonDefault(p, ctxt);
            if (this._injectables != null) {
                this.injectValues(ctxt, bean);
            }
            return bean;
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.assignCurrentValue(bean);
        if (p.canReadObjectId() && (id = p.getObjectId()) != null) {
            this._handleTypedObjectId(p, ctxt, bean, id);
        }
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        int len = this._orderedProperties.length;
        for (int i = 0; i < len; ++i) {
            SettableBeanProperty prop = this._orderedProperties[i];
            if (!p.nextName((SerializableString)this._orderedPropertyNames[i])) {
                if (p.currentToken() == JsonToken.END_OBJECT) {
                    return bean;
                }
                return super.deserialize(p, ctxt, bean);
            }
            p.nextToken();
            try {
                prop.deserializeAndSet(p, ctxt, bean);
                continue;
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
        }
        if (p.nextToken() != JsonToken.END_OBJECT) {
            return super.deserialize(p, ctxt, bean);
        }
        return bean;
    }

    public final Object deserialize(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        p.assignCurrentValue(bean);
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        if (this._unwrappedPropertyHandler != null) {
            return this.deserializeWithUnwrapped(p, ctxt, bean);
        }
        if (this._externalTypeIdHandler != null) {
            return this.deserializeWithExternalTypeId(p, ctxt, bean);
        }
        SettableBeanProperty prop = this._orderedProperties[0];
        if (p.isExpectedStartObjectToken() ? !p.nextName((SerializableString)this._orderedPropertyNames[0]) : !p.hasToken(JsonToken.PROPERTY_NAME) || !prop.getName().equals(p.currentName())) {
            return super.deserialize(p, ctxt, bean);
        }
        p.nextToken();
        try {
            prop.deserializeAndSet(p, ctxt, bean);
        }
        catch (Exception e) {
            this.wrapAndThrow(e, bean, prop.getName(), ctxt);
        }
        int len = this._orderedProperties.length;
        for (int i = 1; i < len; ++i) {
            if (!p.nextName((SerializableString)this._orderedPropertyNames[i])) {
                if (p.hasToken(JsonToken.END_OBJECT)) {
                    return bean;
                }
                return super.deserialize(p, ctxt, bean);
            }
            prop = this._orderedProperties[i];
            p.nextToken();
            try {
                prop.deserializeAndSet(p, ctxt, bean);
                continue;
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
        }
        if (p.nextToken() != JsonToken.END_OBJECT) {
            return super.deserialize(p, ctxt, bean);
        }
        return bean;
    }

    public final Object deserializeFromObject(JsonParser p, DeserializationContext ctxt) throws JacksonException {
        Object id;
        if (this._objectIdReader != null && this._objectIdReader.maySerializeAsObject() && p.hasTokenId(5) && this._objectIdReader.isValidReferencePropertyName(p.currentName(), p)) {
            return this.deserializeFromObjectId(p, ctxt);
        }
        if (this._nonStandardCreation) {
            if (this._unwrappedPropertyHandler != null) {
                return this.deserializeWithUnwrapped(p, ctxt);
            }
            if (this._externalTypeIdHandler != null) {
                return this.deserializeWithExternalTypeId(p, ctxt);
            }
            Object bean = this.deserializeFromObjectUsingNonDefault(p, ctxt);
            if (this._injectables != null) {
                this.injectValues(ctxt, bean);
            }
            return bean;
        }
        Object bean = this._valueInstantiator.createUsingDefault(ctxt);
        p.assignCurrentValue(bean);
        if (p.canReadObjectId() && (id = p.getObjectId()) != null) {
            this._handleTypedObjectId(p, ctxt, bean, id);
        }
        if (this._injectables != null) {
            this.injectValues(ctxt, bean);
        }
        SettableBeanProperty prop = this._orderedProperties[0];
        if (p.isExpectedStartObjectToken() ? !p.nextName((SerializableString)this._orderedPropertyNames[0]) : !p.hasToken(JsonToken.PROPERTY_NAME) || !prop.getName().equals(p.currentName())) {
            return super.deserialize(p, ctxt, bean);
        }
        p.nextToken();
        try {
            prop.deserializeAndSet(p, ctxt, bean);
        }
        catch (Exception e) {
            this.wrapAndThrow(e, bean, prop.getName(), ctxt);
        }
        int len = this._orderedProperties.length;
        for (int i = 1; i < len; ++i) {
            prop = this._orderedProperties[i];
            if (!p.nextName((SerializableString)this._orderedPropertyNames[i])) {
                if (p.hasToken(JsonToken.END_OBJECT)) {
                    return bean;
                }
                return super.deserialize(p, ctxt, bean);
            }
            p.nextToken();
            try {
                prop.deserializeAndSet(p, ctxt, bean);
                continue;
            }
            catch (Exception e) {
                this.wrapAndThrow(e, bean, prop.getName(), ctxt);
            }
        }
        if (p.nextToken() != JsonToken.END_OBJECT) {
            return super.deserialize(p, ctxt, bean);
        }
        return bean;
    }
}

