/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.blackbird.deser;

import java.util.function.BiConsumer;
import tools.jackson.core.JacksonException;
import tools.jackson.core.JsonParser;
import tools.jackson.core.JsonToken;
import tools.jackson.databind.DeserializationContext;
import tools.jackson.databind.deser.SettableBeanProperty;
import tools.jackson.module.blackbird.deser.OptimizedSettableBeanProperty;

final class SettableObjectProperty
extends OptimizedSettableBeanProperty<SettableObjectProperty> {
    private static final long serialVersionUID = 1L;
    private BiConsumer<Object, Object> _optimizedSetter;

    public SettableObjectProperty(SettableBeanProperty src, BiConsumer<Object, Object> optimizedSetter) {
        super(src);
        this._optimizedSetter = optimizedSetter;
    }

    @Override
    protected SettableBeanProperty withDelegate(SettableBeanProperty del) {
        return new SettableObjectProperty(del, this._optimizedSetter);
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object bean) throws JacksonException {
        Object value;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return;
            }
            value = this._nullProvider.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer == null) {
            value = this._valueDeserializer.deserialize(p, ctxt);
            if (value == null) {
                if (this._skipNulls) {
                    return;
                }
                value = this._nullProvider.getNullValue(ctxt);
            }
        } else {
            value = this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        }
        this.set(ctxt, bean, value);
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws JacksonException {
        Object value;
        if (p.hasToken(JsonToken.VALUE_NULL)) {
            if (this._skipNulls) {
                return instance;
            }
            value = this._nullProvider.getNullValue(ctxt);
        } else if (this._valueTypeDeserializer == null) {
            value = this._valueDeserializer.deserialize(p, ctxt);
            if (value == null) {
                if (this._skipNulls) {
                    return instance;
                }
                value = this._nullProvider.getNullValue(ctxt);
            }
        } else {
            value = this._valueDeserializer.deserializeWithType(p, ctxt, this._valueTypeDeserializer);
        }
        return this.setAndReturn(ctxt, instance, value);
    }

    @Override
    public void set(DeserializationContext ctxt, Object bean, Object v) {
        try {
            this._optimizedSetter.accept(bean, v);
        }
        catch (Throwable e) {
            this._reportProblem(ctxt, bean, v, e);
        }
    }
}

