/*
 * Decompiled with CFR 0.152.
 */
package tools.jackson.module.blackbird;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.MethodHandles;
import java.lang.invoke.MethodType;
import java.util.function.UnaryOperator;

class CrossLoaderAccess
implements UnaryOperator<MethodHandles.Lookup> {
    private static final MethodHandle DEFINE_CLASS;
    private static final MethodHandle HAS_FULL_ACCESS;
    private static final String CLASS_NAME = "$$JacksonBlackbirdAccess";
    private static final int[] HEADER;
    private static final int[] FOOTER;

    CrossLoaderAccess() {
    }

    @Override
    public MethodHandles.Lookup apply(MethodHandles.Lookup lookup) {
        try {
            return CrossLoaderAccess.grantAccess(lookup);
        }
        catch (IOException | ReflectiveOperationException | RuntimeException e) {
            e.printStackTrace();
            return lookup;
        }
    }

    private static MethodHandles.Lookup grantAccess(MethodHandles.Lookup lookup) throws IOException, ReflectiveOperationException {
        if (DEFINE_CLASS == null || CrossLoaderAccess.hasFullAccess(lookup)) {
            return lookup;
        }
        return (MethodHandles.Lookup)CrossLoaderAccess.accessClassIn(lookup).getField("LOOKUP").get(null);
    }

    private static boolean hasFullAccess(MethodHandles.Lookup lookup) {
        try {
            return HAS_FULL_ACCESS != null && HAS_FULL_ACCESS.invokeExact(lookup);
        }
        catch (Error | RuntimeException e) {
            throw e;
        }
        catch (Throwable e) {
            throw new RuntimeException(e);
        }
    }

    private static Class<?> accessClassIn(MethodHandles.Lookup lookup) throws IOException, ReflectiveOperationException {
        Package pkg = lookup.lookupClass().getPackage();
        String accessClassName = pkg.getName() + ".$$JacksonBlackbirdAccess";
        ClassLoader lookupClassLoader = lookup.lookupClass().getClassLoader();
        try {
            return Class.forName(accessClassName, true, lookupClassLoader);
        }
        catch (ClassNotFoundException classNotFoundException) {
            Class<CrossLoaderAccess> clazz = CrossLoaderAccess.class;
            synchronized (CrossLoaderAccess.class) {
                try {
                    // ** MonitorExit[var4_5] (shouldn't be in output)
                    return Class.forName(accessClassName, true, lookupClassLoader);
                }
                catch (ClassNotFoundException classNotFoundException2) {
                    String fqcn = pkg.getName().replace('.', '/') + "/$$JacksonBlackbirdAccess";
                    ByteArrayOutputStream classBytes = new ByteArrayOutputStream(HEADER.length + FOOTER.length + fqcn.length() + 16);
                    DataOutputStream dataOut = new DataOutputStream(classBytes);
                    for (int b : HEADER) {
                        dataOut.writeByte(b);
                    }
                    dataOut.writeUTF(fqcn);
                    for (int b : FOOTER) {
                        dataOut.writeByte(b);
                    }
                    try {
                        // ** MonitorExit[var4_5] (shouldn't be in output)
                        return DEFINE_CLASS.invokeExact(lookup, classBytes.toByteArray());
                    }
                    catch (IOException | Error | ReflectiveOperationException | RuntimeException e) {
                        throw e;
                    }
                    catch (Throwable e) {
                        throw new RuntimeException(e);
                    }
                }
            }
        }
    }

    static {
        HEADER = new int[]{202, 254, 186, 190, 0, 0, 0, 52, 0, 28, 10, 0, 2, 0, 3, 7, 0, 4, 12, 0, 5, 0, 6, 1, 0, 16, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 79, 98, 106, 101, 99, 116, 1, 0, 6, 60, 105, 110, 105, 116, 62, 1, 0, 3, 40, 41, 86, 10, 0, 8, 0, 9, 7, 0, 10, 12, 0, 11, 0, 12, 1, 0, 30, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 105, 110, 118, 111, 107, 101, 47, 77, 101, 116, 104, 111, 100, 72, 97, 110, 100, 108, 101, 115, 1, 0, 6, 108, 111, 111, 107, 117, 112, 1, 0, 41, 40, 41, 76, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 105, 110, 118, 111, 107, 101, 47, 77, 101, 116, 104, 111, 100, 72, 97, 110, 100, 108, 101, 115, 36, 76, 111, 111, 107, 117, 112, 59, 9, 0, 14, 0, 15, 7, 0, 16, 12, 0, 17, 0, 18, 1};
        FOOTER = new int[]{1, 0, 6, 76, 79, 79, 75, 85, 80, 1, 0, 39, 76, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 105, 110, 118, 111, 107, 101, 47, 77, 101, 116, 104, 111, 100, 72, 97, 110, 100, 108, 101, 115, 36, 76, 111, 111, 107, 117, 112, 59, 1, 0, 4, 67, 111, 100, 101, 1, 0, 15, 76, 105, 110, 101, 78, 117, 109, 98, 101, 114, 84, 97, 98, 108, 101, 1, 0, 8, 60, 99, 108, 105, 110, 105, 116, 62, 1, 0, 10, 83, 111, 117, 114, 99, 101, 70, 105, 108, 101, 1, 0, 20, 66, 108, 97, 99, 107, 98, 105, 114, 100, 65, 99, 99, 101, 115, 115, 46, 106, 97, 118, 97, 1, 0, 12, 73, 110, 110, 101, 114, 67, 108, 97, 115, 115, 101, 115, 7, 0, 26, 1, 0, 37, 106, 97, 118, 97, 47, 108, 97, 110, 103, 47, 105, 110, 118, 111, 107, 101, 47, 77, 101, 116, 104, 111, 100, 72, 97, 110, 100, 108, 101, 115, 36, 76, 111, 111, 107, 117, 112, 1, 0, 6, 76, 111, 111, 107, 117, 112, 0, 33, 0, 14, 0, 2, 0, 0, 0, 1, 0, 25, 0, 17, 0, 18, 0, 0, 0, 2, 0, 1, 0, 5, 0, 6, 0, 1, 0, 19, 0, 0, 0, 29, 0, 1, 0, 1, 0, 0, 0, 5, 42, 183, 0, 1, 177, 0, 0, 0, 1, 0, 20, 0, 0, 0, 6, 0, 1, 0, 0, 0, 1, 0, 8, 0, 21, 0, 6, 0, 1, 0, 19, 0, 0, 0, 31, 0, 1, 0, 0, 0, 0, 0, 7, 184, 0, 7, 179, 0, 13, 177, 0, 0, 0, 1, 0, 20, 0, 0, 0, 6, 0, 1, 0, 0, 0, 1, 0, 2, 0, 22, 0, 0, 0, 2, 0, 23, 0, 24, 0, 0, 0, 10, 0, 1, 0, 25, 0, 8, 0, 27, 0, 25};
        MethodHandle defineClass = null;
        MethodHandle hasFullAccess = null;
        try {
            defineClass = MethodHandles.lookup().findVirtual(MethodHandles.Lookup.class, "defineClass", MethodType.methodType(Class.class, byte[].class));
            hasFullAccess = MethodHandles.lookup().findVirtual(MethodHandles.Lookup.class, "hasFullPrivilegeAccess", MethodType.methodType(Boolean.TYPE));
        }
        catch (ReflectiveOperationException reflectiveOperationException) {
            // empty catch block
        }
        DEFINE_CLASS = defineClass;
        HAS_FULL_ACCESS = hasFullAccess;
    }
}

